/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.block;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nihiltres.engineersdoors.EngineersDoors;
import nihiltres.engineersdoors.common.EDConfig;
import nihiltres.engineersdoors.common.block.IQuickSetup;
import nihiltres.engineersdoors.common.item.IOre;
import nihiltres.engineersdoors.common.item.ItemEDDoor;

public class BlockEDDoor
extends BlockDoor
implements IQuickSetup,
IOre {
    public String name;
    public TreeSet<String> oreNames = new TreeSet();
    public boolean opensManually = true;
    public boolean field_149785_s = false;
    public ItemEDDoor item;
    private static boolean quarkDoubleDoors = false;
    private static final ResourceLocation STONE_DOOR_OPEN_RL = new ResourceLocation("engineersdoors", "stone_door_open");
    private static final ResourceLocation STONE_DOOR_CLOSE_RL = new ResourceLocation("engineersdoors", "stone_door_close");
    public static final SoundEvent STONE_DOOR_OPEN = (SoundEvent)new SoundEvent(STONE_DOOR_OPEN_RL).setRegistryName(STONE_DOOR_OPEN_RL);
    public static final SoundEvent STONE_DOOR_CLOSE = (SoundEvent)new SoundEvent(STONE_DOOR_CLOSE_RL).setRegistryName(STONE_DOOR_CLOSE_RL);
    private static final Map<Material, Integer> soundMap = new HashMap<Material, Integer>();

    private BlockEDDoor(Material materialIn, @Nonnull String nameIn) {
        super(materialIn == null ? Material.field_151575_d : materialIn);
        if (!soundMap.containsKey(this.field_149764_J)) {
            EngineersDoors.debug("Door with unsupported material initialized; it'll use wood sound as default");
        }
        this.opensManually = this.field_149764_J != Material.field_151573_f;
        this.name = nameIn;
        ((Block)this.setRegistryName(this.name)).func_149663_c(this.name);
    }

    public BlockEDDoor(Material materialIn, String nameIn, @Nonnull String oreNameIn) {
        this(materialIn, nameIn);
        this.oreNames.add(oreNameIn);
        this.item = new ItemEDDoor((Block)this, nameIn, oreNameIn);
    }

    public BlockEDDoor(Material materialIn, String nameIn, String oreNameIn, boolean manual) {
        this(materialIn, nameIn, oreNameIn);
        this.opensManually = manual;
    }

    public BlockEDDoor(Material materialIn, String nameIn, @Nonnull Collection<String> oreNamesIn) {
        this(materialIn, nameIn);
        if (oreNamesIn.isEmpty()) {
            throw new IllegalArgumentException("Ore name list cannot be empty");
        }
        this.oreNames.addAll(oreNamesIn);
        this.item = new ItemEDDoor((Block)this, nameIn, oreNamesIn);
    }

    public BlockEDDoor(Material materialIn, String nameIn, Collection<String> oreNamesIn, boolean manual) {
        this(materialIn, nameIn, oreNamesIn);
        this.opensManually = manual;
    }

    public BlockEDDoor(String nameIn, @Nonnull BlockEDDoor otherDoor) {
        this(otherDoor.field_149764_J, nameIn);
        this.oreNames.addAll(otherDoor.oreNames);
        this.opensManually = otherDoor.opensManually;
        this.item = new ItemEDDoor((Block)this, nameIn, otherDoor.oreNames);
        this.setBlockProperties(otherDoor.field_149782_v, otherDoor.field_149781_w, otherDoor.getHarvestTool(otherDoor.func_176223_P()), otherDoor.getHarvestLevel(otherDoor.func_176223_P()));
    }

    @Override
    public BlockEDDoor setBlockProperties(float hardness, float resistance, String harvestTool, int harvestLevel) {
        this.func_149711_c(hardness).func_149752_b(resistance).setHarvestLevel(harvestTool, harvestLevel);
        return this;
    }

    @Override
    public Set<String> getOreNames() {
        return this.oreNames;
    }

    @Override
    public BlockEDDoor addOreName(String oreNameIn) {
        this.oreNames.add(oreNameIn);
        this.item.addOreName(oreNameIn);
        return this;
    }

    @Override
    public BlockEDDoor addOreNames(Collection<String> oreNamesIn) {
        this.oreNames.addAll(oreNamesIn);
        this.item.addOreNames((Collection)oreNamesIn);
        return this;
    }

    public boolean toggleOpen(@Nullable EntityPlayer playerIn, World worldIn, BlockPos posIn, IBlockState state, EnumFacing facing) {
        IBlockState stateAtPos;
        BlockPos pos = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? posIn : posIn.func_177977_b();
        IBlockState iBlockState = stateAtPos = posIn.equals((Object)pos) ? state : worldIn.func_180495_p(pos);
        if (!(stateAtPos.func_177230_c() instanceof BlockDoor)) {
            return false;
        }
        IBlockState newState = stateAtPos.func_177231_a((IProperty)field_176519_b);
        Material stateMat = state.func_185904_a();
        boolean isOpening = (Boolean)newState.func_177229_b((IProperty)field_176519_b);
        worldIn.func_180501_a(pos, newState, 10);
        worldIn.func_175704_b(pos, posIn);
        switch (soundMap.getOrDefault(stateMat, -1)) {
            case 0: {
                worldIn.func_180498_a(playerIn, isOpening ? 1011 : 1005, pos, 0);
                break;
            }
            case 1: {
                worldIn.func_184133_a(playerIn, pos, isOpening ? STONE_DOOR_OPEN : STONE_DOOR_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                break;
            }
            default: {
                worldIn.func_180498_a(playerIn, isOpening ? 1012 : 1006, pos, 0);
            }
        }
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.opensManually && !EDConfig.manualSteelDoors) {
            return false;
        }
        if (quarkDoubleDoors && EDConfig.manualSteelDoors && !playerIn.func_70093_af() && this.field_149764_J == Material.field_151573_f) {
            IBlockState actualState = state.func_185899_b((IBlockAccess)worldIn, pos);
            boolean isOpen = (Boolean)actualState.func_177229_b((IProperty)BlockDoor.field_176519_b);
            EnumFacing direction = (EnumFacing)actualState.func_177229_b((IProperty)BlockDoor.field_176520_a);
            BlockDoor.EnumHingePosition hinge = (BlockDoor.EnumHingePosition)actualState.func_177229_b((IProperty)BlockDoor.field_176521_M);
            BlockPos mirrorPos = pos.func_177972_a(hinge == BlockDoor.EnumHingePosition.RIGHT ? direction.func_176735_f() : direction.func_176746_e());
            IBlockState other = worldIn.func_180495_p(mirrorPos).func_185899_b((IBlockAccess)worldIn, mirrorPos);
            if (other.func_177230_c() instanceof BlockDoor && other.func_177229_b((IProperty)BlockDoor.field_176520_a) == direction && (Boolean)other.func_177229_b((IProperty)BlockDoor.field_176519_b) == isOpen && other.func_177229_b((IProperty)BlockDoor.field_176521_M) != hinge) {
                boolean flag = this.toggleOpen(playerIn, worldIn, pos, state, facing);
                if (flag) {
                    this.toggleOpen(playerIn, worldIn, mirrorPos, other, facing);
                }
                return flag;
            }
        }
        return this.toggleOpen(playerIn, worldIn, pos, state, facing);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : this.item;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Item)this.item);
    }

    public static void checkForQuarkDoubleDoors() {
        if (Loader.isModLoaded((String)"quark")) {
            try {
                Method qIsFeatureEnabled = Class.forName("vazkii.quark.base.module.ModuleLoader").getMethod("isFeatureEnabled", Class.class);
                Class<?> qDoubleDoorsClass = Class.forName("vazkii.quark.tweaks.feature.DoubleDoors");
                boolean oldQDD = quarkDoubleDoors;
                quarkDoubleDoors = (Boolean)qIsFeatureEnabled.invoke(null, qDoubleDoorsClass);
                if (quarkDoubleDoors && !oldQDD) {
                    EngineersDoors.log("Quark double-door compatibility enabled");
                }
                if (oldQDD && !quarkDoubleDoors) {
                    EngineersDoors.log("Quark double-door compatibility disabled");
                }
            }
            catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException throwable) {
                // empty catch block
            }
        }
    }

    public BlockEDDoor setTranslucent() {
        return this.setTranslucent(true);
    }

    public BlockEDDoor setTranslucent(boolean val) {
        this.field_149785_s = val;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.field_149785_s ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    static {
        soundMap.put(Material.field_151575_d, -1);
        soundMap.put(Material.field_151573_f, 0);
        soundMap.put(Material.field_151576_e, 1);
    }
}

