/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.item.upgrade;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import com.latmod.yabba.api.UpgradeData;
import com.latmod.yabba.item.upgrade.ItemUpgrade;
import com.latmod.yabba.tile.Barrel;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ItemUpgradeRedstone
extends ItemUpgrade {
    @Override
    public UpgradeData initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new RedstoneUpgradeData(stack);
    }

    public static class RedstoneUpgradeData
    extends UpgradeData {
        public Mode mode = Mode.GREATER_THAN_OR_EQUAL;
        public int count = 1;

        public RedstoneUpgradeData(ItemStack is) {
            super(is);
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.mode != Mode.GREATER_THAN_OR_EQUAL) {
                nbt.func_74778_a("Mode", this.mode.func_176610_l());
            }
            if (this.count != 1) {
                nbt.func_74768_a("Count", this.count);
            }
            return nbt;
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
            this.mode = (Mode)((Object)Mode.NAME_MAP.get(nbt.func_74779_i("Mode")));
            this.count = nbt.func_74764_b("Count") ? nbt.func_74762_e("Count") : 1;
        }

        @Override
        public boolean hasData() {
            return this.mode != Mode.GREATER_THAN_OR_EQUAL || this.count != 1;
        }

        @Override
        public void resetData() {
            this.mode = Mode.GREATER_THAN_OR_EQUAL;
            this.count = 1;
        }

        public int redstoneOutput(int amount) {
            return this.mode.matchesCount(amount, this.count) ? 15 : 0;
        }

        @Override
        public void getConfig(Barrel barrel, ConfigGroup config) {
            config.addEnum("mode", () -> this.mode, v -> {
                this.mode = v;
            }, Mode.NAME_MAP).setDisplayName((ITextComponent)new TextComponentTranslation("barrel_config.redstone.mode", new Object[0]));
            config.addInt("count", () -> this.count, v -> {
                this.count = v;
            }, 1, 0, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("barrel_config.redstone.count", new Object[0]));
        }
    }

    public static enum Mode implements IStringSerializable
    {
        EQUAL("=="),
        NOT("!="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<=");

        public static final NameMap<Mode> NAME_MAP;
        private final String name;

        private Mode(String s) {
            this.name = s;
        }

        public String func_176610_l() {
            return this.name;
        }

        public boolean matchesCount(int items1, int items2) {
            switch (this) {
                case EQUAL: {
                    return items1 == items2;
                }
                case NOT: {
                    return items1 != items2;
                }
                case GREATER_THAN: {
                    return items1 > items2;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return items1 >= items2;
                }
                case LESS_THAN: {
                    return items1 < items2;
                }
                case LESS_THAN_OR_EQUAL: {
                    return items1 <= items2;
                }
            }
            return false;
        }

        static {
            NAME_MAP = NameMap.create((Object)((Object)GREATER_THAN_OR_EQUAL), (Object[])Mode.values());
        }
    }
}

