/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.gui;

import com.feed_the_beast.ftbguides.FTBGuides;
import com.feed_the_beast.ftbguides.client.FTBGuidesClient;
import com.feed_the_beast.ftbguides.gui.GuidePage;
import com.feed_the_beast.ftbguides.gui.SpecialGuideButton;
import com.feed_the_beast.ftbguides.gui.components.GuideComponent;
import com.feed_the_beast.ftbguides.gui.components.HRGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.TextGuideComponent;
import com.feed_the_beast.ftbguides.net.MessageServerInfo;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import java.net.Proxy;
import java.net.URI;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextFormatting;

public class ThreadLoadPage
extends Thread {
    private final GuidePage page;
    public GuiLoading gui;
    public JsonElement json = JsonNull.INSTANCE;

    public ThreadLoadPage(GuidePage p) {
        super("LoadPage" + p.getPath());
        this.page = p;
    }

    @Override
    public void start() {
        if (this.page.textLoadingState == 1 || this.page == this.page.getRoot()) {
            return;
        }
        this.page.textLoadingState = 1;
        this.gui = new GuiLoading(){

            public void finishLoading() {
                ThreadLoadPage.this.gui = null;
                if (!((ThreadLoadPage)ThreadLoadPage.this).page.pages.isEmpty()) {
                    for (GuidePage p : ((ThreadLoadPage)ThreadLoadPage.this).page.pages) {
                        ThreadLoadPage.this.page.println(new TextGuideComponent(p.title.func_150260_c()).setProperty("icon", p.icon.toString()).setProperty("click", p.getID()));
                    }
                    ThreadLoadPage.this.page.println(HRGuideComponent.INSTANCE);
                }
                if (!((ThreadLoadPage)ThreadLoadPage.this).page.specialButtons.isEmpty()) {
                    for (SpecialGuideButton button : ((ThreadLoadPage)ThreadLoadPage.this).page.specialButtons) {
                        ThreadLoadPage.this.page.println(new TextGuideComponent(button.title.func_150260_c()).setProperty("icon", button.icon.toString()).setProperty("click", button.click));
                    }
                    ThreadLoadPage.this.page.println(HRGuideComponent.INSTANCE);
                }
                if (ThreadLoadPage.this.json.isJsonArray()) {
                    for (JsonElement e : ThreadLoadPage.this.json.getAsJsonArray()) {
                        ThreadLoadPage.this.page.println(GuideComponent.create(ThreadLoadPage.this.page, e));
                    }
                } else {
                    FTBGuides.LOGGER.error("Failed to load page " + ThreadLoadPage.this.page.getPath() + "! Json is not an array: " + ThreadLoadPage.this.json);
                    ThreadLoadPage.this.page.println(TextFormatting.RED + "Failed to load page! Try again later.");
                }
                ((ThreadLoadPage)ThreadLoadPage.this).page.textLoadingState = 2;
                FTBGuidesClient.openGuidesGui(ThreadLoadPage.this.page.getPath());
            }
        };
        this.gui.setTitle("Loading Page\n" + this.page.getPath());
        this.gui.openGui();
        this.setDaemon(true);
        if (FTBLibConfig.debugging.print_more_info) {
            FTBGuides.LOGGER.info("Started page loader for " + this.page.getPath());
        }
        super.start();
    }

    @Override
    public void run() {
        if (this.page.textURI.getScheme().equals("ftp")) {
            FTBGuidesClient.serverGuideClientLoading.put(this.page.getPath(), this);
            new MessageServerInfo(this.page.getPath()).sendToServer();
            return;
        }
        try {
            this.json = DataReader.get((URI)this.page.textURI, (Proxy)Minecraft.func_71410_x().func_110437_J()).json();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.gui.setFinished();
    }
}

