/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides;

import com.feed_the_beast.ftbguides.FTBGuides;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;

public class FTBGuidesCommon {
    public static JsonElement serverGuide = null;
    private static final Map<String, File> LOADED_PAGE_PATHS = new HashMap<String, File>();
    private static final Map<String, JsonElement> LOADED_PAGES = new HashMap<String, JsonElement>();

    public void preInit() {
    }

    public void postInit() {
    }

    public static boolean reloadServerGuide() {
        serverGuide = null;
        return true;
    }

    public static JsonElement getServerGuide(MinecraftServer server) {
        if (serverGuide == null) {
            JsonElement pages0;
            File folder = new File(server.func_71238_n(), "local/server_guide");
            serverGuide = DataReader.get((File)new File(folder, "data.json")).safeJson();
            LOADED_PAGE_PATHS.clear();
            LOADED_PAGES.clear();
            if (serverGuide.isJsonObject() && serverGuide.getAsJsonObject().has("pages") && (pages0 = serverGuide.getAsJsonObject().get("pages")).isJsonArray()) {
                for (JsonElement element : pages0.getAsJsonArray()) {
                    if (!element.isJsonObject() || !element.getAsJsonObject().has("id")) continue;
                    FTBGuidesCommon.loadPagePath(folder, "/", element.getAsJsonObject());
                }
            }
        }
        return serverGuide;
    }

    private static void loadPagePath(File folder, String path, JsonObject json) {
        JsonElement pages0;
        String id = json.get("id").getAsString();
        String pagePath = path + id + "/";
        File file = new File(folder, pagePath + "index.json");
        if (!file.exists()) {
            file = new File(folder, pagePath.substring(0, pagePath.length() - 1) + ".json");
        }
        if (file.exists() && file.getAbsolutePath().startsWith(folder.getAbsolutePath())) {
            LOADED_PAGE_PATHS.put(pagePath, file);
        } else {
            FTBGuides.LOGGER.error("Couldn't load server guide page " + pagePath + "!");
        }
        if (json.has("pages") && (pages0 = json.get("pages")).isJsonArray()) {
            for (JsonElement element : pages0.getAsJsonArray()) {
                if (!element.isJsonObject() || !element.getAsJsonObject().has("id")) continue;
                FTBGuidesCommon.loadPagePath(folder, pagePath, element.getAsJsonObject());
            }
        }
    }

    public static JsonElement getLoadedPage(MinecraftServer server, String path) {
        FTBGuidesCommon.getServerGuide(server);
        JsonElement json = LOADED_PAGES.get(path);
        if (json == null) {
            json = JsonNull.INSTANCE;
            File file = LOADED_PAGE_PATHS.get(path);
            if (file != null && !(json = DataReader.get((File)file).safeJson()).isJsonArray()) {
                json = JsonNull.INSTANCE;
            }
            LOADED_PAGES.put(path, json);
        }
        return json;
    }
}

