/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.enchant;

import com.enderio.core.EnderCore;
import com.enderio.core.api.common.enchant.IAdvancedEnchant;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.util.NullHelper;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="endercore")
public class EnchantXPBoost
extends Enchantment
implements IAdvancedEnchant {
    private static EnchantXPBoost INSTANCE;
    private static final EnumEnchantmentType ENCH_TYPE;

    @Nullable
    public static EnchantXPBoost instance() {
        return INSTANCE;
    }

    private EnchantXPBoost() {
        super(Enchantment.Rarity.UNCOMMON, ENCH_TYPE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        this.setRegistryName("xpboost");
    }

    public int func_77317_b(int level) {
        return super.func_77317_b(level) + 30;
    }

    public int func_77321_a(int level) {
        return super.func_77321_a(level);
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_77326_a(@Nonnull Enchantment ench) {
        return super.func_77326_a(ench) && ench != Enchantments.field_185306_r;
    }

    @Nonnull
    public String func_77320_a() {
        return "enchantment.xpboost";
    }

    public boolean isAllowedOnBooks() {
        return ConfigHandler.allowXPBoost;
    }

    public boolean func_92089_a(@Nonnull ItemStack stack) {
        return ConfigHandler.allowXPBoost && super.func_92089_a(stack);
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack) {
        return ConfigHandler.allowXPBoost && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    @Nonnull
    public String[] getTooltipDetails(@Nonnull ItemStack stack) {
        return new String[]{EnderCore.lang.localize("enchantment.xpboost.tooltip", false)};
    }

    @SubscribeEvent
    public static void register(@Nonnull RegistryEvent.Register<Enchantment> event) {
        if (ConfigHandler.allowXPBoost) {
            INSTANCE = new EnchantXPBoost();
            event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
            FMLInterModComms.sendMessage((String)"enderio", (String)"recipe:xml", (String)("<?xml version=\"1.0\" encoding=\"UTF-8\"?><recipes><recipe name=\"Enchanter: endercore:xpboost\" required=\"true\" disabled=\"false\"><enchanting><input name=\"oredict:ingotGold\" amount=\"16\"/><enchantment name=\"" + EnderCore.DOMAIN + ":xpboost\" costMultiplier=\"1\"/></enchanting></recipe></recipes>"));
        }
    }

    static {
        ENCH_TYPE = EnumHelper.addEnchantmentType((String)"EC_XPBOOST", (Predicate)new Predicate<Item>(){

            public boolean apply(@Nullable Item item) {
                return NullHelper.notnullM(item, "EnumEnchantmentType.canEnchantItem(null)").func_77645_m() && !(item instanceof ItemArmor) && !(item instanceof ItemFishingRod);
            }

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(@Nullable Object obj) {
                return super.equals(obj);
            }
        });
    }
}

