/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.sync;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.sync.ISyncHandler;

public class SyncHandlerNBTSyncable
implements ISyncHandler<INBTSyncable> {
    public final Supplier<INBTSyncable> supplier;

    public SyncHandlerNBTSyncable(Supplier<INBTSyncable> supplier) {
        this.supplier = supplier;
    }

    public SyncHandlerNBTSyncable(Class clazz) {
        this.supplier = () -> {
            try {
                return (INBTSyncable)clazz.newInstance();
            }
            catch (Throwable e) {
                System.out.println("FAILED TO INIT NBT SYNCABLE: " + clazz);
                e.printStackTrace();
                return null;
            }
        };
    }

    @Override
    public NBTTagCompound save(NBTTagCompound tag, String key, INBTSyncable value) {
        NBTTagCompound subTag = new NBTTagCompound();
        value.writeData(subTag, NBTHelper.SyncType.SAVE);
        if (!subTag.func_82582_d()) {
            tag.func_74782_a(key, (NBTBase)subTag);
        }
        return tag;
    }

    @Override
    public INBTSyncable load(NBTTagCompound tag, String key) {
        INBTSyncable value = this.supplier.get();
        if (tag.func_74764_b(key)) {
            NBTTagCompound subTag = tag.func_74775_l(key);
            value.readData(subTag, NBTHelper.SyncType.SAVE);
        }
        return value;
    }

    @Override
    public ByteBuf save(ByteBuf buf, INBTSyncable value) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.save(new NBTTagCompound(), "buf", value));
        return buf;
    }

    @Override
    public INBTSyncable load(ByteBuf buf) {
        return this.load(ByteBufUtils.readTag((ByteBuf)buf), "buf");
    }
}

