/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.AdvMachines;

import com.chocohead.AdvMachines.RecipeLoader;
import com.chocohead.AdvMachines.gui.ProgressBars;
import com.chocohead.AdvMachines.item.ItemSharpPlate;
import com.chocohead.AdvMachines.te.AdvancedMachineTEs;
import ic2.api.event.ProfileEvent;
import ic2.api.event.TeBlockFinalCallEvent;
import ic2.api.item.IC2Items;
import ic2.api.recipe.ICraftingRecipeManager;
import ic2.api.recipe.Recipes;
import ic2.core.IC2;
import ic2.core.block.BlockTileEntity;
import ic2.core.block.ITeBlock;
import ic2.core.block.TeBlockRegistry;
import ic2.core.profile.Profile;
import ic2.core.profile.ProfileManager;
import ic2.core.profile.ProfileTarget;
import ic2.core.profile.TextureStyle;
import ic2.core.ref.IItemModelProvider;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

@Mod(modid="advanced_machines", name="Advanced Machines", version="61.0.1", acceptedMinecraftVersions="[1.12,1.12.2]", dependencies="required-after:ic2")
public final class AdvancedMachines {
    public static final String MODID = "advanced_machines";
    public static Logger logger;
    public static BlockTileEntity machines;
    public static Item sharpPlate;

    @Mod.EventHandler
    public void start(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void load(ProfileEvent.Load event) {
        Profile profile = ProfileManager.getOrError((String)"Classic");
        assert (MODID.equals(((ModContainer)Loader.instance().getReversedModObjectList().get((Object)this)).getModId()));
        profile.textures.add(new TextureStyle(MODID, new ProfileTarget(((ModContainer)Loader.instance().getReversedModObjectList().get((Object)this)).getSource(), "assets/advanced_machines/classic")));
    }

    @SubscribeEvent
    public void register(TeBlockFinalCallEvent event) {
        TeBlockRegistry.addAll(AdvancedMachineTEs.class, (ResourceLocation)AdvancedMachineTEs.IDENTITY);
        TeBlockRegistry.addCreativeRegisterer((ITeBlock)AdvancedMachineTEs.water_jet_cutter);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        machines = TeBlockRegistry.get((ResourceLocation)AdvancedMachineTEs.IDENTITY);
        sharpPlate = new ItemSharpPlate();
        ProgressBars.addStyles();
        if (event.getSide().isClient()) {
            ((IItemModelProvider)sharpPlate).registerModels(null);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ItemStack maceratorSurround;
        AdvancedMachineTEs.buildDummies();
        if (IC2.version.isExperimental()) {
            maceratorSurround = new ItemStack(sharpPlate);
            Recipes.advRecipes.addRecipe(maceratorSurround, new Object[]{"^^^", "^#^", "^^^", Character.valueOf('^'), Items.field_151145_ak, Character.valueOf('#'), "plateIron"});
            AdvancedMachines.addRecipe("metal_former", IC2Items.getItem((String)"fence", (String)"iron"), AdvancedMachineTEs.liquescent_extruder);
            AdvancedMachines.addRecipe("metal_former", IC2Items.getItem((String)"forge_hammer"), AdvancedMachineTEs.impellerized_roller, true);
            AdvancedMachines.addRecipe("metal_former", IC2Items.getItem((String)"cutter"), AdvancedMachineTEs.water_jet_cutter, true);
            AdvancedMachines.addRecipe("ore_washing_plant", IC2Items.getItem((String)"dust", (String)"sulfur"), AdvancedMachineTEs.thermal_washer);
        } else {
            maceratorSurround = IC2Items.getItem((String)"ingot", (String)"refined_iron");
        }
        AdvancedMachines.addRecipe("macerator", maceratorSurround, AdvancedMachineTEs.rotary_macerator);
        AdvancedMachines.addRecipe("compressor", new ItemStack(Blocks.field_150343_Z), AdvancedMachineTEs.singularity_compressor);
        AdvancedMachines.addRecipe("extractor", IC2Items.getItem((String)"treetap"), AdvancedMachineTEs.centrifuge_extractor);
        AdvancedMachines.addRecipe("recycler", new ItemStack((Block)Blocks.field_150331_J), AdvancedMachineTEs.compacting_recycler);
        RecipeLoader.loadRecipes();
    }

    private static void addRecipe(String baseMachine, ItemStack surroundItem, AdvancedMachineTEs output) {
        AdvancedMachines.addRecipe(baseMachine, surroundItem, output, false);
    }

    private static void addRecipe(String baseMachine, ItemStack surroundItem, AdvancedMachineTEs output, boolean consuming) {
        Recipes.advRecipes.addRecipe(machines.getItemStack((ITeBlock)output), new Object[]{"###", "#M#", "#X#", Character.valueOf('#'), surroundItem, Character.valueOf('M'), IC2Items.getItem((String)"te", (String)baseMachine), Character.valueOf('X'), IC2Items.getItem((String)"resource", (String)"advanced_machine"), new ICraftingRecipeManager.AttributeContainer(false, consuming)});
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RecipeLoader.loadFailedRecipes();
        logger.info("Advanced Machines 61.0.1 loaded.");
    }
}

