/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.state.GlStateTracker;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.render.TESRBase;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalDirectIO;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.shaders.DEShaders;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.MinecraftForgeClient;

public class RenderTileEnergyCrystal
extends TESRBase<TileCrystalBase> {
    private CCModel crystalFull;
    private CCModel crystalHalf;
    private CCModel crystalBase;
    private static ShaderProgram shaderProgram;
    private static float[] r;
    private static float[] g;
    private static float[] b;

    public RenderTileEnergyCrystal() {
        Map map = OBJParser.parseModels((ResourceLocation)ResourceHelperDE.getResource("models/crystal.obj"));
        this.crystalFull = CCModel.combine(map.values());
        map = OBJParser.parseModels((ResourceLocation)ResourceHelperDE.getResource("models/crystal_half.obj"));
        this.crystalHalf = (CCModel)map.get("Crystal");
        this.crystalBase = (CCModel)map.get("Base");
    }

    public void render(TileCrystalBase te, double x, double y, double z, float partialTicks, int destroyStage, float a) {
        te.getFxHandler().renderCooldown = 5;
        GlStateManager.func_179094_E();
        GlStateTracker.pushState();
        GlStateManager.func_179140_f();
        this.setLighting(200.0f);
        if (te instanceof TileCrystalDirectIO) {
            this.renderHalfCrystal((TileCrystalDirectIO)te, x, y, z, partialTicks, destroyStage, te.getTier());
        } else {
            this.renderCrystal(te, x, y, z, partialTicks, destroyStage, te.getTier());
        }
        this.resetLighting();
        GlStateTracker.popState();
        GlStateManager.func_179121_F();
    }

    public void renderCrystal(TileCrystalBase te, double x, double y, double z, float partialTicks, int destroyStage, int tier) {
        boolean trans = MinecraftForgeClient.getRenderPass() == 1;
        CCRenderState ccrs = CCRenderState.instance();
        Matrix4 mat = RenderUtils.getMatrix((Vector3)new Vector3(x + 0.5, y + 0.5, z + 0.5), (Rotation)new Rotation(3.1415926535897403, 1.0, 0.0, 0.0), (double)-0.5);
        mat.apply((Transformation)new Rotation((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), 0.0, 1.0, 0.0));
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            return;
        }
        if (!trans) {
            this.bindShader(te, x, y, z, partialTicks, tier);
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            this.releaseShader();
        } else if (!DEShaders.useShaders() || !DEConfig.useCrystalShaders) {
            ResourceHelperDE.bindTexture("textures/models/crystal_purple_transparent.png");
            GlStateManager.func_179147_l();
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
        }
    }

    public void renderHalfCrystal(TileCrystalDirectIO te, double x, double y, double z, float partialTicks, int destroyStage, int tier) {
        boolean trans = MinecraftForgeClient.getRenderPass() == 1;
        ResourceHelperDE.bindTexture("textures/models/crystal_purple_transparent.png");
        CCRenderState ccrs = CCRenderState.instance();
        Matrix4 mat = RenderUtils.getMatrix((Vector3)new Vector3(x + 0.5, y + 1.0, z + 0.5), (Rotation)new Rotation(0.0, 0.0, 0.0, 0.0), (double)-0.5);
        mat.apply(Rotation.sideOrientation((int)((EnumFacing)te.facing.value).func_176734_d().func_176745_a(), (int)0).at(new Vector3(0.0, 1.0, 0.0)));
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            this.crystalBase.render(ccrs, new IVertexOperation[]{mat});
            mat.apply((Transformation)new Rotation((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), 0.0, 1.0, 0.0));
            this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            return;
        }
        if (!trans) {
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            this.crystalBase.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            mat.apply((Transformation)new Rotation((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), 0.0, 1.0, 0.0));
            ResourceHelperDE.bindTexture("textures/models/reactor_core.png");
            this.bindShader(te, x, y, z, partialTicks, tier);
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            this.releaseShader();
        } else if (!DEShaders.useShaders() || !DEConfig.useCrystalShaders) {
            GlStateManager.func_179147_l();
            mat.apply((Transformation)new Rotation((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), 0.0, 1.0, 0.0)).apply((Transformation)new Scale(1.001));
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
        }
    }

    public void bindShader(TileCrystalBase te, double x, double y, double z, float partialTicks, int tier) {
        BlockPos pos = te == null ? new BlockPos(0, 0, 0) : te.func_174877_v();
        double mm = codechicken.lib.math.MathHelper.clip((double)((x * x + y * y + z * z - 5.0) / 512.0), (double)0.0, (double)1.0);
        if (DEShaders.useShaders() && DEConfig.useCrystalShaders && mm < 1.0) {
            float xrot = (float)Math.atan2(x + 0.5, z + 0.5);
            float dist = (float)Utils.getDistanceAtoB((double)Vec3D.getCenter((BlockPos)pos).x, (double)Vec3D.getCenter((BlockPos)pos).z, (double)Minecraft.func_71410_x().field_71439_g.field_70165_t, (double)Minecraft.func_71410_x().field_71439_g.field_70161_v);
            float yrot = (float)MathHelper.func_181159_b((double)dist, (double)(y + 0.5));
            if (shaderProgram == null) {
                shaderProgram = new ShaderProgram();
                shaderProgram.attachShader(DEShaders.energyCrystal_V);
                shaderProgram.attachShader(DEShaders.energyCrystal_F);
            }
            shaderProgram.useShader(cache -> {
                cache.glUniform1F("time", ((float)ClientEventHandler.elapsedTicks + partialTicks) / 50.0f);
                cache.glUniform1F("mipmap", (float)mm);
                cache.glUniform1I("type", tier);
                cache.glUniform2F("angle", xrot / -3.125f, yrot / 3.125f);
            });
        } else {
            ResourceHelperDE.bindTexture("textures/models/crystal_no_shader.png");
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)r[tier], (float)g[tier], (float)b[tier], (float)0.5f);
        }
    }

    private void releaseShader() {
        if (DEShaders.useShaders() && DEConfig.useCrystalShaders && shaderProgram != null) {
            shaderProgram.releaseShader();
        }
    }

    static {
        r = new float[]{0.0f, 0.55f, 1.0f};
        g = new float[]{0.35f, 0.3f, 0.572f};
        b = new float[]{0.65f, 0.9f, 0.172f};
    }
}

