/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.Items;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mcjty.lib.client.BlockOutlineRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import romelo333.notenoughwands.ConfigSetup;
import romelo333.notenoughwands.Items.BlackListSettings;
import romelo333.notenoughwands.Items.IEnergyItem;
import romelo333.notenoughwands.KeyBindings;
import romelo333.notenoughwands.NotEnoughWands;
import romelo333.notenoughwands.ProtectedBlocks;
import romelo333.notenoughwands.varia.ItemCapabilityProvider;
import romelo333.notenoughwands.varia.Tools;

public class GenericWand
extends Item
implements IEnergyItem {
    protected int needsxp = 0;
    protected int needsrf = 0;
    protected int maxrf = 0;
    protected int lootRarity = 10;
    private static List<GenericWand> wands = new ArrayList<GenericWand>();

    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemCapabilityProvider(stack, this);
    }

    public static double checkPickup(EntityPlayer player, World world, BlockPos pos, Block block, float maxHardness) {
        IBlockState state = world.func_180495_p(pos);
        float hardness = block.func_176195_g(state, world, pos);
        if (hardness < 0.0f || hardness > maxHardness) {
            Tools.error(player, "This block is to hard to take!");
            return -1.0;
        }
        if (!block.canEntityDestroy(state, (IBlockAccess)world, pos, (Entity)player)) {
            Tools.error(player, "You are not allowed to take this block!");
            return -1.0;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, pos)) {
            Tools.error(player, "This block is protected. You cannot take it!");
            return -1.0;
        }
        double cost = BlackListSettings.getBlacklistCost(block);
        if (cost <= (double)0.001f) {
            Tools.error(player, "It is illegal to take this block");
            return -1.0;
        }
        return cost;
    }

    public void func_77624_a(ItemStack stack, World player, List<String> list, ITooltipFlag b) {
        super.func_77624_a(stack, player, list, b);
        if (this.needsrf > 0) {
            list.add(TextFormatting.GREEN + "Energy: " + this.getEnergyStored(stack) + " / " + this.getMaxEnergyStored(stack));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (this.needsrf > 0 && ConfigSetup.showDurabilityBarForRF) {
            return true;
        }
        return super.showDurabilityBar(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (this.needsrf > 0 && ConfigSetup.showDurabilityBarForRF) {
            int max = this.getMaxEnergyStored(stack);
            return (double)(max - this.getEnergyStored(stack)) / (double)max;
        }
        return super.getDurabilityForDisplay(stack);
    }

    protected GenericWand setup(String name) {
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b("notenoughwands." + name);
        this.setRegistryName(name);
        this.func_77637_a(NotEnoughWands.setup.getTab());
        wands.add(this);
        return this;
    }

    GenericWand xpUsage(int xp) {
        this.needsxp = xp;
        return this;
    }

    GenericWand rfUsage(int maxrf, int rf) {
        this.maxrf = maxrf;
        this.needsrf = rf;
        return this;
    }

    GenericWand durabilityUsage(int maxdurability) {
        this.func_77656_e(maxdurability);
        return this;
    }

    GenericWand loot(int rarity) {
        this.lootRarity = rarity;
        return this;
    }

    protected String getConfigPrefix() {
        return this.getRegistryName().func_110623_a();
    }

    protected void initConfig(Configuration cfg) {
    }

    public void initConfig(Configuration cfg, int easy_usages, int easy_maxrf, int normal_usages, int normal_maxrf, int hard_usages, int hard_maxrf) {
        switch (ConfigSetup.wandUsage) {
            case DEFAULT: {
                this.needsxp = cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_needsxp", this.needsxp, "How much levels this wand should consume on usage").getInt();
                this.needsrf = cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_needsrf", this.needsrf, "How much RF this wand should consume on usage").getInt();
                this.maxrf = cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_maxrf", this.maxrf, "Maximum RF this wand can hold").getInt();
                this.func_77656_e(cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_maxdurability", this.func_77612_l(), "Maximum durability for this wand").getInt());
                break;
            }
            case EASY_RF: {
                this.needsxp = 0;
                this.func_77656_e(0);
                this.needsrf = easy_maxrf / easy_usages;
                this.maxrf = easy_maxrf;
                cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_needsxp", this.needsxp, "How much levels this wand should consume on usage").getInt();
                cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_needsrf", this.needsrf, "How much RF this wand should consume on usage").getInt();
                cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_maxrf", this.maxrf, "Maximum RF this wand can hold").getInt();
                cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_maxdurability", this.func_77612_l(), "Maximum durability for this wand").getInt();
                break;
            }
            case NORMAL_RF: {
                this.needsxp = 0;
                this.func_77656_e(0);
                this.needsrf = normal_maxrf / normal_usages;
                this.maxrf = normal_maxrf;
                cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_needsxp", this.needsxp, "How much levels this wand should consume on usage").getInt();
                cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_needsrf", this.needsrf, "How much RF this wand should consume on usage").getInt();
                cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_maxrf", this.maxrf, "Maximum RF this wand can hold").getInt();
                cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_maxdurability", this.func_77612_l(), "Maximum durability for this wand").getInt();
                break;
            }
            case HARD_RF: {
                this.needsxp = 0;
                this.func_77656_e(0);
                this.needsrf = hard_maxrf / hard_usages;
                this.maxrf = hard_maxrf;
                cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_needsxp", this.needsxp, "How much levels this wand should consume on usage").getInt();
                cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_needsrf", this.needsrf, "How much RF this wand should consume on usage").getInt();
                cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_maxrf", this.maxrf, "Maximum RF this wand can hold").getInt();
                cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_maxdurability", this.func_77612_l(), "Maximum durability for this wand").getInt();
            }
        }
        this.lootRarity = cfg.get(ConfigSetup.CATEGORY_WANDS, this.getConfigPrefix() + "_lootRarity", this.lootRarity, "How rare should this wand be in chests? Lower is more rare (0 is not in chests)").getInt();
    }

    protected boolean checkUsage(ItemStack stack, EntityPlayer player, float difficultyScale) {
        int experience;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (this.needsxp > 0 && (experience = Tools.getPlayerXP(player) - (int)((float)this.needsxp * difficultyScale)) <= 0) {
            Tools.error(player, "Not enough experience!");
            return false;
        }
        if (this.func_77645_m() && stack.func_77952_i() >= stack.func_77958_k()) {
            Tools.error(player, "This wand can no longer be used!");
            return false;
        }
        if (this.needsrf > 0 && this.getEnergyStored(stack) < (int)((float)this.needsrf * difficultyScale)) {
            Tools.error(player, "Not enough energy to use this wand!");
            return false;
        }
        return true;
    }

    protected void registerUsage(ItemStack stack, EntityPlayer player, float difficultyScale) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (this.needsxp > 0) {
            Tools.addPlayerXP(player, -((int)((float)this.needsxp * difficultyScale)));
        }
        if (this.func_77645_m()) {
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        if (this.needsrf > 0) {
            this.extractEnergy(stack, (int)((float)this.needsrf * difficultyScale), false);
        }
    }

    public void toggleMode(EntityPlayer player, ItemStack stack) {
    }

    public void toggleSubMode(EntityPlayer player, ItemStack stack) {
    }

    public static List<GenericWand> getWands() {
        return wands;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setupModels() {
        for (GenericWand wand : wands) {
            wand.registerModel();
        }
    }

    public static void setupConfig(Configuration cfg) {
        for (GenericWand wand : wands) {
            wand.initConfig(cfg);
        }
    }

    public static void setupChestLoot(LootPool main) {
        for (GenericWand wand : wands) {
            wand.setupChestLootInt(main);
        }
    }

    private void setupChestLootInt(LootPool main) {
        if (this.lootRarity > 0) {
            String entryName = "notenoughwands:" + this.getRegistryName().func_110623_a();
            main.addEntry((LootEntry)new LootEntryItem((Item)this, this.lootRarity, 0, new LootFunction[0], new LootCondition[0], entryName));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(RenderWorldLastEvent evt, EntityPlayerSP player, ItemStack wand) {
    }

    protected static void renderOutlines(RenderWorldLastEvent evt, EntityPlayerSP p, Set<BlockPos> coordinates, int r, int g, int b) {
        BlockOutlineRenderer.renderOutlines((EntityPlayerSP)p, coordinates, (int)r, (int)g, (int)b, (float)evt.getPartialTicks());
    }

    protected void showModeKeyDescription(List<String> list, String suffix) {
        String keyDescription = KeyBindings.wandModifier != null ? KeyBindings.wandModifier.getDisplayName() : "unknown";
        list.add("Mode key (" + keyDescription + ") to " + suffix);
    }

    protected void showSubModeKeyDescription(List<String> list, String suffix) {
        String keyDescription = KeyBindings.wandSubMode != null ? KeyBindings.wandSubMode.getDisplayName() : "unknown";
        list.add("Sub-mode key (" + keyDescription + ") to " + suffix);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (this.maxrf <= 0) {
            return 0;
        }
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.needsrf, maxExtract));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (this.maxrf <= 0) {
            return 0;
        }
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyReceived = Math.min(this.maxrf - energy, Math.min(this.maxrf, maxReceive));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.maxrf;
    }
}

