/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.potions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import xreliquary.reference.Settings;
import xreliquary.util.LogHelper;
import xreliquary.util.StackHelper;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.PotionEssenceComparator;
import xreliquary.util.potions.PotionIngredient;
import xreliquary.util.potions.XRPotionHelper;

public class PotionMap {
    public static List<PotionIngredient> ingredients = new ArrayList<PotionIngredient>();
    public static List<PotionEssence> potionCombinations = new ArrayList<PotionEssence>();
    public static List<PotionEssence> uniquePotionEssences = new ArrayList<PotionEssence>();
    public static List<PotionEssence> uniquePotions = new ArrayList<PotionEssence>();

    public static void initPotionMap() {
        PotionMap.loadPotionMapFromSettings();
        LogHelper.debug("Starting calculation of potion combinations");
        PotionMap.loadPotionCombinations();
        PotionMap.loadUniquePotions();
        LogHelper.debug("Done with potion combinations");
    }

    private static void loadUniquePotions() {
        uniquePotionEssences.clear();
        uniquePotions.clear();
        for (PotionEssence essence : potionCombinations) {
            boolean found = false;
            for (PotionEssence uniqueEssence : uniquePotionEssences) {
                if (!PotionMap.effectsEqual(essence.getEffects(), uniqueEssence.getEffects())) continue;
                found = true;
                break;
            }
            if (found) continue;
            uniquePotionEssences.add(essence);
            PotionMap.addUniquePotions(essence);
        }
        uniquePotionEssences.sort(new PotionEssenceComparator());
        uniquePotions.sort(new PotionEssenceComparator());
    }

    private static void addUniquePotions(PotionEssence essence) {
        uniquePotions.add(essence);
        if (Settings.Potions.redstoneAndGlowstone) {
            PotionEssence redstone = essence.copy();
            redstone.setEffects(XRPotionHelper.augmentPotionEffects(redstone.getEffects(), 1, 0));
            redstone.setRedstoneCount(1);
            uniquePotions.add(redstone);
            PotionEssence glowstone = essence.copy();
            glowstone.setEffects(XRPotionHelper.augmentPotionEffects(redstone.getEffects(), 0, 1));
            glowstone.setGlowstoneCount(1);
            uniquePotions.add(glowstone);
            PotionEssence redstoneGlowstone = essence.copy();
            redstoneGlowstone.setEffects(XRPotionHelper.augmentPotionEffects(redstone.getEffects(), 1, 1));
            redstoneGlowstone.setRedstoneCount(1);
            redstoneGlowstone.setGlowstoneCount(1);
            uniquePotions.add(redstoneGlowstone);
        }
    }

    private static void loadPotionCombinations() {
        potionCombinations.clear();
        for (PotionIngredient ingredient1 : ingredients) {
            for (PotionIngredient ingredient2 : ingredients) {
                PotionEssence twoEssence;
                if (ingredient1.item.func_77973_b() == ingredient2.item.func_77973_b() && ingredient1.item.func_77960_j() == ingredient2.item.func_77960_j() || (twoEssence = new PotionEssence.Builder().setIngredients(ingredient1, ingredient2).setEffects(XRPotionHelper.combineIngredients(ingredient1, ingredient2)).build()).getEffects().size() <= 0 || twoEssence.getEffects().size() > Settings.Potions.maxEffectCount) continue;
                PotionMap.addPotionCombination(twoEssence);
                if (!Settings.Potions.threeIngredients) continue;
                for (PotionIngredient ingredient3 : ingredients) {
                    if (ingredient3.item.func_77973_b() == ingredient1.item.func_77973_b() && ingredient3.item.func_77960_j() == ingredient1.item.func_77960_j() || ingredient3.item.func_77973_b() == ingredient2.item.func_77973_b() && ingredient3.item.func_77960_j() == ingredient2.item.func_77960_j()) continue;
                    PotionEssence threeEssence = new PotionEssence.Builder().setIngredients(ingredient1, ingredient2, ingredient3).setEffects(XRPotionHelper.combineIngredients(ingredient1, ingredient2, ingredient3)).build();
                    if (PotionMap.effectsEqual(twoEssence.getEffects(), threeEssence.getEffects())) continue;
                    PotionMap.addPotionCombination(threeEssence);
                }
            }
        }
    }

    private static void addPotionCombination(PotionEssence newEssence) {
        for (PotionEssence essence : potionCombinations) {
            if (PotionMap.ingredientsEqual(essence.getIngredients(), newEssence.getIngredients())) {
                return;
            }
            if (!PotionMap.effectsEqual(essence.getEffects(), newEssence.getEffects(), Settings.Potions.differentDurations) || PotionMap.effectsEqual(essence.getEffects(), newEssence.getEffects())) continue;
            return;
        }
        potionCombinations.add(newEssence);
    }

    private static boolean ingredientsEqual(List<PotionIngredient> a, List<PotionIngredient> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (PotionIngredient ingredientA : a) {
            boolean found = false;
            for (PotionIngredient ingredientB : b) {
                if (ingredientA.item.func_77973_b() != ingredientB.item.func_77973_b() || ingredientA.item.func_77960_j() != ingredientB.item.func_77960_j()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static boolean effectsEqual(List<PotionEffect> a, List<PotionEffect> b) {
        return PotionMap.effectsEqual(a, b, true);
    }

    private static boolean effectsEqual(List<PotionEffect> a, List<PotionEffect> b, boolean compareDuration) {
        if (a.size() != b.size()) {
            return false;
        }
        for (PotionEffect effectA : a) {
            boolean found = false;
            for (PotionEffect effectB : b) {
                if (!effectA.func_76453_d().equals(effectB.func_76453_d()) || compareDuration && effectA.func_76459_b() != effectB.func_76459_b() || effectA.func_76458_c() != effectB.func_76458_c()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static void loadPotionMapFromSettings() {
        ingredients.clear();
        Pattern validEntry = Pattern.compile("[a-z_:0-9]+\\|[0-9]+=[a-z_0-9:\\.\\|;]+");
        for (String entry : Settings.Potions.potionMap) {
            if (validEntry.matcher(entry).matches()) {
                int meta;
                String name;
                String[] entryParts = entry.split("=");
                String[] nameParts = entryParts[0].split("\\|");
                String[] effects = entryParts[1].split(";");
                String modId = nameParts[0].split(":")[0];
                ItemStack stack = StackHelper.getItemStackFromNameMeta(modId, name = nameParts[0].split(":")[1], meta = Integer.parseInt(nameParts[1]));
                if (stack == null) continue;
                PotionIngredient ingredient = new PotionIngredient(stack);
                for (String effect : effects) {
                    String[] effectValues = effect.split("\\|");
                    String potionName = effectValues[0];
                    if (potionName.isEmpty()) continue;
                    short durationWeight = Short.parseShort(effectValues[1]);
                    short ampWeight = Short.parseShort(effectValues[2]);
                    ingredient.addEffect(potionName, durationWeight, ampWeight);
                }
                if (ingredient.effects.isEmpty()) continue;
                ingredients.add(ingredient);
                continue;
            }
            LogHelper.error("Potion map entry \"" + entry + "\" is not valid.\nNeeds to be mod:item_or_block_registry_name|meta=potion_effect_name|duration_multiplier|amplifier\nPotion effect part (\"potion_effect_name|...|amplifier\") can be optionally repeated if there are multiple effects on item, the individual potion sections are delimited by semicolon \";\"\nDuration multiplier is multiples of 15 seconds the potion will last");
        }
    }

    public static String[] getDefaultConfigPotionMap() {
        ArrayList potionMap = Lists.newArrayList();
        String mobIngredient = "xreliquary:mob_ingredient";
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151102_aT, PotionMap.speed(3, 0), PotionMap.haste(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151034_e, PotionMap.heal(0), PotionMap.hboost(3, 0), PotionMap.cure(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151044_h, PotionMap.blind(1), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151044_h, 1, PotionMap.invis(1), PotionMap.wither(0, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151008_G, PotionMap.jump(3, 0), PotionMap.weak(1, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151014_N, PotionMap.harm(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151015_O, PotionMap.heal(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151145_ak, PotionMap.harm(0), PotionMap.dboost(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151147_al, PotionMap.slow(1, 0), PotionMap.fatigue(1, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151116_aA, PotionMap.resist(3, 0), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151119_aD, PotionMap.slow(1, 0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151110_aK, PotionMap.absorb(3, 0), PotionMap.regen(0, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151100_aR, 1, PotionMap.heal(0), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151100_aR, 11, PotionMap.jump(3, 0), PotionMap.weak(1, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151100_aR, 2, PotionMap.resist(3, 0), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151100_aR, 15, PotionMap.weak(1, 0), PotionMap.fatigue(1, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151080_bb, PotionMap.invis(1), PotionMap.fireres(1));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151082_bd, PotionMap.slow(1, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151076_bf, PotionMap.nausea(1), PotionMap.poison(1));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151078_bh, PotionMap.nausea(1), PotionMap.hunger(1), PotionMap.wither(0, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151074_bl, PotionMap.dboost(0, 0), PotionMap.haste(0, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151172_bF, PotionMap.vision(3), PotionMap.hboost(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151174_bG, PotionMap.hboost(3, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151115_aP, PotionMap.satur(0), PotionMap.breath(1));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151070_bp, PotionMap.vision(4), PotionMap.poison(2));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151065_br, PotionMap.dboost(4, 0), PotionMap.harm(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151042_j, PotionMap.resist(4, 0), PotionMap.slow(2, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151007_F, PotionMap.slow(2, 0), PotionMap.fatigue(2, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151025_P, PotionMap.hboost(4, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151157_am, PotionMap.fatigue(2, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151123_aH, PotionMap.resist(4, 0), PotionMap.fireres(2));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_179566_aV, PotionMap.satur(0), PotionMap.breath(2));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151100_aR, 4, PotionMap.haste(4, 0), PotionMap.dboost(4, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151100_aR, 0, PotionMap.blind(2), PotionMap.invis(2));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151103_aS, PotionMap.weak(2, 0), PotionMap.fatigue(2, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151106_aX, PotionMap.heal(0), PotionMap.satur(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151127_ba, PotionMap.heal(0), PotionMap.speed(4, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151083_be, PotionMap.resist(4, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151077_bg, PotionMap.jump(4, 0), PotionMap.satur(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151168_bH, PotionMap.satur(0), PotionMap.regen(1, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151170_bI, PotionMap.poison(2), PotionMap.wither(1, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151128_bU, PotionMap.harm(0), PotionMap.dboost(4, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 6, PotionMap.nausea(2), PotionMap.hunger(2), PotionMap.wither(1, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 12, PotionMap.hunger(2), PotionMap.breath(2));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151158_bO, PotionMap.invis(1), PotionMap.fireres(1), PotionMap.speed(3, 0), PotionMap.haste(3, 0), PotionMap.absorb(3, 0), PotionMap.regen(0, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151064_bs, PotionMap.dboost(4, 0), PotionMap.harm(0), PotionMap.resist(4, 0), PotionMap.fireres(2));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151060_bw, PotionMap.dboost(3, 0), PotionMap.haste(3, 0), PotionMap.heal(0), PotionMap.speed(4, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151073_bk, PotionMap.regen(3, 0), PotionMap.absorb(5, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151071_bq, PotionMap.vision(4), PotionMap.poison(2), PotionMap.speed(3, 0), PotionMap.haste(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151150_bK, PotionMap.dboost(3, 0), PotionMap.haste(3, 0), PotionMap.hboost(3, 0), PotionMap.vision(3));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151043_k, PotionMap.dboost(4, 0), PotionMap.haste(4, 0), PotionMap.cure(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 0, PotionMap.weak(3, 0), PotionMap.fatigue(3, 0), PotionMap.cure(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151079_bi, PotionMap.invis(5), PotionMap.speed(5, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151072_bj, PotionMap.dboost(8, 0), PotionMap.harm(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151059_bz, PotionMap.dboost(4, 0), PotionMap.harm(0), PotionMap.blind(1), PotionMap.absorb(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 3, PotionMap.regen(3, 0), PotionMap.hboost(5, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 2, PotionMap.poison(3), PotionMap.weak(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 4, PotionMap.resist(5, 0), PotionMap.absorb(5, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 14, PotionMap.absorb(5, 0), PotionMap.breath(5));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 5, PotionMap.jump(5, 0), PotionMap.weak(3, 0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151153_ao, PotionMap.cure(1));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151153_ao, 1, PotionMap.cure(2));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151045_i, PotionMap.resist(6, 1), PotionMap.absorb(6, 1), PotionMap.fireres(6), PotionMap.cure(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 1, PotionMap.wither(2, 1), PotionMap.weak(3, 1), PotionMap.slow(3, 1), PotionMap.fatigue(3, 1), PotionMap.cure(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151061_bv, PotionMap.dboost(6, 1), PotionMap.invis(6), PotionMap.speed(6, 1), PotionMap.harm(1));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151166_bC, PotionMap.haste(6, 1), PotionMap.speed(6, 1), PotionMap.hboost(6, 1), PotionMap.cure(1));
        PotionMap.addPotionIngredient((List<String>)potionMap, Items.field_151156_bN, PotionMap.hboost(24, 1), PotionMap.regen(24, 1), PotionMap.absorb(24, 1), PotionMap.cure(2));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 7, PotionMap.dboost(6, 1), PotionMap.fireres(6), PotionMap.harm(1));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 8, PotionMap.haste(24, 1), PotionMap.speed(24, 1), PotionMap.jump(24, 1), PotionMap.harm(1), PotionMap.cure(1));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 9, PotionMap.hboost(8, 1), PotionMap.regen(3, 1), PotionMap.heal(1), PotionMap.satur(1), PotionMap.weak(9, 1), PotionMap.fatigue(9, 1), PotionMap.cure(0));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 10, PotionMap.absorb(6, 1), PotionMap.slow(3, 1), PotionMap.fatigue(3, 1), PotionMap.harm(1), PotionMap.fireres(6));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 11, PotionMap.vision(6), PotionMap.invis(6), PotionMap.harm(1), PotionMap.hboost(6, 1), PotionMap.dboost(6, 1), PotionMap.speed(6, 1), PotionMap.haste(6, 1));
        PotionMap.addPotionIngredient((List<String>)potionMap, mobIngredient, 13, PotionMap.harm(1), PotionMap.resist(6, 1), PotionMap.fireres(6), PotionMap.dboost(6, 1), PotionMap.satur(1), PotionMap.heal(1));
        return potionMap.toArray(new String[potionMap.size()]);
    }

    private static String harm(int potency) {
        return PotionMap.effectString("instant_damage", Integer.toString(0), Integer.toString(potency));
    }

    private static String heal(int potency) {
        return PotionMap.effectString("instant_health", Integer.toString(0), Integer.toString(potency));
    }

    private static String satur(int potency) {
        return PotionMap.effectString("saturation", Integer.toString(0), Integer.toString(potency));
    }

    private static String invis(int duration) {
        return PotionMap.effectString("invisibility", Integer.toString(duration), Integer.toString(0));
    }

    private static String absorb(int duration, int potency) {
        return PotionMap.effectString("absorption", Integer.toString(duration), Integer.toString(potency));
    }

    private static String hboost(int duration, int potency) {
        return PotionMap.effectString("health_boost", Integer.toString(duration), Integer.toString(potency));
    }

    private static String dboost(int duration, int potency) {
        return PotionMap.effectString("strength", Integer.toString(duration), Integer.toString(potency));
    }

    private static String speed(int duration, int potency) {
        return PotionMap.effectString("speed", Integer.toString(duration), Integer.toString(potency));
    }

    private static String haste(int duration, int potency) {
        return PotionMap.effectString("haste", Integer.toString(duration), Integer.toString(potency));
    }

    private static String slow(int duration, int potency) {
        return PotionMap.effectString("slowness", Integer.toString(duration), Integer.toString(potency));
    }

    private static String fatigue(int duration, int potency) {
        return PotionMap.effectString("mining_fatigue", Integer.toString(duration), Integer.toString(potency));
    }

    private static String breath(int duration) {
        return PotionMap.effectString("water_breathing", Integer.toString(duration), Integer.toString(0));
    }

    private static String vision(int duration) {
        return PotionMap.effectString("night_vision", Integer.toString(duration), Integer.toString(0));
    }

    private static String resist(int duration, int potency) {
        return PotionMap.effectString("resistance", Integer.toString(duration), Integer.toString(potency));
    }

    private static String fireres(int duration) {
        return PotionMap.effectString("fire_resistance", Integer.toString(duration), Integer.toString(0));
    }

    private static String weak(int duration, int potency) {
        return PotionMap.effectString("weakness", Integer.toString(duration), Integer.toString(potency));
    }

    private static String jump(int duration, int potency) {
        return PotionMap.effectString("jump_boost", Integer.toString(duration), Integer.toString(potency));
    }

    private static String nausea(int duration) {
        return PotionMap.effectString("nausea", Integer.toString(duration), Integer.toString(0));
    }

    private static String hunger(int duration) {
        return PotionMap.effectString("hunger", Integer.toString(duration), Integer.toString(0));
    }

    private static String regen(int duration, int potency) {
        return PotionMap.effectString("regeneration", Integer.toString(duration), Integer.toString(potency));
    }

    private static String poison(int duration) {
        return PotionMap.effectString("poison", Integer.toString(duration), Integer.toString(0));
    }

    private static String wither(int duration, int potency) {
        return PotionMap.effectString("wither", Integer.toString(duration), Integer.toString(potency));
    }

    private static String blind(int duration) {
        return PotionMap.effectString("blindness", Integer.toString(duration), Integer.toString(0));
    }

    private static String cure(int potency) {
        return PotionMap.effectString("xreliquary:cure_potion", Integer.toString(1), Integer.toString(potency));
    }

    private static String effectString(String name, String duration, String potency) {
        return name + "|" + duration + "|" + potency;
    }

    private static void addPotionIngredient(List<String> potionMap, Item ingredient, String ... effects) {
        PotionMap.addPotionIngredient(potionMap, ingredient, 0, effects);
    }

    private static void addPotionIngredient(List<String> potionMap, Item ingredient, int meta, String ... effects) {
        PotionMap.addPotionIngredient(potionMap, ingredient.getRegistryName().toString(), meta, effects);
    }

    private static void addPotionIngredient(List<String> potionMap, String itemRegistryName, int meta, String ... effects) {
        StringJoiner effectsString = new StringJoiner(";");
        Arrays.stream(effects).forEach(effectsString::add);
        potionMap.add(String.format("%s=%s", String.format("%s|%d", itemRegistryName, meta), effectsString.toString()));
    }
}

