/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting;

import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xreliquary.init.ModItems;
import xreliquary.init.XRRecipes;
import xreliquary.reference.Settings;

public class MobCharmRepairRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static final HashMap<Byte, ItemStack> REPAIR_INGREDIENTS = new HashMap();

    public MobCharmRepairRecipe() {
        this.setRegistryName("xreliquary", "mob_charm_repair");
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World worldIn) {
        ItemStack ingredient = ItemStack.field_190927_a;
        int numberIngredients = 0;
        ItemStack mobCharm = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack currentStack = inv.func_70301_a(i);
            if (currentStack.func_190926_b()) continue;
            if (currentStack.func_77973_b() == ModItems.mobCharm) {
                if (!mobCharm.func_190926_b() || !REPAIR_INGREDIENTS.keySet().contains(ModItems.mobCharm.getType(currentStack))) {
                    return false;
                }
                mobCharm = currentStack;
                continue;
            }
            if (!this.isRepairIngredient(currentStack)) {
                return false;
            }
            if (ingredient.func_190926_b()) {
                ingredient = currentStack;
            } else if (!ingredient.func_77969_a(currentStack)) {
                return false;
            }
            ++numberIngredients;
        }
        return !mobCharm.func_190926_b() && !ingredient.func_190926_b() && REPAIR_INGREDIENTS.get(ModItems.mobCharm.getType(mobCharm)).func_77969_a(ingredient) && mobCharm.func_77952_i() >= Settings.Items.MobCharm.dropDurabilityRepair * (numberIngredients - 1);
    }

    private boolean isRepairIngredient(ItemStack stack) {
        for (ItemStack repairIngredient : REPAIR_INGREDIENTS.values()) {
            if (!repairIngredient.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        ItemStack ingredient = ItemStack.field_190927_a;
        int numberIngredients = 0;
        ItemStack mobCharm = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack currentStack = inv.func_70301_a(i);
            if (currentStack.func_190926_b()) continue;
            if (currentStack.func_77973_b() == ModItems.mobCharm) {
                mobCharm = currentStack;
                continue;
            }
            if (ingredient.func_190926_b()) {
                ingredient = currentStack;
            }
            ++numberIngredients;
        }
        ItemStack resultingMobCharm = mobCharm.func_77946_l();
        resultingMobCharm.func_77964_b(Math.max(resultingMobCharm.func_77952_i() - Settings.Items.MobCharm.dropDurabilityRepair * numberIngredients, 0));
        return resultingMobCharm;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public boolean func_192399_d() {
        return true;
    }

    static {
        REPAIR_INGREDIENTS.put((byte)12, XRRecipes.MOLTEN_CORE);
        REPAIR_INGREDIENTS.put((byte)6, XRRecipes.CHELICERAE);
        REPAIR_INGREDIENTS.put((byte)3, XRRecipes.CREEPER_GLAND);
        REPAIR_INGREDIENTS.put((byte)8, XRRecipes.NEBULOUS_HEART);
        REPAIR_INGREDIENTS.put((byte)9, new ItemStack(Items.field_151073_bk));
        REPAIR_INGREDIENTS.put((byte)11, XRRecipes.MOLTEN_CORE);
        REPAIR_INGREDIENTS.put((byte)1, XRRecipes.RIB_BONE);
        REPAIR_INGREDIENTS.put((byte)10, XRRecipes.SLIME_PEARL);
        REPAIR_INGREDIENTS.put((byte)7, XRRecipes.CHELICERAE);
        REPAIR_INGREDIENTS.put((byte)4, new ItemStack((Item)ModItems.witchHat));
        REPAIR_INGREDIENTS.put((byte)2, XRRecipes.WITHER_RIB);
        REPAIR_INGREDIENTS.put((byte)0, XRRecipes.ZOMBIE_HEART);
        REPAIR_INGREDIENTS.put((byte)5, XRRecipes.ZOMBIE_HEART);
        REPAIR_INGREDIENTS.put((byte)13, XRRecipes.GUARDIAN_SPIKE);
    }
}

