/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.IFluxNetworkCache;
import sonar.flux.client.FluxColourHandler;
import sonar.flux.connection.FluxNetworkClient;
import sonar.flux.connection.FluxNetworkInvalid;
import sonar.flux.connection.NetworkSettings;

public class ClientNetworkCache
implements IFluxNetworkCache {
    public Map<Integer, IFluxNetwork> networks = new HashMap<Integer, IFluxNetwork>();
    public List<ClientFlux> disconnected_tiles = new ArrayList<ClientFlux>();

    public void clearNetworks() {
        this.networks.clear();
        this.disconnected_tiles.clear();
    }

    @Override
    public IFluxNetwork getNetwork(int iD) {
        IFluxNetwork network = this.networks.get(iD);
        if (network != null && !network.isFakeNetwork()) {
            return network;
        }
        return FluxNetworkInvalid.INVALID;
    }

    public void updateNetworksFromPacket(Map<Integer, NBTTagCompound> network_updates, NBTHelper.SyncType type) {
        network_updates.forEach((I, NBT2) -> {
            IFluxNetwork network = this.getNetwork((int)I);
            if (network.isFakeNetwork() && type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE})) {
                network = new FluxNetworkClient();
                network.readData((NBTTagCompound)NBT2, type);
                this.networks.put(network.getNetworkID(), network);
            } else {
                network.readData((NBTTagCompound)NBT2, type);
            }
            FluxColourHandler.loadColourCache(network.getNetworkID(), network.getSetting(NetworkSettings.NETWORK_COLOUR).getRGB());
            FluxColourHandler.loadNameCache(network.getNetworkID(), network.getSetting(NetworkSettings.NETWORK_NAME));
        });
    }

    @Override
    public List<IFluxNetwork> getAllowedNetworks(EntityPlayer player, boolean admin) {
        ArrayList<IFluxNetwork> available = new ArrayList<IFluxNetwork>();
        for (IFluxNetwork network : this.getAllNetworks()) {
            if (!network.getPlayerAccess(player).canConnect()) continue;
            available.add(network);
        }
        return available;
    }

    @Override
    public List<IFluxNetwork> getAllNetworks() {
        return new ArrayList<IFluxNetwork>(this.networks.values());
    }

    public static ClientNetworkCache instance() {
        return FluxNetworks.getClientCache();
    }
}

