/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection.transfer.stats;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.flux.api.network.FluxCache;
import sonar.flux.api.tiles.IFluxListenable;
import sonar.flux.api.tiles.IFluxStorage;
import sonar.flux.connection.FluxNetworkBase;
import sonar.flux.connection.FluxNetworkServer;
import sonar.flux.connection.transfer.handlers.ConnectionTransferHandler;

public class NetworkStatistics
implements INBTSyncable {
    public final FluxNetworkBase network;
    public long network_energy;
    public long network_energy_change;
    public long network_energy_capacity;
    public long total_energy_added;
    public long total_energy_removed;
    public int block_connection_count;
    public int flux_connection_count;
    public int flux_plug_count;
    public int flux_point_count;
    public int flux_storage_count;
    public int flux_controller_count;

    public NetworkStatistics(FluxNetworkBase network) {
        this.network = network;
    }

    public void onStartServerTick() {
        FluxNetworkServer network = (FluxNetworkServer)this.network;
        List<IFluxListenable> connections = network.getConnections(FluxCache.flux);
        connections.forEach(flux -> flux.getTransferHandler().onStartServerTick());
    }

    public void onEndWorldTick() {
        FluxNetworkServer network = (FluxNetworkServer)this.network;
        List<IFluxListenable> connections = network.getConnections(FluxCache.flux);
        if (network.hasGuiListeners()) {
            this.block_connection_count = 0;
            this.total_energy_added = 0L;
            this.total_energy_removed = 0L;
            connections.forEach(flux -> {
                flux.getTransferHandler().onEndWorldTick();
                if (flux.getTransferHandler() instanceof ConnectionTransferHandler) {
                    this.block_connection_count += flux.getTransferHandler().getTransfers().size();
                    this.total_energy_added += flux.getTransferHandler().getAdded();
                    this.total_energy_removed += flux.getTransferHandler().getRemoved();
                }
            });
            List storage = network.getConnections(FluxCache.storage);
            long lastEnergy = this.network_energy;
            this.network_energy = 0L;
            this.network_energy_capacity = 0L;
            for (IFluxStorage s : storage) {
                this.network_energy += s.getEnergyStored();
                this.network_energy_capacity += s.getMaxEnergyStored();
            }
            this.network_energy_change = this.network_energy - lastEnergy;
            this.flux_connection_count = network.getConnections(FluxCache.flux).size();
            this.flux_plug_count = network.getConnections(FluxCache.plug).size();
            this.flux_point_count = network.getConnections(FluxCache.point).size();
            this.flux_controller_count = network.getConnections(FluxCache.controller).size();
            this.flux_storage_count = storage.size();
            this.flux_plug_count -= this.flux_storage_count;
            this.flux_point_count -= this.flux_storage_count + this.flux_controller_count;
        } else {
            connections.forEach(flux -> flux.getTransferHandler().onEndWorldTick());
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.network_energy = nbt.func_74763_f("l1");
        this.network_energy_capacity = nbt.func_74763_f("l2");
        this.network_energy_change = nbt.func_74763_f("l3");
        this.total_energy_added = nbt.func_74763_f("l4");
        this.total_energy_removed = nbt.func_74763_f("l5");
        this.block_connection_count = nbt.func_74762_e("i1");
        this.flux_connection_count = nbt.func_74762_e("i2");
        this.flux_plug_count = nbt.func_74762_e("i3");
        this.flux_point_count = nbt.func_74762_e("i4");
        this.flux_storage_count = nbt.func_74762_e("i5");
        this.flux_controller_count = nbt.func_74762_e("i6");
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        long[] write_long = new long[]{this.network_energy, this.network_energy_capacity, this.network_energy_change, this.total_energy_added, this.total_energy_removed};
        for (int i = 0; i < write_long.length; ++i) {
            nbt.func_74772_a("l" + (i + 1), write_long[i]);
        }
        int[] write_int = new int[]{this.block_connection_count, this.flux_connection_count, this.flux_plug_count, this.flux_point_count, this.flux_storage_count, this.flux_controller_count};
        for (int i = 0; i < write_int.length; ++i) {
            nbt.func_74768_a("i" + (i + 1), write_int[i]);
        }
        return nbt;
    }
}

