/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.ActionType;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.connection.transfer.handlers.BaseTransferHandler;

public class PriorityGrouping<T extends IFlux> {
    public final int priority;
    public final List<T> entries;
    private long current_addition;
    private long current_removal;

    public PriorityGrouping(int priority) {
        this.priority = priority;
        this.entries = new ArrayList<T>();
    }

    public int getPriority() {
        return this.priority;
    }

    public List<T> getEntries() {
        return this.entries;
    }

    public boolean valid(IFlux flux) {
        return flux.getCurrentPriority() == this.priority;
    }

    public int hashCode() {
        return this.priority;
    }

    public <T extends IFlux> long updateTotalAddition(EnergyType type, long add) {
        this.current_addition = 0L;
        for (IFlux flux : this.getEntries()) {
            BaseTransferHandler handler = (BaseTransferHandler)flux.getTransferHandler();
            handler.current_addition = handler.addToNetwork(add, type, ActionType.SIMULATE);
            this.current_addition += handler.current_addition;
        }
        return this.current_addition;
    }

    public <T extends IFlux> long updateTotalRemoval(EnergyType type, long remove) {
        this.current_removal = 0L;
        for (IFlux flux : this.getEntries()) {
            BaseTransferHandler handler = (BaseTransferHandler)flux.getTransferHandler();
            handler.current_removal = handler.removeFromNetwork(remove, type, ActionType.SIMULATE);
            this.current_removal += handler.current_removal;
        }
        return this.current_removal;
    }

    public long getAllowedRemoval(T flux, long to_remove) {
        BaseTransferHandler handler = (BaseTransferHandler)flux.getTransferHandler();
        return Math.min((long)((int)Math.ceil((double)handler.current_removal * ((double)handler.current_removal / (double)this.current_removal))), to_remove);
    }

    public long getAllowedAddition(T flux, long to_add) {
        BaseTransferHandler handler = (BaseTransferHandler)flux.getTransferHandler();
        return Math.min((long)((int)Math.ceil((double)handler.current_addition * ((double)handler.current_addition / (double)this.current_addition))), to_add);
    }

    public static <T extends IFlux> PriorityGrouping<T> getOrCreateGrouping(int priority, List<PriorityGrouping<T>> groupings) {
        Optional<PriorityGrouping> group = groupings.stream().filter(g -> g.priority == priority).findFirst();
        if (!group.isPresent()) {
            PriorityGrouping<T> newGroup = new PriorityGrouping<T>(priority);
            groupings.add(newGroup);
            return newGroup;
        }
        return group.get();
    }
}

