/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.gui.tabs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import sonar.core.client.gui.SonarTextField;
import sonar.core.helpers.SonarHelper;
import sonar.flux.FluxConfig;
import sonar.flux.FluxNetworks;
import sonar.flux.FluxTranslate;
import sonar.flux.api.EnumActivationType;
import sonar.flux.api.EnumPriorityType;
import sonar.flux.api.configurator.FluxConfigurationType;
import sonar.flux.client.gui.EnumGuiTab;
import sonar.flux.client.gui.GuiTabAbstract;
import sonar.flux.client.gui.buttons.CheckBox;
import sonar.flux.client.gui.buttons.ConfiguratorSettingButton;
import sonar.flux.client.gui.buttons.FluxTextField;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.PacketUpdateGuiItem;

public class GuiTabIndexConfigurator
extends GuiTabAbstract {
    public HashMap<FluxConfigurationType, Boolean> configs = new HashMap();
    public ItemStack stack = FluxNetworks.proxy.getFluxStack();
    public NBTTagCompound tag;
    public boolean isConfigured = false;
    public SonarTextField priority_field;
    public SonarTextField limit_field;
    public EnumActivationType activationType;
    public int priority;
    public EnumPriorityType priorityType;
    public long transfer_limit;
    public boolean enable_limit;

    public GuiTabIndexConfigurator(List<EnumGuiTab> tabs) {
        super(tabs);
        NBTTagCompound disabledTag = this.stack.func_190925_c("disabled");
        this.tag = this.stack.func_190925_c("configs");
        this.activationType = this.tag.func_74764_b(FluxConfigurationType.REDSTONE_SETTING.getNBTName()) ? EnumActivationType.values()[this.tag.func_74762_e(FluxConfigurationType.REDSTONE_SETTING.getNBTName())] : EnumActivationType.ACTIVATED;
        this.priority = this.tag.func_74764_b(FluxConfigurationType.PRIORITY.getNBTName()) ? this.tag.func_74762_e(FluxConfigurationType.PRIORITY.getNBTName()) : 0;
        this.priorityType = this.tag.func_74764_b(FluxConfigurationType.PRIORITY_SETTING.getNBTName()) ? EnumPriorityType.values()[this.tag.func_74762_e(FluxConfigurationType.PRIORITY_SETTING.getNBTName())] : EnumPriorityType.NORMAL;
        this.transfer_limit = this.tag.func_74764_b(FluxConfigurationType.TRANSFER.getNBTName()) ? this.tag.func_74763_f(FluxConfigurationType.TRANSFER.getNBTName()) : FluxConfig.defaultLimit;
        this.enable_limit = !this.tag.func_74764_b(FluxConfigurationType.TRANSFER_SETTING.getNBTName()) || this.tag.func_74767_n(FluxConfigurationType.TRANSFER_SETTING.getNBTName());
        this.isConfigured = !disabledTag.func_82582_d();
        for (FluxConfigurationType type : FluxConfigurationType.VALUES) {
            boolean disabled = disabledTag.func_74767_n(type.getNBTName());
            this.configs.put(type, disabled);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int colour = NetworkSettings.NETWORK_COLOUR.getValue(this.common).getRGB();
        for (Map.Entry<FluxConfigurationType, Boolean> entry : this.configs.entrySet()) {
            int ordinal = entry.getKey().ordinal;
            this.field_146292_n.add(new CheckBox(this, ordinal + 1, this.getGuiLeft() + 156, this.getGuiTop() + 28 + ordinal * 18, () -> this.configs.get(entry.getKey()) == false, "Copy Setting"));
        }
        this.field_146292_n.add(new ConfiguratorSettingButton(this, 10, this.getGuiLeft() + 8, this.getGuiTop() + 28, 147, 12, colour, "Network: ", this.common.isFakeNetwork() ? "NONE" : (String)this.common.getSyncSetting(NetworkSettings.NETWORK_NAME).getValue()));
        this.field_146292_n.add(new ConfiguratorSettingButton(this, 11, this.getGuiLeft() + 8, this.getGuiTop() + 46, 147, 12, colour, "Redstone: ", this.activationType.comment.t()));
        this.field_146292_n.add(new ConfiguratorSettingButton(this, 13, this.getGuiLeft() + 8, this.getGuiTop() + 82, 147, 12, colour, FluxTranslate.PRIORITY_MODE.t() + ": ", this.priorityType.comment.t()));
        this.field_146292_n.add(new ConfiguratorSettingButton(this, 15, this.getGuiLeft() + 8, this.getGuiTop() + 118, 147, 12, colour, FluxTranslate.ENABLE_LIMIT.t() + ": ", "" + !this.enable_limit));
        this.priority_field = FluxTextField.create(FluxTranslate.PRIORITY.t() + ": ", 12, this.getFontRenderer(), 8, 64, 147, 12).setBoxOutlineColour(colour).setDigitsOnly(true);
        this.priority_field.func_146203_f(8);
        this.priority_field.func_146180_a("" + this.priority);
        this.limit_field = FluxTextField.create(FluxTranslate.TRANSFER_LIMIT.t() + ": ", 14, this.getFontRenderer(), 8, 100, 147, 12).setBoxOutlineColour(colour).setDigitsOnly(true);
        this.limit_field.func_146203_f(8);
        this.limit_field.func_146180_a("" + this.transfer_limit);
        this.fieldList.addAll(Lists.newArrayList((Object[])new SonarTextField[]{this.priority_field, this.limit_field}));
    }

    @Override
    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k >= 1 && button.field_146127_k < FluxConfigurationType.VALUES.length + 1) {
            FluxConfigurationType type;
            this.configs.put(type, this.configs.get(type = FluxConfigurationType.VALUES[button.field_146127_k - 1]) == false);
            this.doReset();
        } else if (button.field_146127_k >= 10) {
            switch (button.field_146127_k) {
                case 10: {
                    this.switchTab(EnumGuiTab.NETWORK_SELECTION);
                    break;
                }
                case 11: {
                    this.activationType = (EnumActivationType)SonarHelper.incrementEnum((Enum)this.activationType, (Enum[])EnumActivationType.values());
                    this.doReset();
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    this.priorityType = (EnumPriorityType)SonarHelper.incrementEnum((Enum)this.priorityType, (Enum[])EnumPriorityType.values());
                    this.doReset();
                    break;
                }
                case 14: {
                    break;
                }
                case 15: {
                    this.enable_limit = !this.enable_limit;
                    this.doReset();
                }
            }
        }
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.renderNetwork(NetworkSettings.NETWORK_NAME.getValue(this.common), NetworkSettings.NETWORK_ACCESS.getValue(this.common), NetworkSettings.NETWORK_COLOUR.getValue(this.common).getRGB(), true, 11, 8);
    }

    public NBTTagCompound getNewDisabledTag() {
        NBTTagCompound disabled = new NBTTagCompound();
        for (Map.Entry<FluxConfigurationType, Boolean> entry : this.configs.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            disabled.func_74757_a(entry.getKey().getNBTName(), true);
        }
        return disabled;
    }

    public NBTTagCompound getNewConfigsTag() {
        NBTTagCompound configs = new NBTTagCompound();
        configs.func_74768_a(FluxConfigurationType.NETWORK.getNBTName(), this.getNetworkID());
        configs.func_74768_a(FluxConfigurationType.REDSTONE_SETTING.getNBTName(), this.activationType.ordinal());
        configs.func_74768_a(FluxConfigurationType.PRIORITY.getNBTName(), this.priority);
        configs.func_74768_a(FluxConfigurationType.PRIORITY_SETTING.getNBTName(), this.priorityType.ordinal());
        configs.func_74772_a(FluxConfigurationType.TRANSFER.getNBTName(), this.transfer_limit);
        configs.func_74757_a(FluxConfigurationType.TRANSFER_SETTING.getNBTName(), this.enable_limit);
        return configs;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTabAbstract.blank_flux_gui);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.isCloseKey(keyCode)) {
            this.sendGuiStackToServer();
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void sendGuiStackToServer() {
        ItemStack stack = FluxNetworks.proxy.getFluxStack();
        if (stack != null) {
            stack.func_77983_a("disabled", (NBTBase)this.getNewDisabledTag());
            stack.func_77983_a("configs", (NBTBase)this.getNewConfigsTag());
            FluxNetworks.network.sendToServer((IMessage)new PacketUpdateGuiItem(stack));
        }
    }

    @Override
    public EnumGuiTab getCurrentTab() {
        return EnumGuiTab.INDEX;
    }

    public ResourceLocation getBackground() {
        return scroller_flux_gui;
    }
}

