/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import com.rwtema.extrautils2.machine.TileMachine;
import com.rwtema.extrautils2.power.energy.PublicEnergyWrapper;
import com.rwtema.extrautils2.tile.RedstoneState;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;

public class TileMachineReceiver
extends TileMachine {
    PublicEnergyWrapper.Receive receive;

    public TileMachineReceiver() {
        this.receive = new PublicEnergyWrapper.Receive((IEnergyStorage)this.storage);
    }

    @Override
    public void process() {
        switch ((RedstoneState)((Object)this.redstone_state.value)) {
            case OPERATE_REDSTONE_ON: {
                if (this.powered.value) break;
                this.setInactive();
                return;
            }
            case OPERATE_REDSTONE_OFF: {
                if (!this.powered.value) break;
                this.setInactive();
                return;
            }
            case OPERATE_REDSTONE_PULSE: {
                if (this.pulses.value != 0) break;
                this.setInactive();
                return;
            }
        }
        if (!this.active || this.machine.getRunError(this.field_145850_b, this.field_174879_c, this, this.speed) != null) {
            this.setInactive();
            return;
        }
        int n = 1 + this.upgrades.getLevel(Upgrade.SPEED);
        for (int i = 0; i < n; ++i) {
            boolean success;
            this.processRecipeInput();
            if (this.curRecipe == null) {
                this.setInactive();
                this.processTime = 0.0f;
                return;
            }
            this.totalTime = this.curRecipe.getProcessingTime(this.itemInputMap, this.fluidInputMap);
            this.energyOutput = this.curRecipe.getEnergyOutput(this.itemInputMap, this.fluidInputMap);
            if (this.totalTime <= 0) {
                success = this.processEnergy(this.energyOutput);
            } else {
                int energyAtTime1 = (int)((float)this.energyOutput * this.processTime / (float)this.totalTime);
                int energyAtTime2 = (int)((float)this.energyOutput * Math.min((float)this.totalTime, this.processTime + this.speed) / (float)this.totalTime);
                success = this.processEnergy(energyAtTime2 - energyAtTime1);
            }
            if (!success) {
                if (this.processTime > 0.0f && this.field_145850_b.func_82737_E() % 20L == 0L) {
                    this.processTime -= 1.0f;
                }
                this.setInactive();
                return;
            }
            this.setActive();
            if (i == 0) {
                this.machine.processingTick(this, this.curRecipe, this.processTime, n);
            }
            this.processTime += this.speed;
            if (!(this.processTime >= (float)this.totalTime)) continue;
            this.processTime = 0.0f;
            this.consumeInputs();
            if (this.pulses.value <= 0) continue;
            --this.pulses.value;
        }
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyHandler(EnumFacing facing) {
        return this.machine != null ? this.receive : null;
    }

    protected boolean processEnergy(int amount) {
        if (this.storage.extractEnergy(amount, true) != amount) {
            return false;
        }
        this.storage.extractEnergy(amount, false);
        return true;
    }
}

