/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world.underground;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.feature.RevampStoneGen;
import vazkii.quark.world.world.UndergroundBiomeGenerator;

public abstract class UndergroundBiome {
    public float dungeonChance;
    public static final Predicate<IBlockState> STONE_PREDICATE = state -> {
        if (state != null) {
            Block block = state.func_177230_c();
            if (block == Blocks.field_150348_b) {
                BlockStone.EnumType blockstone$enumtype = (BlockStone.EnumType)state.func_177229_b((IProperty)BlockStone.field_176247_a);
                return blockstone$enumtype.func_190912_e();
            }
            return block == RevampStoneGen.limestone || block == RevampStoneGen.marble;
        }
        return false;
    };

    public void fill(World world, BlockPos pos, UndergroundBiomeGenerator.UndergroundBiomeGenerationContext context) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185887_b(world, pos) == -1.0f || world.func_175710_j(pos)) {
            return;
        }
        if (this.isFloor(world, pos, state)) {
            context.floorList.add(pos);
            this.fillFloor(world, pos, state);
        } else if (this.isCeiling(world, pos, state)) {
            context.ceilingList.add(pos);
            this.fillCeiling(world, pos, state);
        } else if (this.isWall(world, pos, state)) {
            context.wallMap.put(pos, this.getBorderSide(world, pos));
            this.fillWall(world, pos, state);
        } else if (this.isInside(world, pos, state)) {
            context.insideList.add(pos);
            this.fillInside(world, pos, state);
        }
    }

    public abstract void fillFloor(World var1, BlockPos var2, IBlockState var3);

    public abstract void fillCeiling(World var1, BlockPos var2, IBlockState var3);

    public abstract void fillWall(World var1, BlockPos var2, IBlockState var3);

    public abstract void fillInside(World var1, BlockPos var2, IBlockState var3);

    public void finalFloorPass(World world, BlockPos pos) {
    }

    public void finalCeilingPass(World world, BlockPos pos) {
    }

    public void finalWallPass(World world, BlockPos pos) {
    }

    public void finalInsidePass(World world, BlockPos pos) {
    }

    public final void setupBaseConfig(String category) {
        if (this.hasDungeon()) {
            this.dungeonChance = ModuleLoader.config.getFloat("Dungeon Spawn Chance", category, this.getDungeonChance(), 0.0f, 1.0f, "The chance that dungeons will spawn any given chunk of the biome. The lower the value, the fewer dungeons will spawn.");
        }
        this.setupConfig(category);
    }

    public void setupConfig(String category) {
    }

    public boolean isValidBiome(Biome biome) {
        return true;
    }

    public boolean hasDungeon() {
        return false;
    }

    public float getDungeonChance() {
        return 0.05f;
    }

    public void spawnDungeon(WorldServer world, BlockPos pos, EnumFacing face) {
    }

    boolean isFloor(World world, BlockPos pos, IBlockState state) {
        if (!state.func_185913_b() || !state.func_185914_p()) {
            return false;
        }
        BlockPos upPos = pos.func_177984_a();
        return world.func_175623_d(upPos) || world.func_180495_p(upPos).func_177230_c().func_176200_f((IBlockAccess)world, upPos);
    }

    boolean isCeiling(World world, BlockPos pos, IBlockState state) {
        if (!state.func_185913_b() || !state.func_185914_p()) {
            return false;
        }
        BlockPos downPos = pos.func_177977_b();
        return world.func_175623_d(downPos) || world.func_180495_p(downPos).func_177230_c().func_176200_f((IBlockAccess)world, downPos);
    }

    public boolean isWall(World world, BlockPos pos, IBlockState state) {
        if (!(state.func_185913_b() && state.func_185914_p() && STONE_PREDICATE.apply((Object)state))) {
            return false;
        }
        return this.isBorder(world, pos, state);
    }

    EnumFacing getBorderSide(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            IBlockState stateAt = world.func_180495_p(offsetPos);
            if (!world.func_175623_d(offsetPos) && !stateAt.func_177230_c().func_176200_f((IBlockAccess)world, offsetPos)) continue;
            return facing;
        }
        return null;
    }

    boolean isBorder(World world, BlockPos pos, IBlockState state) {
        return this.getBorderSide(world, pos) != null;
    }

    boolean isInside(World world, BlockPos pos, IBlockState state) {
        return STONE_PREDICATE.apply((Object)state);
    }

    public static Rotation rotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }
}

