/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.world.WorldTypeRealistic;

public class RealisticWorldType
extends Feature {
    WorldType realistic;
    boolean makeRealisticDefault;

    @Override
    public void setupConfig() {
        this.makeRealisticDefault = this.loadPropBool("Make Realistic Default", "Makes realistic the default world type. Only works for singleplayer.", false);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        this.realistic = new WorldTypeRealistic("quark_realistic");
    }

    @Override
    public String getFeatureDescription() {
        return "Allows for usage of a new Realistic world type, made by /u/Soniop.\nhttps://www.reddit.com/r/Minecraft/comments/4nfw3t/more_realistic_generation_preset_in_comment/\nIf you want to use it in multiplayer, set the world type to \"quark_realistic\"";
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void openGUI(GuiScreenEvent.InitGuiEvent.Pre event) {
        GuiCreateWorld create;
        int index;
        if (this.makeRealisticDefault && event.getGui() instanceof GuiCreateWorld && (index = ((Integer)ObfuscationReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)(create = (GuiCreateWorld)event.getGui()), (String)"field_146331_K")).intValue()) == WorldType.field_77137_b.func_82747_f()) {
            ObfuscationReflectionHelper.setPrivateValue(GuiCreateWorld.class, (Object)create, (Object)this.realistic.func_82747_f(), (String)"field_146331_K");
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

