/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.DimensionConfig;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.client.render.RenderArcheologist;
import vazkii.quark.world.entity.EntityArcheologist;
import vazkii.quark.world.item.ItemArcheologistHat;
import vazkii.quark.world.world.ArcheologistHouseGenerator;

public class Archeologist
extends Feature {
    public static final ResourceLocation HOUSE_STRUCTURE = new ResourceLocation("quark", "archeologist_house");
    public static int chance;
    public static int maxY;
    public static int minY;
    public static DimensionConfig dims;
    public static Item archeologist_hat;
    public static boolean enableHat;
    public static boolean sellHat;
    public static boolean dropHat;
    public static boolean hatIncreasesOreYield;
    float increaseChance;

    @Override
    public void setupConfig() {
        chance = this.loadPropInt("Chance Per Chunk", "The chance (1/N) that the generator will attempt to place an Archeologist per chunk. More = less spawns", 5);
        maxY = this.loadPropInt("Max Y", "", 50);
        minY = this.loadPropInt("Min Y", "", 20);
        dims = new DimensionConfig(this.configCategory);
        enableHat = this.loadPropBool("Enable Hat", "", true);
        sellHat = this.loadPropBool("Sell Hat", "Set to false to make the archaeologist not sell the hat", true);
        dropHat = this.loadPropBool("Drop Hat", "Set to false to make the archaeologist not drop the hat", true);
        hatIncreasesOreYield = this.loadPropBool("Hat Increases Ore Yield", "Set to false to make the hat not increase ore yield", true);
        this.increaseChance = (float)this.loadPropDouble("Yield Increase Chance", "The chance for the hat to increase ore yield, 0 is 0%, 1 is 100%", 0.25);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (enableHat) {
            archeologist_hat = new ItemArcheologistHat();
        }
        String archeologistName = "quark:archeologist";
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(archeologistName), EntityArcheologist.class, (String)archeologistName, (int)16, (Object)Quark.instance, (int)80, (int)3, (boolean)true, (int)11900526, (int)11762530);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ArcheologistHouseGenerator(), (int)3000);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityArcheologist.class, RenderArcheologist.FACTORY);
    }

    @SubscribeEvent
    public void onDrops(BlockEvent.HarvestDropsEvent event) {
        if (enableHat && hatIncreasesOreYield) {
            ItemStack drop;
            List drops;
            EntityPlayer player = event.getHarvester();
            if (player == null) {
                return;
            }
            ItemStack hat = player.func_184582_a(EntityEquipmentSlot.HEAD);
            if (hat.func_77973_b() == archeologist_hat && (drops = event.getDrops()).size() == 1 && !(drop = (ItemStack)drops.get(0)).func_190926_b() && !(drop.func_77973_b() instanceof ItemBlock) && drop.func_190916_E() < drop.func_77976_d()) {
                int[] ids;
                IBlockState state = event.getState();
                Block block = state.func_177230_c();
                for (int i : ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(block))) {
                    String name = OreDictionary.getOreName((int)i);
                    if (!name.matches("^ore[A-Z][a-zA-Z]+$")) continue;
                    if (!(player.field_70170_p.field_73012_v.nextFloat() < this.increaseChance)) break;
                    drop.func_190917_f(1);
                    System.out.println("GROWN " + drop);
                    break;
                }
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

