/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.entity;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import vazkii.quark.world.feature.Archeologist;

public class EntityArcheologist
extends EntityLiving
implements IMerchant {
    private MerchantRecipeList buyingList;
    private EntityPlayer buyingPlayer;
    private boolean needsInitilization;
    private int timeUntilReset;
    private int randomTickDivider;

    public EntityArcheologist(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
        if (Archeologist.enableHat && Archeologist.dropHat) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Archeologist.archeologist_hat));
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
    }

    private void populateBuyingList() {
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        Random r = this.field_70170_p.field_73012_v;
        this.buyingList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 2 + this.field_70146_Z.nextInt(3)), new ItemStack(Items.field_151103_aS, 3 + this.field_70146_Z.nextInt(3))));
        if (r.nextBoolean()) {
            this.buyingList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151103_aS, 10 + this.field_70146_Z.nextInt(5)), new ItemStack(Items.field_151166_bC, 1)));
        } else {
            this.buyingList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151016_H, 7 + this.field_70146_Z.nextInt(10)), new ItemStack(Items.field_151166_bC, 1)));
        }
        if (r.nextBoolean()) {
            this.buyingList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151044_h, 16 + this.field_70146_Z.nextInt(10)), new ItemStack(Items.field_151166_bC, 1)));
        }
        if (r.nextBoolean()) {
            this.buyingList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 12 + this.field_70146_Z.nextInt(10)), new ItemStack(Items.field_151045_i, 1)));
        }
        if (r.nextBoolean()) {
            if (r.nextBoolean()) {
                this.buyingList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 8 + this.field_70146_Z.nextInt(5)), new ItemStack(Items.field_151035_b, 1)));
            } else {
                this.buyingList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 6 + this.field_70146_Z.nextInt(4)), new ItemStack(Items.field_151037_a, 1)));
            }
        }
        if (Archeologist.enableHat && Archeologist.sellHat) {
            this.buyingList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 6 + this.field_70146_Z.nextInt(4)), ItemStack.field_190927_a, new ItemStack(Archeologist.archeologist_hat, 1), 0, 1));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected void func_70619_bc() {
        if (--this.randomTickDivider <= 0) {
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            if (!this.isTrading() && this.timeUntilReset > 0) {
                --this.timeUntilReset;
                if (this.timeUntilReset <= 0 && this.needsInitilization) {
                    for (MerchantRecipe merchantrecipe : this.buyingList) {
                        if (!merchantrecipe.func_82784_g()) continue;
                        merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                }
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (flag) {
            itemstack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (this.func_70089_S() && !this.isTrading() && !player.func_70093_af()) {
            if (this.buyingList == null) {
                this.populateBuyingList();
            }
            if (hand == EnumHand.MAIN_HAND) {
                player.func_71029_a(StatList.field_188074_H);
            }
            if (!this.field_70170_p.field_72995_K && !this.buyingList.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            } else if (this.buyingList.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70932_a_(EntityPlayer player) {
        this.buyingPlayer = player;
    }

    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public MerchantRecipeList func_70934_b(@Nonnull EntityPlayer player) {
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        return this.buyingList;
    }

    public void func_70930_a(MerchantRecipeList recipeList) {
        this.buyingList = recipeList;
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
    }

    public void func_70933_a(@Nonnull MerchantRecipe recipe) {
        recipe.func_77399_f();
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilReset = 40;
        }
    }

    public void func_110297_a_(@Nonnull ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(stack.func_190926_b() ? SoundEvents.field_187913_gm : SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Nonnull
    public World func_190670_t_() {
        return this.field_70170_p;
    }

    @Nonnull
    public BlockPos func_190671_u_() {
        return this.func_180425_c();
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.buyingList != null) {
            compound.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = compound.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound);
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.isTrading() ? SoundEvents.field_187914_gn : SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }
}

