/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.block.BlockQuarkBush;
import vazkii.quark.world.block.BlockHugeGlowshroom;
import vazkii.quark.world.feature.UndergroundBiomes;

public class BlockGlowshroom
extends BlockQuarkBush
implements IGrowable {
    protected static final AxisAlignedBB MUSHROOM_AABB = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.6, 0.8);

    public BlockGlowshroom() {
        super("glowshroom");
        this.func_149715_a(0.9375f);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return MUSHROOM_AABB;
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == UndergroundBiomes.glowcelium;
    }

    public void func_180650_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, Random rand) {
        if (rand.nextInt(UndergroundBiomes.glowshroomGrowthRate) == 0) {
            int i = 5;
            int j = 4;
            for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
                if (worldIn.func_180495_p(blockpos).func_177230_c() != this || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (worldIn.func_175623_d(blockpos1) && this.func_180671_f(worldIn, blockpos1, this.func_176223_P())) {
                    pos = blockpos1;
                }
                blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            }
            if (worldIn.func_175623_d(blockpos1) && this.func_180671_f(worldIn, blockpos1, this.func_176223_P())) {
                worldIn.func_180501_a(blockpos1, this.func_176223_P(), 2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (rand.nextInt(20) == 0) {
            worldIn.func_175688_a(EnumParticleTypes.END_ROD, (double)pos.func_177958_n() + 0.2 + (double)rand.nextFloat() * 0.6, (double)((float)pos.func_177956_o() + 0.3f), (double)pos.func_177952_p() + 0.2 + (double)rand.nextFloat() * 0.6, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return UndergroundBiomes.bigGlowshroomsEnabled;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return UndergroundBiomes.bigGlowshroomsEnabled && (double)rand.nextFloat() < 0.4;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (UndergroundBiomes.bigGlowshroomsEnabled) {
            worldIn.func_175698_g(pos);
            if (!BlockHugeGlowshroom.setInPosition(worldIn, rand, pos, true)) {
                worldIn.func_175656_a(pos, this.func_176223_P());
            }
        }
    }
}

