/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;
import vazkii.arl.recipe.MultiRecipe;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.quark.base.module.Feature;

public class SlabsToBlocks
extends Feature {
    public static Map<IBlockState, ItemStack> slabs = new HashMap<IBlockState, ItemStack>();
    int originalSize;
    private MultiRecipe multiRecipe;

    @Override
    public void setupConfig() {
        this.originalSize = this.loadPropInt("Vanilla stack size", "The stack size for the vanilla slab recipe, used for automatically detecting slab recipes", 6);
    }

    @Override
    public void postPreInit(FMLPreInitializationEvent event) {
        this.multiRecipe = new MultiRecipe(new ResourceLocation("quark", "slabs_to_blocks"));
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ArrayList recipeList = new ArrayList(CraftingManager.field_193380_a.func_148742_b());
        for (ResourceLocation res : recipeList) {
            Item outputItem;
            Block outputBlock;
            IRecipe recipe = (IRecipe)CraftingManager.field_193380_a.func_82594_a((Object)res);
            if (!(recipe instanceof ShapedRecipes) && !(recipe instanceof ShapedOreRecipe)) continue;
            NonNullList recipeItems = recipe instanceof ShapedRecipes ? ((ShapedRecipes)recipe).field_77574_d : recipe.func_192400_c();
            ItemStack output = recipe.func_77571_b();
            if (output.func_190926_b() || output.func_190916_E() != this.originalSize || !((outputBlock = Block.func_149634_a((Item)(outputItem = output.func_77973_b()))) instanceof BlockSlab)) continue;
            ItemStack outStack = ItemStack.field_190927_a;
            int inputItems = 0;
            for (Ingredient ingredient : recipeItems) {
                ItemStack recipeItem = ItemStack.field_190927_a;
                ItemStack[] matches = ingredient.func_193365_a();
                if (matches.length > 0) {
                    recipeItem = matches[0];
                }
                if (recipeItem == null || recipeItem.func_190926_b()) continue;
                if (outStack.func_190926_b()) {
                    outStack = recipeItem;
                }
                if (ItemStack.func_179545_c((ItemStack)outStack, (ItemStack)recipeItem)) {
                    ++inputItems;
                    continue;
                }
                outStack = ItemStack.field_190927_a;
                break;
            }
            if (outStack.func_190926_b() || inputItems != 3) continue;
            ItemStack outCopy = outStack.func_77946_l();
            if (outCopy.func_77952_i() == Short.MAX_VALUE) {
                outCopy.func_77964_b(0);
            }
            ItemStack in = output.func_77946_l();
            in.func_190920_e(1);
            if (in.func_77973_b() instanceof ItemBlock && outCopy.func_77973_b() instanceof ItemBlock) {
                Block block = Block.func_149634_a((Item)outCopy.func_77973_b());
                slabs.put(block.func_176203_a(outCopy.func_77952_i()), in);
            }
            RecipeHandler.addShapelessOreDictRecipe((MultiRecipe)this.multiRecipe, (ItemStack)outCopy, (Object[])new Object[]{in, in});
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

