/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.tweaks.ai.EntityAIOpenDoubleDoor;

public class DoubleDoors
extends Feature {
    boolean allowVillagers = true;

    @Override
    public void setupConfig() {
        this.allowVillagers = this.loadPropBool("Allow Villagers to use Double Doors", "", this.allowVillagers);
    }

    @SubscribeEvent
    public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityVillager && this.allowVillagers) {
            EntityVillager villager = (EntityVillager)event.getEntity();
            Iterator it = villager.field_70714_bg.field_75782_a.iterator();
            while (it.hasNext()) {
                EntityAIBase te = ((EntityAITasks.EntityAITaskEntry)it.next()).field_75733_a;
                if (te instanceof EntityAIOpenDoubleDoor) {
                    return;
                }
                if (!(te instanceof EntityAIOpenDoor)) continue;
                it.remove();
                villager.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoubleDoor((EntityLiving)villager, true));
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer().func_70093_af() || event.isCanceled() || event.getResult() == Event.Result.DENY || event.getUseBlock() == Event.Result.DENY) {
            return;
        }
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(event.getPos()).func_185899_b((IBlockAccess)world, event.getPos());
        Block block = state.func_177230_c();
        if (!(block instanceof BlockDoor)) {
            return;
        }
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a);
        boolean isOpen = (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b);
        BlockDoor.EnumHingePosition isMirrored = (BlockDoor.EnumHingePosition)state.func_177229_b((IProperty)BlockDoor.field_176521_M);
        BlockPos mirrorPos = event.getPos().func_177972_a(isMirrored == BlockDoor.EnumHingePosition.RIGHT ? direction.func_176735_f() : direction.func_176746_e());
        BlockPos doorPos = state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? mirrorPos : mirrorPos.func_177977_b();
        IBlockState other = world.func_180495_p(doorPos).func_185899_b((IBlockAccess)world, doorPos);
        if (state.func_185904_a() != Material.field_151573_f && other.func_177230_c() == block && other.func_177229_b((IProperty)BlockDoor.field_176520_a) == direction && (Boolean)other.func_177229_b((IProperty)BlockDoor.field_176519_b) == isOpen && other.func_177229_b((IProperty)BlockDoor.field_176521_M) != isMirrored) {
            IBlockState newState = other.func_177231_a((IProperty)BlockDoor.field_176519_b);
            world.func_180501_a(doorPos, newState, 10);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"malisisdoors"};
    }
}

