/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.client.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.tweaks.feature.CompassesWorkEverywhere;

public class CompassAngleGetter
implements IItemPropertyGetter {
    private static final String TAG_CALCULATED = "quark:compass_calculated";
    private static final String TAG_WAS_IN_NETHER = "quark:compass_in_nether";
    private static final String TAG_POSITION_SET = "quark:compass_position_set";
    private static final String TAG_NETHER_TARGET_X = "quark:nether_x";
    private static final String TAG_NETHER_TARGET_Z = "quark:nether_z";
    double rotation;
    double rota;
    long lastUpdateTick;

    public static void tickCompass(EntityPlayer player, ItemStack stack) {
        boolean nether;
        boolean calculated = CompassAngleGetter.isCalculated(stack);
        boolean bl = nether = player.field_70170_p.field_73011_w.func_186058_p() == DimensionType.NETHER;
        if (calculated) {
            boolean isInPortal;
            boolean wasInNether = ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)false);
            BlockPos pos = player.func_180425_c();
            boolean bl2 = isInPortal = player.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150427_aO;
            if (nether && !wasInNether && isInPortal) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_NETHER_TARGET_X, (int)pos.func_177958_n());
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_NETHER_TARGET_Z, (int)pos.func_177952_p());
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)true);
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_POSITION_SET, (boolean)true);
            } else if (!nether && wasInNether) {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)false);
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_POSITION_SET, (boolean)false);
            }
        } else {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)true);
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)nether);
        }
    }

    static boolean isCalculated(ItemStack stack) {
        return stack.func_77942_o() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)false);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
        double angle;
        boolean set;
        EntityLivingBase entity;
        if (entityIn == null && !stack.func_82839_y()) {
            return 0.0f;
        }
        if (!(!CompassesWorkEverywhere.enableCompassNerf || stack.func_77942_o() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)false))) {
            return 0.0f;
        }
        boolean carried = entityIn != null;
        Object object = entity = carried ? entityIn : stack.func_82836_z();
        if (worldIn == null) {
            worldIn = entity.field_70170_p;
        }
        boolean calculate = false;
        BlockPos target = new BlockPos(0, 0, 0);
        if (worldIn.field_73011_w.func_76569_d()) {
            calculate = true;
            target = worldIn.func_175694_M();
        } else if (worldIn.field_73011_w.func_186058_p() == DimensionType.THE_END && CompassesWorkEverywhere.enableEnd) {
            calculate = true;
        } else if (worldIn.field_73011_w.func_186058_p() == DimensionType.NETHER && CompassAngleGetter.isCalculated(stack) && CompassesWorkEverywhere.enableNether && (set = ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_POSITION_SET, (boolean)false))) {
            int x = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_NETHER_TARGET_X, (int)0);
            int z = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_NETHER_TARGET_Z, (int)0);
            calculate = true;
            target = new BlockPos(x, 0, z);
        }
        if (calculate) {
            double d1 = carried ? (double)entity.field_70177_z : this.getFrameRotation((EntityItemFrame)entity);
            d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
            double d2 = this.getAngleToPosition((Entity)entity, target) / (Math.PI * 2);
            angle = 0.5 - (d1 - 0.25 - d2);
        } else {
            angle = Math.random();
        }
        if (carried) {
            angle = this.wobble(worldIn, angle);
        }
        return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    private double wobble(World worldIn, double angle) {
        if (worldIn.func_82737_E() != this.lastUpdateTick) {
            this.lastUpdateTick = worldIn.func_82737_E();
            double d0 = angle - this.rotation;
            d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.rota += d0 * 0.1;
            this.rota *= 0.8;
            this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
        }
        return this.rotation;
    }

    @SideOnly(value=Side.CLIENT)
    private double getFrameRotation(EntityItemFrame frame) {
        return MathHelper.func_188209_b((int)(180 + frame.field_174860_b.func_176736_b() * 90));
    }

    @SideOnly(value=Side.CLIENT)
    private double getAngleToPosition(Entity entity, BlockPos blockpos) {
        return Math.atan2((double)blockpos.func_177952_p() - entity.field_70161_v, (double)blockpos.func_177958_n() - entity.field_70165_t);
    }
}

