/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.entity;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntitySoulPowder
extends Entity {
    private static final DataParameter<Integer> TARGET_X = EntityDataManager.func_187226_a(EntitySoulPowder.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TARGET_Z = EntityDataManager.func_187226_a(EntitySoulPowder.class, (DataSerializer)DataSerializers.field_187192_b);
    int liveTicks = 0;
    private static final String TAG_TARGET_X = "targetX";
    private static final String TAG_TARGET_Z = "targetZ";

    public EntitySoulPowder(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.0f, 0.0f);
    }

    public EntitySoulPowder(World worldIn, int x, int z) {
        this(worldIn);
        this.field_70180_af.func_187227_b(TARGET_X, (Object)x);
        this.field_70180_af.func_187227_b(TARGET_Z, (Object)z);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TARGET_X, (Object)0);
        this.field_70180_af.func_187214_a(TARGET_Z, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        double posSpread = 0.4;
        double scale = 0.08;
        double rotateSpread = 1.5;
        double rise = 0.05;
        int maxLiveTime = 6000;
        int particles = 20;
        double trigArg = (double)this.liveTicks * 0.32;
        if (maxLiveTime - this.liveTicks < particles) {
            particles = maxLiveTime - this.liveTicks;
        }
        Vec3d vec = new Vec3d((double)((Integer)this.field_70180_af.func_187225_a(TARGET_X)).intValue(), this.field_70163_u, (double)((Integer)this.field_70180_af.func_187225_a(TARGET_Z)).intValue()).func_178786_a(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72432_b().func_186678_a(scale);
        double bpx = this.field_70165_t + vec.field_72450_a * (double)this.liveTicks + Math.cos(trigArg) * rotateSpread;
        double bpy = this.field_70163_u + vec.field_72448_b * (double)this.liveTicks + (double)this.liveTicks * rise;
        double bpz = this.field_70161_v + vec.field_72449_c * (double)this.liveTicks + Math.sin(trigArg) * rotateSpread;
        for (int i = 0; i < particles; ++i) {
            double px = bpx + (Math.random() - 0.5) * posSpread;
            double py = bpy + (Math.random() - 0.5) * posSpread;
            double pz = bpz + (Math.random() - 0.5) * posSpread;
            this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, px, py, pz, 0.2, 0.12, 0.1, new int[0]);
            if (!(Math.random() < 0.05)) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.FALLING_DUST, px, py, pz, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150425_aM.func_176223_P())});
        }
        if (Math.random() < 0.1) {
            this.field_70170_p.func_184148_a(null, bpx, bpy, bpz, SoundEvents.field_187551_bH, SoundCategory.PLAYERS, 0.2f, 1.0f);
        }
        ++this.liveTicks;
        if (this.liveTicks > maxLiveTime || this.field_70170_p.func_180495_p(new BlockPos(bpx, bpy, bpz)).func_185898_k()) {
            this.func_70106_y();
        }
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        this.field_70180_af.func_187227_b(TARGET_X, (Object)compound.func_74762_e(TAG_TARGET_X));
        this.field_70180_af.func_187227_b(TARGET_Z, (Object)compound.func_74762_e(TAG_TARGET_Z));
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        compound.func_74768_a(TAG_TARGET_X, ((Integer)this.field_70180_af.func_187225_a(TARGET_X)).intValue());
        compound.func_74768_a(TAG_TARGET_Z, ((Integer)this.field_70180_af.func_187225_a(TARGET_Z)).intValue());
    }
}

