/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import com.google.common.collect.ImmutableSet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;

public class PanoramaMaker
extends Feature {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    File panoramaDir;
    File fullresPanoramaDir;
    File currentDir;
    float rotationYaw;
    float rotationPitch;
    int panoramaStep;
    boolean takingPanorama;
    int currentWidth;
    int currentHeight;
    boolean overridenOnce;
    boolean overrideMainMenu;
    int panoramaSize;
    boolean fullscreen;

    @Override
    public void setupConfig() {
        this.overrideMainMenu = this.loadPropBool("Use panorama screenshots on main menu", "", true);
        this.fullscreen = this.loadPropBool("Fullres screenshots", "Take panorama screenshots without changing the render size", false);
        this.panoramaSize = this.loadPropInt("Panorama Picture Resolution", "", 256);
    }

    @SubscribeEvent
    public void loadMainMenu(GuiOpenEvent event) {
        if (this.overrideMainMenu && !this.overridenOnce && event.getGui() instanceof GuiMainMenu) {
            File mcDir = ModuleLoader.configFile.getParentFile().getParentFile();
            File panoramasDir = new File(mcDir, "/screenshots/panoramas");
            ArrayList<File[]> validFiles = new ArrayList<File[]>();
            ImmutableSet set = ImmutableSet.of((Object)"panorama_0.png", (Object)"panorama_1.png", (Object)"panorama_2.png", (Object)"panorama_3.png", (Object)"panorama_4.png", (Object)"panorama_5.png", (Object[])new String[0]);
            if (panoramasDir.exists()) {
                File mainMenu = new File(panoramasDir, "main_menu");
                File[] subDirs = mainMenu.exists() ? new File[]{mainMenu} : panoramasDir.listFiles(f -> f.isDirectory() && !f.getName().endsWith("fullres"));
                for (File f2 : subDirs) {
                    if (!set.stream().allMatch(s -> new File(f2, (String)s).exists())) continue;
                    validFiles.add(f2.listFiles(f1 -> set.contains((Object)f1.getName())));
                }
            }
            if (!validFiles.isEmpty()) {
                Object[] files = (File[])validFiles.get(new Random().nextInt(validFiles.size()));
                Arrays.sort(files);
                Minecraft mc = Minecraft.func_71410_x();
                ResourceLocation[] resources = new ResourceLocation[6];
                for (int i = 0; i < resources.length; ++i) {
                    Object f3 = files[i];
                    try {
                        BufferedImage img = ImageIO.read((File)f3);
                        DynamicTexture tex = new DynamicTexture(img);
                        String name = "quark:" + ((File)f3).getName();
                        resources[i] = mc.func_110434_K().func_110578_a(name, tex);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                try {
                    Field field = ObfuscationReflectionHelper.findField(GuiMainMenu.class, (String)"field_73978_o");
                    field.setAccessible(true);
                    if (Modifier.isFinal(field.getModifiers())) {
                        Field modfield = Field.class.getDeclaredField("modifiers");
                        modfield.setAccessible(true);
                        modfield.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                    }
                    field.set(null, resources);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.overridenOnce = true;
        }
    }

    @SubscribeEvent
    public void takeScreenshot(ScreenshotEvent event) {
        if (this.takingPanorama) {
            return;
        }
        if (GuiScreen.func_146271_m() && GuiScreen.func_146272_n() && Minecraft.func_71410_x().field_71462_r == null) {
            this.takingPanorama = true;
            this.panoramaStep = 0;
            if (this.panoramaDir == null) {
                this.panoramaDir = new File(event.getScreenshotFile().getParentFile(), "panoramas");
            }
            if (!this.panoramaDir.exists()) {
                this.panoramaDir.mkdirs();
            }
            int i = 0;
            String ts = PanoramaMaker.getTimestamp();
            do {
                if (this.fullscreen) {
                    if (i == 0) {
                        this.currentDir = new File(this.panoramaDir + "_fullres", ts);
                        continue;
                    }
                    this.currentDir = new File(this.panoramaDir, ts + "_" + i + "_fullres");
                    continue;
                }
                this.currentDir = i == 0 ? new File(this.panoramaDir, ts) : new File(this.panoramaDir, ts + "_" + i);
            } while (this.currentDir.exists());
            this.currentDir.mkdirs();
            event.setCanceled(true);
            TextComponentString panoramaDirComponent = new TextComponentString(this.currentDir.getName());
            panoramaDirComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, this.currentDir.getAbsolutePath())).func_150228_d(Boolean.valueOf(true));
            event.setResultMessage((ITextComponent)new TextComponentTranslation("quarkmisc.panoramaSaved", new Object[]{panoramaDirComponent}));
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.takingPanorama) {
            if (event.phase == TickEvent.Phase.START) {
                if (this.panoramaStep == 0) {
                    mc.field_71474_y.field_74319_N = true;
                    this.currentWidth = mc.field_71443_c;
                    this.currentHeight = mc.field_71440_d;
                    this.rotationYaw = mc.field_71439_g.field_70177_z;
                    this.rotationPitch = mc.field_71439_g.field_70125_A;
                    if (!this.fullscreen) {
                        mc.func_71370_a(this.panoramaSize, this.panoramaSize);
                    }
                }
                switch (this.panoramaStep) {
                    case 1: {
                        mc.field_71439_g.field_70177_z = 180.0f;
                        mc.field_71439_g.field_70125_A = 0.0f;
                        break;
                    }
                    case 2: {
                        mc.field_71439_g.field_70177_z = -90.0f;
                        mc.field_71439_g.field_70125_A = 0.0f;
                        break;
                    }
                    case 3: {
                        mc.field_71439_g.field_70177_z = 0.0f;
                        mc.field_71439_g.field_70125_A = 0.0f;
                        break;
                    }
                    case 4: {
                        mc.field_71439_g.field_70177_z = 90.0f;
                        mc.field_71439_g.field_70125_A = 0.0f;
                        break;
                    }
                    case 5: {
                        mc.field_71439_g.field_70177_z = 180.0f;
                        mc.field_71439_g.field_70125_A = -90.0f;
                        break;
                    }
                    case 6: {
                        mc.field_71439_g.field_70177_z = 180.0f;
                        mc.field_71439_g.field_70125_A = 90.0f;
                    }
                }
                mc.field_71439_g.field_70126_B = mc.field_71439_g.field_70177_z;
                mc.field_71439_g.field_70127_C = mc.field_71439_g.field_70125_A;
            } else {
                if (this.panoramaStep > 0) {
                    PanoramaMaker.saveScreenshot(this.currentDir, "panorama_" + (this.panoramaStep - 1) + ".png", mc.field_71443_c, mc.field_71440_d, mc.func_147110_a());
                }
                ++this.panoramaStep;
                if (this.panoramaStep == 7) {
                    mc.field_71474_y.field_74319_N = false;
                    this.takingPanorama = false;
                    mc.field_71439_g.field_70177_z = this.rotationYaw;
                    mc.field_71439_g.field_70125_A = this.rotationPitch;
                    mc.field_71439_g.field_70126_B = mc.field_71439_g.field_70177_z;
                    mc.field_71439_g.field_70127_C = mc.field_71439_g.field_70125_A;
                    mc.func_71370_a(this.currentWidth, this.currentHeight);
                }
            }
        }
    }

    public static void saveScreenshot(File dir, String screenshotName, int width, int height, Framebuffer buffer) {
        try {
            BufferedImage bufferedimage = ScreenShotHelper.func_186719_a((int)width, (int)height, (Framebuffer)buffer);
            File file2 = new File(dir, screenshotName);
            ForgeHooksClient.onScreenshot((BufferedImage)bufferedimage, (File)file2);
            ImageIO.write((RenderedImage)bufferedimage, "png", file2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getTimestamp() {
        String s = DATE_FORMAT.format(new Date()).toString();
        return s;
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @Override
    public String getFeatureDescription() {
        return "Shift-Ctrl-F2 for panorama screenshot.\nPanoramas show up in the main menu.\nRename a panorama folder to 'main_menu' and it'll always show that one.";
    }
}

