/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.module.Feature;

public class EnchantedBooksShowItems
extends Feature {
    private static List<ItemStack> testItems;
    private static final Pattern RL_MATCHER;

    @Override
    public void setupConfig() {
        String[] testItemsArr = this.loadPropStringList("Items to Test", "", new String[]{"minecraft:diamond_sword", "minecraft:diamond_pickaxe", "minecraft:diamond_shovel", "minecraft:diamond_axe", "minecraft:diamond_hoe", "minecraft:diamond_helmet", "minecraft:diamond_chestplate", "minecraft:diamond_leggings", "minecraft:diamond_boots", "minecraft:shears", "minecraft:bow", "minecraft:fishing_rod", "minecraft:elytra"});
        testItems = new ArrayList<ItemStack>();
        for (String s : testItemsArr) {
            Matcher match = RL_MATCHER.matcher(s);
            if (!match.matches()) continue;
            String metaGroup = match.group(2);
            int meta = metaGroup == null || metaGroup.isEmpty() ? 0 : Integer.parseInt(metaGroup);
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(match.group(1)));
            if (item == null) continue;
            testItems.add(new ItemStack(item, 1, meta));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void makeTooltip(ItemTooltipEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() == Items.field_151134_bR) {
            Minecraft mc = Minecraft.func_71410_x();
            List tooltip = event.getToolTip();
            int tooltipIndex = 0;
            List<EnchantmentData> enchants = EnchantedBooksShowItems.getEnchantedBookEnchantments(stack);
            block0: for (EnchantmentData ed : enchants) {
                String match = ed.field_76302_b.func_77316_c(ed.field_76303_c);
                while (tooltipIndex < tooltip.size()) {
                    if (((String)tooltip.get(tooltipIndex)).equals(match)) {
                        List<ItemStack> items = EnchantedBooksShowItems.getItemsForEnchantment(ed.field_76302_b);
                        if (items.isEmpty()) continue block0;
                        int len = 3 + items.size() * 9;
                        String spaces = "";
                        while (mc.field_71466_p.func_78256_a(spaces) < len) {
                            spaces = spaces + " ";
                        }
                        tooltip.add(tooltipIndex + 1, spaces);
                        continue block0;
                    }
                    ++tooltipIndex;
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (stack.func_77973_b() == Items.field_151134_bR) {
            Minecraft mc = Minecraft.func_71410_x();
            List tooltip = event.getLines();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)event.getX(), (float)(event.getY() + 12), (float)0.0f);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            List<EnchantmentData> enchants = EnchantedBooksShowItems.getEnchantedBookEnchantments(stack);
            block0: for (EnchantmentData ed : enchants) {
                String match = TextFormatting.func_110646_a((String)ed.field_76302_b.func_77316_c(ed.field_76303_c));
                for (int tooltipIndex = 0; tooltipIndex < tooltip.size(); ++tooltipIndex) {
                    String line = TextFormatting.func_110646_a((String)((String)tooltip.get(tooltipIndex)));
                    if (line == null || !line.equals(match)) continue;
                    int drawn = 0;
                    List<ItemStack> items = EnchantedBooksShowItems.getItemsForEnchantment(ed.field_76302_b);
                    for (ItemStack testStack : items) {
                        if (!ed.field_76302_b.func_92089_a(testStack)) continue;
                        mc.func_175599_af().func_175042_a(testStack, 6 + drawn * 18, tooltipIndex * 20 - 2);
                        ++drawn;
                    }
                    continue block0;
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    public static List<ItemStack> getItemsForEnchantment(Enchantment e) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : testItems) {
            if (!e.func_92089_a(stack)) continue;
            list.add(stack);
        }
        return list;
    }

    public static List<EnchantmentData> getEnchantedBookEnchantments(ItemStack stack) {
        NBTTagList nbttaglist = ItemEnchantedBook.func_92110_g((ItemStack)stack);
        ArrayList<EnchantmentData> retList = new ArrayList<EnchantmentData>(nbttaglist.func_74745_c() + 1);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            short j = nbttagcompound.func_74765_d("id");
            Enchantment enchantment = Enchantment.func_185262_c((int)j);
            short level = nbttagcompound.func_74765_d("lvl");
            if (enchantment == null) continue;
            retList.add(new EnchantmentData(enchantment, (int)level));
        }
        return retList;
    }

    static {
        RL_MATCHER = Pattern.compile("^((?:\\w+:)?\\w+)(@\\d+)?$");
    }
}

