/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.asm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class ClassTransformer
implements IClassTransformer,
Opcodes {
    private static final String ASM_HOOKS = "vazkii/quark/base/asm/ASMHooks";
    private static final Map<String, Transformer> transformers = new HashMap<String, Transformer>();
    private static MethodSignature layerCountIndex;
    private static MethodAction layerCountTransformer;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformers.containsKey(transformedName)) {
            ClassTransformer.log("Transforming " + transformedName);
            return (byte[])transformers.get(transformedName).apply(basicClass);
        }
        return basicClass;
    }

    private static byte[] transformModelBiped(byte[] basicClass) {
        MethodSignature sig = new MethodSignature("setRotationAngles", "func_78087_a", "(FFFFFFLnet/minecraft/entity/Entity;)V");
        return ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig, ClassTransformer.combine(node -> node.getOpcode() == 177, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 7));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "updateEmotes", "(Lnet/minecraft/entity/Entity;)V", false));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
    }

    private static byte[] transformRenderItem(byte[] basicClass) {
        MethodSignature sig1 = new MethodSignature("renderItem", "func_180454_a", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/IBakedModel;)V");
        MethodSignature sig2 = new MethodSignature("renderEffect", "func_191966_a", "(Lnet/minecraft/client/renderer/block/model/IBakedModel;)V");
        byte[] transClass = basicClass;
        transClass = ClassTransformer.transform(transClass, ClassTransformer.forMethod(sig1, method -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "setColorRuneTargetStack", "(Lnet/minecraft/item/ItemStack;)V", false));
            method.instructions.insertBefore(method.instructions.getFirst(), newInstructions);
            return true;
        }), ClassTransformer.forMethod(sig2, ClassTransformer.combine(node -> node.getOpcode() == 18 && ((LdcInsnNode)node).cst.equals(-8372020), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "getRuneColor", "(I)I", false));
            method.instructions.insert(node, newInstructions);
            return false;
        })));
        return transClass;
    }

    private static byte[] transformLayerArmorBase(byte[] basicClass) {
        MethodSignature sig1 = new MethodSignature("renderArmorLayer", "func_188361_a", "(Lnet/minecraft/entity/EntityLivingBase;FFFFFFFLnet/minecraft/inventory/EntityEquipmentSlot;)V");
        MethodSignature sig2 = new MethodSignature("renderEnchantedGlint", "func_188364_a", "(Lnet/minecraft/client/renderer/entity/RenderLivingBase;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/client/model/ModelBase;FFFFFFF)V");
        MethodSignature target = new MethodSignature("color", "", "(FFFF)V");
        byte[] transClass = basicClass;
        transClass = ClassTransformer.transform(transClass, ClassTransformer.forMethod(sig1, method -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 9));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "setColorRuneTargetStack", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/inventory/EntityEquipmentSlot;)V", false));
            method.instructions.insertBefore(method.instructions.getFirst(), newInstructions);
            return true;
        }));
        if (!ClassTransformer.hasOptifine(sig2.toString())) {
            transClass = ClassTransformer.transform(transClass, ClassTransformer.forMethod(sig2, ClassTransformer.combine(node -> node.getOpcode() == 184 && target.matches((MethodInsnNode)node), (method, node) -> {
                InsnList newInstructions = new InsnList();
                newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "applyRuneColor", "()V", false));
                method.instructions.insert(node, newInstructions);
                return false;
            })));
        }
        return transClass;
    }

    private static byte[] transformEntityBoat(byte[] basicClass) {
        MethodSignature sig1 = new MethodSignature("attackEntityFrom", "func_70097_a", "(Lnet/minecraft/util/DamageSource;F)Z");
        MethodSignature sig2 = new MethodSignature("onUpdate", "func_70071_h_", "()V");
        MethodSignature target = new MethodSignature("dropItemWithOffset", "func_145778_a", "(Lnet/minecraft/item/Item;IF)Lnet/minecraft/entity/item/EntityItem;");
        byte[] transClass = ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig1, ClassTransformer.combine(node -> node.getOpcode() == 182 && target.matches((MethodInsnNode)node), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "dropBoatBanner", "(Lnet/minecraft/entity/item/EntityBoat;)V", false));
            method.instructions.insert(node, newInstructions);
            return true;
        })));
        transClass = ClassTransformer.transform(transClass, ClassTransformer.forMethod(sig2, method -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "onBoatUpdate", "(Lnet/minecraft/entity/item/EntityBoat;)V", false));
            method.instructions.insertBefore(method.instructions.getFirst(), newInstructions);
            return true;
        }));
        return transClass;
    }

    private static byte[] transformRenderBoat(byte[] basicClass) {
        MethodSignature sig = new MethodSignature("doRender", "func_188300_b", "(Lnet/minecraft/entity/item/EntityBoat;DDDFF)V");
        MethodSignature target = new MethodSignature("render", "func_78088_a", "(Lnet/minecraft/entity/Entity;FFFFFF)V");
        return ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig, ClassTransformer.combine(node -> node.getOpcode() == 182 && target.matches((MethodInsnNode)node), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 9));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "renderBannerOnBoat", "(Lnet/minecraft/entity/item/EntityBoat;F)V", false));
            method.instructions.insert(node, newInstructions);
            return true;
        })));
    }

    private static byte[] transformBlockPistonBase(byte[] basicClass) {
        MethodSignature sig1 = new MethodSignature("doMove", "func_176319_a", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;Z)Z");
        MethodSignature sig2 = new MethodSignature("canPush", "func_185646_a", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;ZLnet/minecraft/util/EnumFacing;)Z");
        MethodSignature target = new MethodSignature("hasTileEntity", "", "(Lnet/minecraft/block/state/IBlockState;)Z");
        MethodSignature target2 = new MethodSignature("canMove", "func_177253_a", "()Z");
        byte[] transClass = ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig2, ClassTransformer.combine(node -> node.getOpcode() == 182 && target.matches((MethodInsnNode)node), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "shouldPistonMoveTE", "(ZLnet/minecraft/block/state/IBlockState;)Z", false));
            method.instructions.insert(node, newInstructions);
            return true;
        })));
        return ClassTransformer.transform(transClass, ClassTransformer.forMethod(sig1, ClassTransformer.combine(node -> node.getOpcode() == 182 && target2.matches((MethodInsnNode)node), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 5));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "onPistonMove", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/BlockPistonStructureHelper;Lnet/minecraft/util/EnumFacing;Z)V", false));
            method.instructions.insert(node, newInstructions);
            return true;
        })));
    }

    private static byte[] transformContainerWorkbench(byte[] basicClass) {
        return ClassTransformer.transformTransferStackInSlot(basicClass, "getMinInventoryBoundaryCrafting", "getMaxInventoryBoundaryCrafting");
    }

    private static byte[] transformContainerMerchant(byte[] basicClass) {
        return ClassTransformer.transformTransferStackInSlot(basicClass, "getMinInventoryBoundaryVillager", "getMaxInventoryBoundaryVillager");
    }

    private static byte[] transformTransferStackInSlot(byte[] basicClass, String firstHook, String secondHook) {
        MethodSignature sig = new MethodSignature("transferStackInSlot", "func_82846_b", "(Lnet/minecraft/entity/player/EntityPlayer;I)Lnet/minecraft/item/ItemStack;");
        MethodSignature target = new MethodSignature("mergeItemStack", "func_75135_a", "(Lnet/minecraft/item/ItemStack;IIZ)Z");
        return ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig, ClassTransformer.combine(node -> node.getOpcode() == 182 && target.matches((MethodInsnNode)node), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new InsnNode(91));
            newInstructions.add((AbstractInsnNode)new InsnNode(87));
            newInstructions.add((AbstractInsnNode)new InsnNode(92));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, firstHook, "(II)I", false));
            newInstructions.add((AbstractInsnNode)new InsnNode(91));
            newInstructions.add((AbstractInsnNode)new InsnNode(87));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, secondHook, "(II)I", false));
            newInstructions.add((AbstractInsnNode)new InsnNode(91));
            newInstructions.add((AbstractInsnNode)new InsnNode(87));
            newInstructions.add((AbstractInsnNode)new InsnNode(91));
            newInstructions.add((AbstractInsnNode)new InsnNode(87));
            method.instructions.insertBefore(node, newInstructions);
            return false;
        })));
    }

    private static byte[] transformTileEntityPiston(byte[] basicClass) {
        MethodSignature clearPistonTileEntitySig = new MethodSignature("clearPistonTileEntity", "func_145866_f", "()V");
        MethodSignature updateSig = new MethodSignature("update", "func_73660_a", "()V");
        MethodSignature target = new MethodSignature("setBlockState", "func_180501_a", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z");
        MethodAction setPistonBlockAction = ClassTransformer.combine(node -> node.getOpcode() == 182 && target.matches((MethodInsnNode)node), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "setPistonBlock", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z", false));
            method.instructions.insert(node, newInstructions);
            method.instructions.remove(node);
            return true;
        });
        MethodAction onUpdateAction = method -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "onPistonUpdate", "(Lnet/minecraft/tileentity/TileEntityPiston;)V", false));
            method.instructions.insertBefore(method.instructions.getFirst(), newInstructions);
            return true;
        };
        byte[] transClass = basicClass;
        transClass = ClassTransformer.transform(transClass, ClassTransformer.forMethod(updateSig, onUpdateAction));
        transClass = ClassTransformer.transform(transClass, ClassTransformer.forMethod(clearPistonTileEntitySig, setPistonBlockAction));
        transClass = ClassTransformer.transform(transClass, ClassTransformer.forMethod(updateSig, setPistonBlockAction));
        return transClass;
    }

    private static byte[] transformTileEntityPistonRenderer(byte[] basicClass) {
        MethodSignature sig = new MethodSignature("renderStateModel", "func_188186_a", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/client/renderer/BufferBuilder;Lnet/minecraft/world/World;Z)Z");
        return ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig, method -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 5));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "renderPistonBlock", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/client/renderer/BufferBuilder;Lnet/minecraft/world/World;Z)Z", false));
            newInstructions.add((AbstractInsnNode)new InsnNode(172));
            method.instructions = newInstructions;
            return true;
        }));
    }

    private static byte[] transformWorldServer(byte[] basicClass) {
        MethodSignature sig = new MethodSignature("areAllPlayersAsleep", "func_73056_e", "()Z");
        return ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig, method -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "isEveryoneAsleep", "(Lnet/minecraft/world/World;)I", false));
            newInstructions.add((AbstractInsnNode)new InsnNode(89));
            LabelNode label = new LabelNode();
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(153, label));
            newInstructions.add((AbstractInsnNode)new InsnNode(4));
            newInstructions.add((AbstractInsnNode)new InsnNode(100));
            newInstructions.add((AbstractInsnNode)new InsnNode(172));
            newInstructions.add((AbstractInsnNode)label);
            newInstructions.add((AbstractInsnNode)new InsnNode(87));
            method.instructions.insertBefore(method.instructions.getFirst(), newInstructions);
            return true;
        }));
    }

    private static byte[] transformBlockModelRenderer(byte[] basicClass) {
        MethodSignature sig1 = new MethodSignature("renderQuadsFlat", "func_187496_a", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;IZLnet/minecraft/client/renderer/BufferBuilder;Ljava/util/List;Ljava/util/BitSet;)V");
        MethodSignature target = new MethodSignature("putPosition", "func_178987_a", "(DDD)V");
        if (ClassTransformer.hasOptifine(sig1.toString())) {
            return basicClass;
        }
        return ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig1, ClassTransformer.combine(node -> node.getOpcode() == 182 && target.matches((MethodInsnNode)node), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 6));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 18));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "putColorsFlat", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;Lnet/minecraft/client/renderer/block/model/BakedQuad;I)V", false));
            method.instructions.insertBefore(node, newInstructions);
            return true;
        })));
    }

    private static byte[] transformRecipeAddPattern(byte[] basicClass) {
        MethodSignature sig = new MethodSignature("matches", "func_77569_a", "(Lnet/minecraft/inventory/InventoryCrafting;Lnet/minecraft/world/World;)Z");
        return ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig, layerCountTransformer));
    }

    private static byte[] transformItemBanner(byte[] basicClass) {
        MethodSignature sig = new MethodSignature("appendHoverTextFromTileEntityTag", "func_185054_a", "(Lnet/minecraft/item/ItemStack;Ljava/util/List;)V");
        return ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig, layerCountTransformer));
    }

    private static byte[] transformRender(byte[] basicClass) {
        MethodSignature sig = new MethodSignature("renderEntityOnFire", "func_76977_a", "(Lnet/minecraft/entity/Entity;DDDF)V");
        return ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig, method -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(24, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(24, 4));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(24, 6));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 8));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "renderFire", "(Lnet/minecraft/entity/Entity;DDDF)Z", false));
            LabelNode label = new LabelNode();
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(153, label));
            newInstructions.add((AbstractInsnNode)new InsnNode(177));
            newInstructions.add((AbstractInsnNode)label);
            method.instructions.insertBefore(method.instructions.getFirst(), newInstructions);
            return true;
        }));
    }

    private static byte[] transform(byte[] basicClass, TransformerAction ... methods) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        boolean didAnything = false;
        for (TransformerAction pair : methods) {
            ClassTransformer.log("Applying Transformation to method (" + pair.sig + ")");
            didAnything |= ClassTransformer.findMethodAndTransform(node, pair.sig, pair.action);
        }
        if (didAnything) {
            SafeClassWriter writer = new SafeClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static boolean findMethodAndTransform(ClassNode node, MethodSignature sig, MethodAction pred) {
        for (MethodNode method : node.methods) {
            if (!sig.matches(method)) continue;
            ClassTransformer.log("Located Method, patching...");
            boolean finish = pred.test(method);
            ClassTransformer.log("Patch result: " + finish);
            return finish;
        }
        ClassTransformer.log("Failed to locate the method!");
        return false;
    }

    public static MethodAction combine(NodeFilter filter, NodeAction action) {
        return mnode -> ClassTransformer.applyOnNode(mnode, filter, action);
    }

    public static boolean applyOnNode(MethodNode method, NodeFilter filter, NodeAction action) {
        ListIterator iterator = method.instructions.iterator();
        boolean didAny = false;
        while (iterator.hasNext()) {
            AbstractInsnNode anode = (AbstractInsnNode)iterator.next();
            if (!filter.test(anode)) continue;
            ClassTransformer.log("Located patch target node " + ClassTransformer.getNodeString(anode));
            didAny = true;
            if (!action.test(method, anode)) continue;
            break;
        }
        return didAny;
    }

    private static void log(String str) {
        LogManager.getLogger((String)"Quark ASM").info(str);
    }

    private static String getNodeString(AbstractInsnNode node) {
        Textifier printer = new Textifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)printer);
        node.accept((MethodVisitor)visitor);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString().replaceAll("\n", "").trim();
    }

    private static boolean hasOptifine(String msg) {
        try {
            if (Class.forName("optifine.OptiFineTweaker") != null) {
                ClassTransformer.log("Optifine Detected. Disabling Patch for " + msg);
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private static TransformerAction forMethod(MethodSignature sig, MethodAction action) {
        return new TransformerAction(sig, action);
    }

    static {
        transformers.put("net.minecraft.client.model.ModelBiped", ClassTransformer::transformModelBiped);
        transformers.put("net.minecraft.client.renderer.RenderItem", ClassTransformer::transformRenderItem);
        transformers.put("net.minecraft.client.renderer.entity.layers.LayerArmorBase", ClassTransformer::transformLayerArmorBase);
        transformers.put("net.minecraft.client.renderer.entity.RenderBoat", ClassTransformer::transformRenderBoat);
        transformers.put("net.minecraft.entity.item.EntityBoat", ClassTransformer::transformEntityBoat);
        transformers.put("net.minecraft.block.BlockPistonBase", ClassTransformer::transformBlockPistonBase);
        transformers.put("net.minecraft.inventory.ContainerWorkbench", ClassTransformer::transformContainerWorkbench);
        transformers.put("net.minecraft.inventory.ContainerMerchant", ClassTransformer::transformContainerMerchant);
        transformers.put("net.minecraft.tileentity.TileEntityPiston", ClassTransformer::transformTileEntityPiston);
        transformers.put("net.minecraft.client.renderer.tileentity.TileEntityPistonRenderer", ClassTransformer::transformTileEntityPistonRenderer);
        transformers.put("net.minecraft.world.WorldServer", ClassTransformer::transformWorldServer);
        transformers.put("net.minecraft.client.renderer.BlockModelRenderer", ClassTransformer::transformBlockModelRenderer);
        transformers.put("net.minecraft.item.crafting.RecipesBanners$RecipeAddPattern", ClassTransformer::transformRecipeAddPattern);
        transformers.put("net.minecraft.item.ItemBanner", ClassTransformer::transformItemBanner);
        transformers.put("net.minecraft.client.renderer.entity.Render", ClassTransformer::transformRender);
        layerCountIndex = new MethodSignature("getPatterns", "func_175113_c", "(Lnet/minecraft/item/ItemStack;)I");
        layerCountTransformer = ClassTransformer.combine(node -> node.getOpcode() == 184 && layerCountIndex.matches((MethodInsnNode)node), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "shiftLayerCount", "(I)I", false));
            method.instructions.insert(node, newInstructions);
            return true;
        });
    }

    private static final class TransformerAction {
        private final MethodSignature sig;
        private final MethodAction action;

        public TransformerAction(MethodSignature sig, MethodAction action) {
            this.sig = sig;
            this.action = action;
        }
    }

    private static interface NodeAction
    extends BiPredicate<MethodNode, AbstractInsnNode> {
    }

    private static interface NodeFilter
    extends Predicate<AbstractInsnNode> {
    }

    private static interface MethodAction
    extends Predicate<MethodNode> {
    }

    private static interface Transformer
    extends Function<byte[], byte[]> {
    }

    public static class SafeClassWriter
    extends ClassWriter {
        public SafeClassWriter(int flags) {
            super(flags);
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> d;
            Class<?> c;
            LaunchClassLoader classLoader = Launch.classLoader;
            try {
                c = Class.forName(type1.replace('/', '.'), false, (ClassLoader)classLoader);
                d = Class.forName(type2.replace('/', '.'), false, (ClassLoader)classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
            if (c.isAssignableFrom(d)) {
                return type1;
            }
            if (d.isAssignableFrom(c)) {
                return type2;
            }
            if (c.isInterface() || d.isInterface()) {
                return "java/lang/Object";
            }
            while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
            }
            return c.getName().replace('.', '/');
        }
    }

    public static class MethodSignature {
        private final String funcName;
        private final String srgName;
        private final String funcDesc;

        public MethodSignature(String funcName, String srgName, String funcDesc) {
            this.funcName = funcName;
            this.srgName = srgName;
            this.funcDesc = funcDesc;
        }

        public String toString() {
            return "Names [" + this.funcName + ", " + this.srgName + "] Descriptor " + this.funcDesc;
        }

        public boolean matches(String methodName, String methodDesc) {
            return (methodName.equals(this.funcName) || methodName.equals(this.srgName)) && methodDesc.equals(this.funcDesc);
        }

        public boolean matches(MethodNode method) {
            return this.matches(method.name, method.desc);
        }

        public boolean matches(MethodInsnNode method) {
            return this.matches(method.name, method.desc);
        }
    }
}

