/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.feature;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.misc.feature.LockDirectionHotkey;

public class DispensersPlaceBlocks
extends Feature {
    List<String> blacklist;

    @Override
    public void setupConfig() {
        String[] blacklistArray = this.loadPropStringList("Blacklist", "Blocks that dispensers should not be able to place", new String[]{"minecraft:water", "minecraft:flowing_water", "minecraft:lava", "minecraft:flowing_lava", "minecraft:fire", "botania:specialflower"});
        this.blacklist = Arrays.asList(blacklistArray);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        for (ResourceLocation r : Block.field_149771_c.func_148742_b()) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)r);
            Item item = Item.func_150898_a((Block)block);
            if (block == null || !(item instanceof ItemBlock) || this.blacklist.contains(r.toString()) || BlockDispenser.field_149943_a.func_148741_d((Object)item)) continue;
            BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)new BehaviourBlock((ItemBlock)item, block));
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"blockdispenser"};
    }

    public class BehaviourBlock
    extends BehaviorDefaultDispenseItem {
        ItemBlock item;
        Block block;

        public BehaviourBlock(ItemBlock item, Block block) {
            this.item = item;
            this.block = block;
        }

        @Nonnull
        public ItemStack func_82487_b(IBlockSource par1IBlockSource, ItemStack par2ItemStack) {
            EnumFacing facing = (EnumFacing)par1IBlockSource.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            BlockPos pos = par1IBlockSource.func_180699_d().func_177972_a(facing);
            World world = par1IBlockSource.func_82618_k();
            if (world.func_175623_d(pos) && this.block.func_176196_c(world, pos)) {
                int meta = this.item.func_77647_b(par2ItemStack.func_77952_i());
                IBlockState state = !(this.block instanceof BlockPistonBase) ? this.block.func_176203_a(meta) : this.block.func_176223_P();
                LockDirectionHotkey.setBlockRotated(world, state, pos, facing);
                SoundType soundtype = this.block.getSoundType(state, world, pos, null);
                world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                par2ItemStack.func_190918_g(1);
                return par2ItemStack;
            }
            return super.func_82487_b(par1IBlockSource, par2ItemStack);
        }
    }
}

