/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.blocks.storage.ModularStorageConfiguration;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.RemoteStorageContainer;
import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.items.storage.StorageModuleItem;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class RemoteStorageTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable,
DefaultSidedInventory {
    public static final String CMD_SETGLOBAL = "relay.setGlobal";
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    public static final Key<Boolean> PARAM_GLOBAL = new Key("global", Type.BOOLEAN);
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, RemoteStorageContainer.factory, 8);
    private ItemStackList[] slots = new ItemStackList[]{ItemStackList.create((int)0), ItemStackList.create((int)0), ItemStackList.create((int)0), ItemStackList.create((int)0)};
    private int[] maxsize = new int[]{0, 0, 0, 0};
    private int[] numStacks = new int[]{0, 0, 0, 0};
    private boolean[] global = new boolean[]{false, false, false, false};
    private int version = 0;
    private int timer = 0;

    public RemoteStorageTileEntity() {
        super((long)ModularStorageConfiguration.REMOTE_MAXENERGY.get(), (long)ModularStorageConfiguration.REMOTE_RECEIVEPERTICK.get());
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public boolean isPowerLow() {
        return this.getStoredPower() < (long)ModularStorageConfiguration.remoteShareLocal.get();
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = 5;
        int hasPower = this.isPowerLow() ? 0 : 8;
        RemoteStorageIdRegistry registry = RemoteStorageIdRegistry.getRegistry(this.func_145831_w());
        for (int i = 0; i < 4; ++i) {
            ItemStack stack;
            NBTTagCompound tagCompound;
            if (!this.inventoryHelper.containsItem(i) || (tagCompound = (stack = this.inventoryHelper.getStackInSlot(i)).func_77978_p()) == null || !tagCompound.func_74764_b("id")) continue;
            int rf = this.isGlobal(i) ? ModularStorageConfiguration.remoteShareGlobal.get() : ModularStorageConfiguration.remoteShareLocal.get();
            rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f);
            if (this.getStoredPower() < (long)rf) {
                return;
            }
            this.consumeEnergy(rf);
            this.func_70296_d();
            int id = tagCompound.func_74762_e("id");
            registry.publishStorage(id, new GlobalCoordinate(this.func_174877_v(), this.func_145831_w().field_73011_w.getDimension()));
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return RemoteStorageContainer.factory.getAccessibleSlots();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return RemoteStorageContainer.factory.isInputSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return RemoteStorageContainer.factory.isOutputSlot(index);
    }

    public int getVersion() {
        return this.version;
    }

    public void updateVersion() {
        ++this.version;
        this.func_70296_d();
    }

    public boolean hasStorage(int index) {
        return this.inventoryHelper.containsItem(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public void compact(int id) {
        int si = this.findRemoteIndex(id);
        if (si == -1) {
            return;
        }
        ItemStackList s = this.findStacksForId(id);
        InventoryHelper.compactStacks((List)s, (int)0, (int)this.maxsize[si]);
        this.updateStackCount(si);
        this.func_70296_d();
    }

    public int cycle(int id) {
        int si = this.findRemoteIndex(id);
        if (si == -1) {
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("id")) continue;
                return stack.func_77978_p().func_74762_e("id");
            }
            return -1;
        }
        for (int i = si + 1; i < si + 4; ++i) {
            int ii = i % 4;
            ItemStack stack = this.func_70301_a(ii);
            if (stack.func_190926_b() || stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("id")) continue;
            return stack.func_77978_p().func_74762_e("id");
        }
        return id;
    }

    private void link(int index) {
        int id;
        if (index >= 4) {
            index -= 4;
        }
        if (!this.inventoryHelper.containsItem(index)) {
            return;
        }
        if (!this.inventoryHelper.containsItem(index + 4)) {
            return;
        }
        ItemStack source = this.inventoryHelper.getStackInSlot(index);
        ItemStack dest = this.inventoryHelper.getStackInSlot(index + 4);
        if (dest.func_77952_i() != 6) {
            return;
        }
        NBTTagCompound tagCompound = source.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            source.func_77982_d(tagCompound);
        }
        if (tagCompound.func_74764_b("id")) {
            id = tagCompound.func_74762_e("id");
        } else {
            RemoteStorageIdRegistry registry = RemoteStorageIdRegistry.getRegistry(this.func_145831_w());
            id = registry.getNewId();
            registry.save();
            tagCompound.func_74768_a("id", id);
        }
        tagCompound = dest.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            dest.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a("id", id);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (index < 4) {
            this.copyFromModule(stack, index);
        }
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        if (!this.func_145831_w().field_72995_K) {
            this.link(index);
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == ModularStorageSetup.storageModuleItem;
    }

    public int findRemoteIndex(int id) {
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound tagCompound;
            ItemStack stack;
            if (!this.inventoryHelper.containsItem(i) || (stack = this.inventoryHelper.getStackInSlot(i)).func_77952_i() == 6 || (tagCompound = stack.func_77978_p()) == null || !tagCompound.func_74764_b("id") || id != tagCompound.func_74762_e("id")) continue;
            return i;
        }
        return -1;
    }

    public boolean isGlobal(int index) {
        return this.global[index];
    }

    public void setGlobal(int index, boolean global) {
        this.global[index] = global;
        this.markDirtyClient();
    }

    public ItemStackList getRemoteStacks(int si) {
        return this.slots[si];
    }

    public ItemStack getRemoteSlot(int si, int index) {
        if (index >= this.slots[si].size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.slots[si].get(index);
    }

    public void updateCount(int si, int cnt) {
        this.numStacks[si] = cnt;
        StorageModuleItem.updateStackSize(this.func_70301_a(si), this.numStacks[si]);
    }

    public int getCount(int si) {
        return this.numStacks[si];
    }

    public int getMaxStacks(int si) {
        return this.maxsize[si];
    }

    public ItemStack decrStackSizeRemote(int si, int index, int amount) {
        boolean hasNew;
        if (index >= this.slots[si].size()) {
            return ItemStack.field_190927_a;
        }
        ItemStackList stacks = this.slots[si];
        boolean hasOld = !((ItemStack)stacks.get(index)).func_190926_b();
        ItemStack its = ItemStack.field_190927_a;
        if (!((ItemStack)stacks.get(index)).func_190926_b()) {
            if (((ItemStack)stacks.get(index)).func_190916_E() <= amount) {
                ItemStack old = (ItemStack)stacks.get(index);
                stacks.set(index, (Object)ItemStack.field_190927_a);
                its = old;
            } else {
                its = ((ItemStack)stacks.get(index)).func_77979_a(amount);
                if (((ItemStack)stacks.get(index)).func_190926_b()) {
                    stacks.set(index, (Object)ItemStack.field_190927_a);
                }
            }
        }
        boolean bl = hasNew = !((ItemStack)stacks.get(index)).func_190926_b();
        if (hasOld && !hasNew) {
            int n = si;
            this.numStacks[n] = this.numStacks[n] - 1;
        } else if (hasNew && !hasOld) {
            int n = si;
            this.numStacks[n] = this.numStacks[n] + 1;
        }
        StorageModuleItem.updateStackSize(this.func_70301_a(si), this.numStacks[si]);
        this.func_70296_d();
        return its;
    }

    public ItemStack removeStackFromSlotRemote(int si, int index) {
        if (index >= this.slots[si].size()) {
            return ItemStack.field_190927_a;
        }
        ItemStackList stacks = this.slots[si];
        if (((ItemStack)stacks.get(index)).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack old = (ItemStack)stacks.get(index);
        stacks.set(index, (Object)ItemStack.field_190927_a);
        int n = si;
        this.numStacks[n] = this.numStacks[n] - 1;
        StorageModuleItem.updateStackSize(this.func_70301_a(si), this.numStacks[si]);
        this.func_70296_d();
        return old;
    }

    public boolean updateRemoteSlot(int si, int limit, int index, ItemStack stack) {
        boolean hasNew;
        if (index >= this.slots[si].size()) {
            return false;
        }
        boolean hasOld = !((ItemStack)this.slots[si].get(index)).func_190926_b();
        this.slots[si].set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > limit) {
            if (limit <= 0) {
                stack.func_190920_e(0);
            } else {
                stack.func_190920_e(limit);
            }
        }
        boolean bl = hasNew = !stack.func_190926_b();
        if (hasOld && !hasNew) {
            int n = si;
            this.numStacks[n] = this.numStacks[n] - 1;
        } else if (hasNew && !hasOld) {
            int n = si;
            this.numStacks[n] = this.numStacks[n] + 1;
        }
        StorageModuleItem.updateStackSize(this.func_70301_a(si), this.numStacks[si]);
        this.func_70296_d();
        return true;
    }

    public ItemStack findStorageWithId(int id) {
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound tagCompound;
            ItemStack stack;
            if (!this.inventoryHelper.containsItem(i) || (stack = this.inventoryHelper.getStackInSlot(i)).func_77952_i() == 6 || (tagCompound = stack.func_77978_p()) == null || !tagCompound.func_74764_b("id") || id != tagCompound.func_74762_e("id")) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStackList findStacksForId(int id) {
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound tagCompound;
            ItemStack stack;
            if (!this.inventoryHelper.containsItem(i) || (stack = this.inventoryHelper.getStackInSlot(i)).func_77952_i() == 6 || (tagCompound = stack.func_77978_p()) == null || !tagCompound.func_74764_b("id") || id != tagCompound.func_74762_e("id")) continue;
            return this.slots[i];
        }
        return ItemStackList.EMPTY;
    }

    public void copyToModule(int si) {
        ItemStack stack = this.inventoryHelper.getStackInSlot(si);
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77952_i() == 6) {
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        int cnt = this.writeSlotsToNBT(tagCompound, "Items", si);
        tagCompound.func_74768_a("count", cnt);
    }

    public void copyFromModule(ItemStack stack, int si) {
        if (stack.func_190926_b()) {
            this.setMaxSize(si, 0);
            return;
        }
        if (stack.func_77952_i() == 6) {
            this.setMaxSize(si, 0);
            return;
        }
        this.setMaxSize(si, StorageModuleItem.MAXSIZE[stack.func_77952_i()]);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            this.readSlotsFromNBT(tagCompound, "Items", si);
        }
        this.updateStackCount(si);
    }

    private void setMaxSize(int si, int ms) {
        this.maxsize[si] = ms;
        this.slots[si] = ItemStackList.create((int)ms);
        this.numStacks[si] = 0;
    }

    private void updateStackCount(int si) {
        this.numStacks[si] = 0;
        ItemStackList stacks = this.slots[si];
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            int n = si;
            this.numStacks[n] = this.numStacks[n] + 1;
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.version = tagCompound.func_74762_e("version");
        for (int i = 0; i < 4; ++i) {
            int max = tagCompound.func_74762_e("maxSize" + i);
            this.setMaxSize(i, max);
            this.readSlotsFromNBT(tagCompound, "Slots" + i, i);
            this.global[i] = tagCompound.func_74767_n("global" + i);
            this.updateStackCount(i);
        }
    }

    private void readSlotsFromNBT(NBTTagCompound tagCompound, String tagname, int index) {
        NBTTagList bufferTagList = tagCompound.func_150295_c(tagname, 10);
        for (int i = 0; i < Math.min(bufferTagList.func_74745_c(), this.slots[index].size()); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.slots[index].set(i, (Object)new ItemStack(nbtTagCompound));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("version", this.version);
        for (int i = 0; i < 4; ++i) {
            this.writeSlotsToNBT(tagCompound, "Slots" + i, i);
            tagCompound.func_74768_a("maxSize" + i, this.maxsize[i]);
            tagCompound.func_74757_a("global" + i, this.global[i]);
        }
    }

    private int writeSlotsToNBT(NBTTagCompound tagCompound, String tagname, int index) {
        NBTTagList bufferTagList = new NBTTagList();
        int cnt = 0;
        for (int i = 0; i < this.slots[index].size(); ++i) {
            ItemStack stack = (ItemStack)this.slots[index].get(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(nbtTagCompound);
                if (stack.func_190916_E() > 0) {
                    ++cnt;
                }
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a(tagname, (NBTBase)bufferTagList);
        return cnt;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return rc;
        }
        if (CMD_SETGLOBAL.equals(command)) {
            int index = (Integer)params.get(PARAM_INDEX);
            boolean global = (Boolean)params.get(PARAM_GLOBAL);
            this.setGlobal(index, global);
            return true;
        }
        return false;
    }
}

