/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.genetics;

import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import thut.api.entity.genetics.Gene;
import thut.api.entity.genetics.GeneRegistry;

public class Alleles {
    final Gene[] alleles = new Gene[2];
    final Random rand = new Random();
    Gene expressed;

    public Alleles() {
    }

    public Alleles(Gene gene1, Gene gene2) {
        this.alleles[0] = gene1;
        this.alleles[1] = gene2;
        if (gene1 == null || gene2 == null) {
            throw new IllegalStateException("Genes cannot be null");
        }
    }

    public Gene[] getAlleles() {
        return this.alleles;
    }

    public <T extends Gene> T getExpressed() {
        if (this.expressed == null) {
            this.refreshExpressed();
        }
        return (T)this.expressed;
    }

    public void refreshExpressed() {
        if (this.alleles[0] == null || this.alleles[1] == null) {
            throw new IllegalStateException("Genes cannot be null");
        }
        Gene a = this.alleles[0].getMutationRate() > this.rand.nextFloat() ? this.alleles[0].mutate() : this.alleles[0];
        Gene b = this.alleles[1].getMutationRate() > this.rand.nextFloat() ? this.alleles[1].mutate() : this.alleles[1];
        this.expressed = a.interpolate(b);
    }

    public void load(NBTTagCompound tag) throws Exception {
        this.expressed = GeneRegistry.load(tag.func_74775_l("expressed"));
        this.getAlleles()[0] = GeneRegistry.load(tag.func_74775_l("gene1"));
        this.getAlleles()[1] = GeneRegistry.load(tag.func_74775_l("gene2"));
    }

    public NBTTagCompound save() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("expressed", (NBTBase)GeneRegistry.save(this.getExpressed()));
        tag.func_74782_a("gene1", (NBTBase)GeneRegistry.save(this.getAlleles()[0]));
        tag.func_74782_a("gene2", (NBTBase)GeneRegistry.save(this.getAlleles()[1]));
        return tag;
    }
}

