/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.flow;

import buildcraft.api.core.IStackFilter;
import buildcraft.api.inventory.IItemTransactor;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventItem;
import buildcraft.api.transport.pipe.PipeEventStatement;
import buildcraft.api.transport.pipe.PipeFlow;
import buildcraft.lib.inventory.ItemTransactorHelper;
import buildcraft.lib.inventory.NoSpaceTransactor;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.misc.data.DelayedList;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.net.cache.BuildCraftObjectCaches;
import buildcraft.transport.BCTransportStatements;
import buildcraft.transport.net.MessageMultiPipeItem;
import buildcraft.transport.net.PipeItemMessageQueue;
import buildcraft.transport.pipe.flow.TravellingItem;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PipeFlowItems
extends PipeFlow
implements IFlowItems {
    private static final double EXTRACT_SPEED = 0.08;
    public static final int NET_CREATE_ITEM = 2;
    private final DelayedList<TravellingItem> items = new DelayedList();

    public PipeFlowItems(IPipe pipe) {
        super(pipe);
    }

    public PipeFlowItems(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        long tickNow = pipe.getHolder().getPipeWorld().func_82737_E();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            TravellingItem item = new TravellingItem(list.func_150305_b(i), tickNow);
            if (item.stack.func_190926_b()) continue;
            this.items.add(item.getCurrentDelay(tickNow), item);
        }
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        List<List<TravellingItem>> allItems = this.items.getAllElements();
        NBTTagList list = new NBTTagList();
        long tickNow = this.pipe.getHolder().getPipeWorld().func_82737_E();
        for (List<TravellingItem> l : allItems) {
            for (TravellingItem item : l) {
                list.func_74742_a((NBTBase)item.writeToNbt(tickNow));
            }
        }
        nbt.func_74782_a("items", (NBTBase)list);
        return nbt;
    }

    @Override
    public void readPayload(int id, PacketBuffer bufIn, Side msgSide) throws IOException {
        PacketBufferBC buffer = PacketBufferBC.asPacketBufferBc((ByteBuf)bufIn);
        if (msgSide == Side.CLIENT && id == 2) {
            int stackId = buffer.readInt();
            Supplier<ItemStack> link = BuildCraftObjectCaches.retrieveItemStack(stackId);
            int count = buffer.readUnsignedShort();
            TravellingItem item = new TravellingItem(link, count);
            item.toCenter = buffer.readBoolean();
            item.side = buffer.func_179257_a(EnumFacing.class);
            item.colour = MessageUtil.readEnumOrNull((ByteBuf)buffer, EnumDyeColor.class);
            item.timeToDest = buffer.readUnsignedShort();
            item.tickStarted = this.pipe.getHolder().getPipeWorld().func_82737_E() + 1L;
            item.tickFinished = item.tickStarted + (long)item.timeToDest;
            this.items.add(item.timeToDest + 1, item);
        }
    }

    public void handleClientReceviedItems(List<MessageMultiPipeItem.TravellingItemData> list) {
        for (MessageMultiPipeItem.TravellingItemData data : list) {
            this.handleClientReceviedItem(data);
        }
    }

    public void handleClientReceviedItem(MessageMultiPipeItem.TravellingItemData data) {
        int stackId = data.stackId;
        Supplier<ItemStack> link = BuildCraftObjectCaches.retrieveItemStack(stackId);
        byte count = data.stackCount;
        TravellingItem item = new TravellingItem(link, count);
        item.toCenter = data.toCenter;
        item.side = data.side;
        item.colour = data.colour;
        item.timeToDest = data.timeToDest;
        item.tickStarted = this.pipe.getHolder().getPipeWorld().func_82737_E() + 1L;
        item.tickFinished = item.tickStarted + (long)item.timeToDest;
        this.items.add(item.timeToDest + 1, item);
    }

    void sendItemDataToClient(TravellingItem item) {
        int stackId = BuildCraftObjectCaches.storeItemStack(item.stack);
        PipeItemMessageQueue.appendTravellingItem(this.pipe.getHolder().getPipeWorld(), this.pipe.getHolder().getPipePos(), stackId, (byte)item.stack.func_190916_E(), item.toCenter, item.side, item.colour, item.timeToDest > 127 ? (byte)127 : (byte)item.timeToDest);
    }

    @Override
    public void addDrops(NonNullList<ItemStack> toDrop, int fortune) {
        super.addDrops(toDrop, fortune);
        for (List<TravellingItem> list : this.items.getAllElements()) {
            for (TravellingItem item : list) {
                if (item.isPhantom) continue;
                toDrop.add((Object)item.stack);
            }
        }
    }

    @Override
    public int tryExtractItems(int count, EnumFacing from, EnumDyeColor colour, IStackFilter filter, boolean simulate) {
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            throw new IllegalStateException("Cannot extract items on the client side!");
        }
        if (from == null) {
            return 0;
        }
        TileEntity tile = this.pipe.getConnectedTile(from);
        IItemTransactor trans = ItemTransactorHelper.getTransactor((ICapabilityProvider)tile, from.func_176734_d());
        ItemStack possible = trans.extract(filter, 1, count, true);
        if (possible.func_190926_b()) {
            return 0;
        }
        if (possible.func_190916_E() > possible.func_77976_d()) {
            possible.func_190920_e(possible.func_77976_d());
            count = possible.func_77976_d();
        }
        IPipeHolder holder = this.pipe.getHolder();
        PipeEventItem.TryInsert tryInsert = new PipeEventItem.TryInsert(holder, this, colour, from, possible);
        holder.fireEvent(tryInsert);
        if (tryInsert.isCanceled() || tryInsert.accepted <= 0) {
            return 0;
        }
        ItemStack stack = trans.extract(filter, count = Math.min(count, tryInsert.accepted), count, simulate);
        if (stack.func_190926_b()) {
            throw new IllegalStateException("The transactor " + trans + " returned an empty itemstack from a known good request!");
        }
        if (!simulate) {
            this.insertItemEvents(stack, colour, 0.08, from);
        }
        return count;
    }

    @Override
    public void sendPhantomItem(ItemStack stack, EnumFacing from, EnumFacing to, EnumDyeColor colour) {
        if (from == null && to == null) {
            return;
        }
        boolean twoItems = from != null && to != null;
        EnumFacing face0 = from;
        EnumFacing face1 = from == null ? to : null;
        EnumFacing face2 = to;
        long now = this.pipe.getHolder().getPipeWorld().func_82737_E();
        TravellingItem firstItem = new TravellingItem(stack);
        firstItem.isPhantom = true;
        firstItem.toCenter = face1 == null;
        firstItem.colour = colour;
        firstItem.side = face0 == null ? face1 : face0;
        firstItem.speed = 0.08;
        firstItem.genTimings(now, this.getPipeLength(firstItem.side));
        this.items.add(firstItem.timeToDest, firstItem);
        this.sendItemDataToClient(firstItem);
        if (twoItems) {
            TravellingItem secondItem = new TravellingItem(stack);
            secondItem.isPhantom = true;
            secondItem.toCenter = false;
            secondItem.colour = colour;
            secondItem.side = face2;
            secondItem.speed = 0.08;
            secondItem.genTimings(firstItem.tickFinished, this.getPipeLength(secondItem.side));
            this.items.add(secondItem.timeToDest, secondItem);
            this.sendItemDataToClient(secondItem);
        }
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == PipeApi.CAP_INJECTABLE) {
            return (T)PipeApi.CAP_INJECTABLE.cast((Object)this);
        }
        if (capability == CapUtil.CAP_ITEM_TRANSACTOR) {
            return (T)CapUtil.CAP_ITEM_TRANSACTOR.cast((Object)ItemTransactorHelper.wrapInjectable(this, facing));
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean canConnect(EnumFacing face, PipeFlow other) {
        return other instanceof PipeFlowItems;
    }

    @Override
    public boolean canConnect(EnumFacing face, TileEntity oTile) {
        return ItemTransactorHelper.getTransactor((ICapabilityProvider)oTile, face.func_176734_d()) != NoSpaceTransactor.INSTANCE;
    }

    @Override
    public void onTick() {
        World world = this.pipe.getHolder().getPipeWorld();
        List<TravellingItem> toTick = this.items.advance();
        long currentTime = world.func_82737_E();
        for (TravellingItem item : toTick) {
            if (item.tickFinished > currentTime) {
                this.items.add((int)(item.tickFinished - currentTime), item);
                continue;
            }
            if (item.isPhantom || world.field_72995_K) continue;
            if (item.toCenter) {
                this.onItemReachCenter(item);
                continue;
            }
            this.onItemReachEnd(item);
        }
    }

    private void onItemReachCenter(TravellingItem item) {
        IPipeHolder holder = this.pipe.getHolder();
        PipeEventItem.ReachCenter reachCenter = new PipeEventItem.ReachCenter(holder, this, item.colour, item.stack, item.side);
        holder.fireEvent(reachCenter);
        if (reachCenter.getStack().func_190926_b()) {
            return;
        }
        PipeEventItem.SideCheck sideCheck = new PipeEventItem.SideCheck(holder, this, reachCenter.colour, reachCenter.from, reachCenter.getStack());
        sideCheck.disallow(reachCenter.from);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!item.tried.contains(face) && this.pipe.isConnected(face)) continue;
            sideCheck.disallow(face);
        }
        holder.fireEvent(sideCheck);
        ImmutableList order = sideCheck.getOrder();
        if (order.isEmpty()) {
            PipeEventItem.TryBounce tryBounce = new PipeEventItem.TryBounce(holder, this, reachCenter.colour, reachCenter.from, reachCenter.getStack());
            holder.fireEvent(tryBounce);
            if (tryBounce.canBounce) {
                order = ImmutableList.of(EnumSet.of(reachCenter.from));
            } else {
                this.dropItem(item.stack, null, item.side.func_176734_d(), item.speed);
                return;
            }
        }
        PipeEventItem.ItemEntry entry = new PipeEventItem.ItemEntry(reachCenter.colour, reachCenter.getStack(), reachCenter.from);
        PipeEventItem.Split split = new PipeEventItem.Split(holder, this, (List<EnumSet<EnumFacing>>)order, entry);
        holder.fireEvent(split);
        ImmutableList entries = ImmutableList.copyOf(split.items);
        PipeEventItem.FindDest findDest = new PipeEventItem.FindDest(holder, this, (List<EnumSet<EnumFacing>>)order, (ImmutableList<PipeEventItem.ItemEntry>)entries);
        holder.fireEvent(findDest);
        World world = holder.getPipeWorld();
        long now = world.func_82737_E();
        for (PipeEventItem.ItemEntry itemEntry : findDest.items) {
            double newSpeed;
            if (itemEntry.stack.func_190926_b()) continue;
            PipeEventItem.ModifySpeed modifySpeed = new PipeEventItem.ModifySpeed(holder, this, itemEntry, item.speed);
            if (holder.fireEvent(modifySpeed)) {
                double target = modifySpeed.targetSpeed;
                double maxDelta = modifySpeed.maxSpeedChange;
                newSpeed = item.speed < target ? Math.min(target, item.speed + maxDelta) : (item.speed > target ? Math.max(target, item.speed - maxDelta) : item.speed);
            } else {
                newSpeed = item.speed > 0.03 ? Math.max(0.03, item.speed - 0.008) : item.speed;
            }
            List<EnumFacing> destinations = itemEntry.to;
            if (destinations == null || destinations.size() == 0) {
                destinations = findDest.generateRandomOrder();
            }
            if (destinations.size() == 0) {
                this.dropItem(itemEntry.stack, null, item.side.func_176734_d(), newSpeed);
                continue;
            }
            TravellingItem newItem = new TravellingItem(itemEntry.stack);
            newItem.tried.addAll(item.tried);
            newItem.toCenter = false;
            newItem.colour = itemEntry.colour;
            newItem.side = destinations.get(0);
            newItem.speed = newSpeed;
            newItem.genTimings(now, this.getPipeLength(newItem.side));
            this.items.add(newItem.timeToDest, newItem);
            this.sendItemDataToClient(newItem);
        }
    }

    private void onItemReachEnd(TravellingItem item) {
        IPipeHolder holder = this.pipe.getHolder();
        PipeEventItem.ReachEnd reachEnd = new PipeEventItem.ReachEnd(holder, this, item.colour, item.stack, item.side);
        holder.fireEvent(reachEnd);
        item.colour = reachEnd.colour;
        ItemStack excess = item.stack = reachEnd.getStack();
        if (excess.func_190926_b()) {
            return;
        }
        if (this.pipe.isConnected(item.side)) {
            IPipe.ConnectedType type = this.pipe.getConnectedType(item.side);
            EnumFacing oppositeSide = item.side.func_176734_d();
            switch (type) {
                case PIPE: {
                    PipeFlow flow;
                    IPipe oPipe = this.pipe.getConnectedPipe(item.side);
                    if (oPipe == null || !((flow = oPipe.getFlow()) instanceof IFlowItems)) break;
                    IFlowItems oFlow = (IFlowItems)((Object)flow);
                    ItemStack before = excess;
                    if (!(excess = oFlow.injectItem(excess.func_77946_l(), true, oppositeSide, item.colour, item.speed)).func_190926_b()) {
                        before.func_190918_g(excess.func_190916_E());
                    }
                    excess = this.fireEventEjectIntoPipe(oFlow, item.side, before, excess);
                    break;
                }
                case TILE: {
                    TileEntity tile = this.pipe.getConnectedTile(item.side);
                    IInjectable injectable = ItemTransactorHelper.getInjectable((ICapabilityProvider)tile, oppositeSide);
                    ItemStack before = excess;
                    excess = injectable.injectItem(excess.func_77946_l(), true, oppositeSide, item.colour, item.speed);
                    if (!excess.func_190926_b()) {
                        IItemTransactor transactor = ItemTransactorHelper.getTransactor((ICapabilityProvider)tile, oppositeSide);
                        excess = transactor.insert(excess, false, false);
                    }
                    excess = this.fireEventEjectIntoTile(tile, item.side, before, excess);
                    break;
                }
            }
        }
        if (excess.func_190926_b()) {
            return;
        }
        item.tried.add(item.side);
        item.toCenter = true;
        item.stack = excess;
        item.genTimings(holder.getPipeWorld().func_82737_E(), this.getPipeLength(item.side));
        this.items.add(item.timeToDest, item);
        this.sendItemDataToClient(item);
    }

    private ItemStack fireEventEjectIntoPipe(IFlowItems oFlow, EnumFacing to, ItemStack before, ItemStack excess) {
        IPipeHolder holder = this.pipe.getHolder();
        return PipeFlowItems.fireEventEjected(holder, new PipeEventItem.Ejected.IntoPipe(holder, this, before, excess, to, oFlow));
    }

    private ItemStack fireEventEjectIntoTile(TileEntity tile, EnumFacing to, ItemStack before, ItemStack excess) {
        IPipeHolder holder = this.pipe.getHolder();
        return PipeFlowItems.fireEventEjected(holder, new PipeEventItem.Ejected.IntoTile(holder, this, before, excess, to, tile));
    }

    private static ItemStack fireEventEjected(IPipeHolder holder, PipeEventItem.Ejected event) {
        holder.fireEvent(event);
        return event.getExcess();
    }

    private void dropItem(ItemStack stack, EnumFacing side, EnumFacing motion, double speed) {
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        IPipeHolder holder = this.pipe.getHolder();
        World world = holder.getPipeWorld();
        BlockPos pos = holder.getPipePos();
        double x = (double)pos.func_177958_n() + 0.5 + (double)motion.func_82601_c() * 0.5;
        double y = (double)pos.func_177956_o() + 0.5 + (double)motion.func_96559_d() * 0.5;
        double z = (double)pos.func_177952_p() + 0.5 + (double)motion.func_82599_e() * 0.5;
        speed += 0.01;
        EntityItem ent = new EntityItem(world, x, y, z, stack);
        ent.field_70159_w = (double)motion.func_82601_c() * (speed *= 2.0);
        ent.field_70181_x = (double)motion.func_96559_d() * speed;
        ent.field_70179_y = (double)motion.func_82599_e() * speed;
        PipeEventItem.Drop drop = new PipeEventItem.Drop(holder, this, ent);
        holder.fireEvent(drop);
        if (ent.func_92059_d().func_190926_b() || ent.field_70128_L) {
            return;
        }
        world.func_72838_d((Entity)ent);
    }

    @Override
    public boolean canInjectItems(EnumFacing from) {
        return this.pipe.isConnected(from);
    }

    @Override
    @Nonnull
    public ItemStack injectItem(@Nonnull ItemStack stack, boolean doAdd, EnumFacing from, EnumDyeColor colour, double speed) {
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            throw new IllegalStateException("Cannot inject items on the client side!");
        }
        if (!this.canInjectItems(from)) {
            return stack;
        }
        if (speed < 0.01) {
            speed = 0.01;
        }
        PipeEventItem.TryInsert tryInsert = new PipeEventItem.TryInsert(this.pipe.getHolder(), this, colour, from, stack);
        this.pipe.getHolder().fireEvent(tryInsert);
        if (tryInsert.isCanceled() || tryInsert.accepted <= 0) {
            return stack;
        }
        ItemStack toSplit = stack.func_77946_l();
        ItemStack toInsert = toSplit.func_77979_a(tryInsert.accepted);
        if (doAdd) {
            this.insertItemEvents(toInsert, colour, speed, from);
        }
        if (toSplit.func_190926_b()) {
            toSplit = StackUtil.EMPTY;
        }
        return toSplit;
    }

    @Override
    public void insertItemsForce(@Nonnull ItemStack stack, EnumFacing from, EnumDyeColor colour, double speed) {
        World world = this.pipe.getHolder().getPipeWorld();
        if (world.field_72995_K) {
            throw new IllegalStateException("Cannot inject items on the client side!");
        }
        if (stack.func_190926_b()) {
            return;
        }
        if (speed < 0.01) {
            speed = 0.01;
        }
        long now = world.func_82737_E();
        TravellingItem item = new TravellingItem(stack);
        item.side = from;
        item.toCenter = true;
        item.speed = speed;
        item.colour = colour;
        item.genTimings(now, 0.0);
        item.tried.add(from);
        this.addItemTryMerge(item);
    }

    private void insertItemEvents(@Nonnull ItemStack toInsert, EnumDyeColor colour, double speed, EnumFacing from) {
        IPipeHolder holder = this.pipe.getHolder();
        PipeEventItem.OnInsert onInsert = new PipeEventItem.OnInsert(holder, this, colour, toInsert, from);
        holder.fireEvent(onInsert);
        if (onInsert.getStack().func_190926_b()) {
            return;
        }
        World world = this.pipe.getHolder().getPipeWorld();
        long now = world.func_82737_E();
        TravellingItem item = new TravellingItem(toInsert);
        item.side = from;
        item.toCenter = true;
        item.speed = speed;
        item.colour = onInsert.colour;
        item.stack = onInsert.getStack();
        item.genTimings(now, this.getPipeLength(from));
        item.tried.add(from);
        this.addItemTryMerge(item);
    }

    private void addItemTryMerge(TravellingItem item) {
        for (List<TravellingItem> list : this.items.getAllElements()) {
            for (TravellingItem item2 : list) {
                if (!item2.mergeWith(item)) continue;
                return;
            }
        }
        this.items.add(item.timeToDest, item);
        this.sendItemDataToClient(item);
    }

    @PipeEventHandler
    public static void addTriggers(PipeEventStatement.AddTriggerInternal event) {
        event.triggers.add(BCTransportStatements.TRIGGER_ITEMS_TRAVERSING);
    }

    public boolean doesContainItems() {
        return this.items.getMaxDelay() > 0;
    }

    @Nullable
    private static EnumSet<EnumFacing> getFirstNonEmptySet(List<EnumSet<EnumFacing>> possible) {
        for (EnumSet<EnumFacing> set : possible) {
            if (set.size() <= 0) continue;
            return set;
        }
        return null;
    }

    double getPipeLength(EnumFacing side) {
        if (side == null) {
            return 0.0;
        }
        if (this.pipe.isConnected(side)) {
            if (this.pipe.getConnectedType(side) == IPipe.ConnectedType.TILE) {
                return 0.75;
            }
            return 0.5;
        }
        return 0.25;
    }

    @SideOnly(value=Side.CLIENT)
    public List<TravellingItem> getAllItemsForRender() {
        ArrayList<TravellingItem> all = new ArrayList<TravellingItem>();
        for (List<TravellingItem> innerList : this.items.getAllElements()) {
            all.addAll(innerList);
        }
        return all;
    }
}

