/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class HashUtil {
    public static final int DIGEST_LENGTH = 32;
    private static final MessageDigest SHA_256;
    private static final MethodHandle HANDLE_NBT_WRITE;

    public static byte[] computeHash(byte[] data) {
        return SHA_256.digest(data);
    }

    public static byte[] computeHash(NBTTagCompound nbt) {
        try (DigestOutputStream dos = HashUtil.createDigestStream();){
            HashUtil.writeStableCompound(nbt, new DataOutputStream(dos));
        }
        catch (IOException io) {
            throw new RuntimeException("Failed to write to a perfectly good DigestOutputStream!", io);
        }
        return SHA_256.digest();
    }

    public static DigestOutputStream createDigestStream() {
        return new DigestOutputStream(ByteStreams.nullOutputStream(), SHA_256);
    }

    public static String convertHashToString(byte[] hash) {
        StringBuilder str = new StringBuilder();
        for (byte b : hash) {
            String s = Integer.toString(Byte.toUnsignedInt(b), 16);
            if (s.length() < 2) {
                str.append('0');
            }
            str.append(s);
        }
        return str.toString();
    }

    public static byte[] convertStringToHash(String str) {
        byte[] hash = new byte[str.length() / 2];
        for (int i = 0; i < hash.length; ++i) {
            String s2 = str.substring(i * 2, i * 2 + 2);
            hash[i] = (byte)Integer.parseInt(s2, 16);
        }
        return hash;
    }

    private static void writeStableCompound(NBTTagCompound nbt, DataOutput out) throws IOException {
        TreeMap<String, NBTBase> entries = new TreeMap<String, NBTBase>();
        for (String key : nbt.func_150296_c()) {
            entries.put(key, nbt.func_74781_a(key));
        }
        for (String key : entries.keySet()) {
            NBTBase tag = (NBTBase)entries.get(key);
            byte id = tag.func_74732_a();
            out.writeByte(id);
            if (id != 0) {
                out.writeUTF(key);
                HashUtil.writeStableNbt(tag, out);
            }
            out.writeByte(0);
        }
    }

    private static void writeStableList(NBTTagList nbt, DataOutput out) throws IOException {
        byte type = nbt.func_82582_d() ? (byte)0 : nbt.func_179238_g(0).func_74732_a();
        out.writeByte(type);
        out.writeInt(nbt.func_74745_c());
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            HashUtil.writeStableNbt(nbt.func_179238_g(i), out);
        }
    }

    private static void writeStableNbt(NBTBase nbt, DataOutput out) throws IOException {
        if (nbt instanceof NBTTagCompound) {
            HashUtil.writeStableCompound((NBTTagCompound)nbt, out);
        } else if (nbt instanceof NBTTagList) {
            HashUtil.writeStableList((NBTTagList)nbt, out);
        } else {
            try {
                HANDLE_NBT_WRITE.invokeExact(nbt, out);
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
        }
    }

    static {
        try {
            SHA_256 = MessageDigest.getInstance("sha-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        int realLength = SHA_256.getDigestLength();
        if (realLength != 32) {
            throw new IllegalStateException("Digest length of sha-256 is meant to be 32, but returned " + realLength);
        }
        Method[] methods = NBTBase.class.getDeclaredMethods();
        Object[] expectedParams = new Class[]{DataOutput.class};
        Method read = null;
        for (Method m : methods) {
            Object[] params = m.getParameterTypes();
            if (!Arrays.equals(expectedParams, params)) continue;
            if (read != null) {
                throw new IllegalStateException("Found multiple acceptable methods! (" + read + " and " + m + ")");
            }
            read = m;
            read.setAccessible(true);
        }
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            HANDLE_NBT_WRITE = lookup.unreflect(read);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("test", 42);
        HashUtil.computeHash(nbt);
    }
}

