/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.inventory;

import buildcraft.api.core.IStackFilter;
import buildcraft.lib.inventory.AbstractInvItemTransactor;
import buildcraft.lib.misc.StackUtil;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public final class InventoryWrapper
extends AbstractInvItemTransactor {
    private final IInventory inventory;

    public InventoryWrapper(IInventory inventory) {
        this.inventory = inventory;
    }

    @Override
    @Nonnull
    protected ItemStack insert(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack current = this.inventory.func_70301_a(slot);
        if (!this.inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        if (current.func_190926_b()) {
            int max = Math.min(this.inventory.func_70297_j_(), stack.func_77976_d());
            ItemStack split = stack.func_77979_a(max);
            if (!simulate) {
                this.inventory.func_70299_a(slot, split);
            }
            if (stack.func_190926_b()) {
                return StackUtil.EMPTY;
            }
            return stack;
        }
        if (StackUtil.canMerge(current, stack)) {
            ItemStack merged = current.func_77946_l();
            merged.func_190920_e(merged.func_190916_E() + stack.func_190916_E());
            int size = Math.min(this.inventory.func_70297_j_(), merged.func_77976_d());
            if (merged.func_190916_E() > size) {
                stack.func_190920_e(stack.func_190916_E() - (merged.func_190916_E() - size));
                merged.func_190920_e(size);
                if (!simulate) {
                    this.inventory.func_70299_a(slot, merged);
                }
                return stack;
            }
            if (!simulate) {
                this.inventory.func_70299_a(slot, merged);
            }
            return StackUtil.EMPTY;
        }
        return stack;
    }

    @Override
    @Nonnull
    protected ItemStack extract(int slot, IStackFilter filter, int min, int max, boolean simulate) {
        ItemStack current = this.inventory.func_70301_a(slot);
        if (current.func_190926_b()) {
            return StackUtil.EMPTY;
        }
        if (filter.matches(current.func_77946_l())) {
            if (current.func_190916_E() < min) {
                return StackUtil.EMPTY;
            }
            int size = Math.min(current.func_190916_E(), max);
            current = current.func_77946_l();
            ItemStack other = current.func_77979_a(size);
            if (!simulate) {
                if (current.func_190916_E() <= 0) {
                    current = StackUtil.EMPTY;
                }
                this.inventory.func_70299_a(slot, current);
            }
            return other;
        }
        return StackUtil.EMPTY;
    }

    @Override
    protected int getSlots() {
        return this.inventory.func_70302_i_();
    }

    @Override
    protected boolean isEmpty(int slot) {
        return this.inventory.func_70301_a(slot).func_190926_b();
    }
}

