/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.proxy;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.creeperhost.minetogether.CreeperHost;
import net.creeperhost.minetogether.chat.ChatHandler;
import net.creeperhost.minetogether.common.Config;
import net.creeperhost.minetogether.gui.chat.ingame.GuiNewChatOurs;
import net.creeperhost.minetogether.gui.serverlist.gui.GuiFriendsList;
import net.creeperhost.minetogether.gui.serverlist.gui.GuiInvited;
import net.creeperhost.minetogether.proxy.IProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.Session;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.io.IOUtils;

public class Client
implements IProxy {
    public KeyBinding openGuiKey;
    private UUID cache;
    boolean isChatReplaced = false;

    @Override
    public void registerKeys() {
        this.openGuiKey = new KeyBinding("minetogether.key.friends", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.CONTROL, 50, "minetogether.keys");
        ClientRegistry.registerKeyBinding((KeyBinding)this.openGuiKey);
    }

    @Override
    public void openFriendsGui() {
        Minecraft mc = Minecraft.func_71410_x();
        if (CreeperHost.instance.handledInvite == null) {
            mc.func_147108_a((GuiScreen)new GuiFriendsList(mc.field_71462_r));
        } else {
            mc.func_147108_a((GuiScreen)new GuiInvited(CreeperHost.instance.handledInvite, mc.field_71462_r));
            CreeperHost.instance.handledInvite = null;
        }
    }

    @Override
    public UUID getUUID() {
        UUID uuid;
        if (this.cache != null) {
            return this.cache;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Session session = mc.func_110432_I();
        boolean online = true;
        if (session.func_148254_d().length() != 32 || session.func_148255_b().length() != 32) {
            online = false;
        }
        if (online) {
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(mc.func_110437_J(), UUID.randomUUID().toString());
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(mc.field_71412_D, MinecraftServer.field_152367_a.getName()));
            uuid = playerprofilecache.func_152655_a(Minecraft.func_71410_x().func_110432_I().func_111285_a()).getId();
        } else {
            uuid = EntityPlayer.func_175147_b((String)session.func_111285_a().toLowerCase());
        }
        this.cache = uuid;
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startChat() {
        if (Config.getInstance().isChatEnabled()) {
            if (!CreeperHost.instance.ingameChat.hasDisabledIngameChat()) {
                this.enableIngameChat();
            }
            CreeperHost.instance.getNameForUser("");
            CreeperHost.instance.mutedUsersFile = new File("local/minetogether/mutedusers.json");
            InputStream mutedUsersStream = null;
            try {
                String configString;
                if (CreeperHost.instance.mutedUsersFile.exists()) {
                    mutedUsersStream = new FileInputStream(CreeperHost.instance.mutedUsersFile);
                    configString = IOUtils.toString((InputStream)mutedUsersStream);
                } else {
                    CreeperHost.instance.mutedUsersFile.getParentFile().mkdirs();
                    configString = "[]";
                }
                Gson gson = new Gson();
                CreeperHost.instance.mutedUsers = (ArrayList)gson.fromJson(configString, new TypeToken<List<String>>(){}.getType());
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    if (mutedUsersStream != null) {
                        mutedUsersStream.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            new Thread(() -> ChatHandler.init(CreeperHost.instance.ourNick, CreeperHost.instance)).start();
        }
    }

    @Override
    public void disableIngameChat() {
        CreeperHost.instance.ingameChat.setDisabledIngameChat(true);
        if (this.isChatReplaced) {
            ((GuiNewChatOurs)Minecraft.func_71410_x().field_71456_v.func_146158_b()).base = true;
        }
    }

    @Override
    public void enableIngameChat() {
        CreeperHost.instance.ingameChat.setDisabledIngameChat(false);
        if (!this.isChatReplaced) {
            this.isChatReplaced = true;
            try {
                Field field = ReflectionHelper.findField(GuiIngame.class, (String[])new String[]{"field_73840_e", "persistantChatGUI"});
                field.set(Minecraft.func_71410_x().field_71456_v, (Object)new GuiNewChatOurs(Minecraft.func_71410_x()));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

