/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ISupportParameter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.UserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.CaseMapping;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;

public interface ServerInfo {
    @Nonnull
    public Optional<String> getAddress();

    @Nonnull
    default public CaseMapping getCaseMapping() {
        Optional<ISupportParameter.CaseMapping> optional = this.getISupportParameter("CASEMAPPING", ISupportParameter.CaseMapping.class);
        return optional.map(ISupportParameter.CaseMapping::getCaseMapping).orElse(CaseMapping.RFC1459);
    }

    default public int getChannelLengthLimit() {
        Optional<ISupportParameter.ChannelLen> optional = this.getISupportParameter("CHANNELLEN", ISupportParameter.ChannelLen.class);
        return optional.map(ISupportParameter.IntegerParameter::getInteger).orElse(-1);
    }

    @Nonnull
    default public Map<Character, Integer> getChannelLimits() {
        Optional<ISupportParameter.ChanLimit> optional = this.getISupportParameter("CHANLIMIT", ISupportParameter.ChanLimit.class);
        return optional.map(ISupportParameter.ChanLimit::getLimits).orElseGet(Collections::emptyMap);
    }

    @Nonnull
    default public Optional<ChannelMode> getChannelMode(char character) {
        return this.getChannelModes().stream().filter(channelMode -> channelMode.getChar() == character).findFirst();
    }

    @Nonnull
    public List<ChannelMode> getChannelModes();

    @Nonnull
    public List<Character> getChannelPrefixes();

    @Nonnull
    default public Optional<ChannelUserMode> getChannelUserMode(char character) {
        return this.getChannelUserModes().stream().filter(channelUserMode -> channelUserMode.getChar() == character).findFirst();
    }

    @Nonnull
    public List<ChannelUserMode> getChannelUserModes();

    @Nonnull
    public Optional<ISupportParameter> getISupportParameter(@Nonnull String var1);

    @Nonnull
    default public <ISupport extends ISupportParameter> Optional<ISupport> getISupportParameter(@Nonnull String name, @Nonnull Class<ISupport> clazz) {
        Optional<ISupportParameter> optional = this.getISupportParameter(name);
        if (optional.isPresent() && Sanity.nullCheck(clazz, "Class cannot be null").isInstance(optional.get())) {
            return optional;
        }
        return Optional.empty();
    }

    @Nonnull
    public Map<String, ISupportParameter> getISupportParameters();

    @Nonnull
    public Optional<List<String>> getMotd();

    @Nonnull
    default public Optional<String> getNetworkName() {
        Optional<ISupportParameter.Network> optional = this.getISupportParameter("NETWORK", ISupportParameter.Network.class);
        return optional.map(ISupportParameter.Network::getNetworkName);
    }

    default public int getNickLengthLimit() {
        Optional<ISupportParameter.NickLen> optional = this.getISupportParameter("NICKLEN", ISupportParameter.NickLen.class);
        return optional.map(ISupportParameter.IntegerParameter::getInteger).orElse(-1);
    }

    @Nonnull
    public List<UserMode> getUserModes();

    @Nonnull
    public Optional<String> getVersion();

    default public boolean hasWhoXSupport() {
        return this.getISupportParameter("WHOX").isPresent();
    }

    public boolean isValidChannel(@Nonnull String var1);

    public static interface WithManagement
    extends ServerInfo {
        public void addISupportParameter(@Nonnull ISupportParameter var1);

        @Nonnull
        public Optional<ChannelUserMode> getTargetedChannelInfo(@Nonnull String var1);

        public void setAddress(@Nonnull String var1);

        public void setMotd(@Nonnull List<String> var1);

        public void setUserModes(@Nonnull List<UserMode> var1);

        public void setVersion(@Nonnull String var1);
    }
}

