/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.entity;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.UUID;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.eventhandler.Event;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.entity.blockentity.BlockEntityWorld;
import thut.api.maths.Vector3;
import thut.api.network.PacketHandler;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;
import thut.tech.common.entity.EventLiftConsumePower;
import thut.tech.common.entity.LiftInteractHandler;
import thut.tech.common.handlers.ConfigHandler;

public class EntityLift
extends BlockEntityBase {
    static final DataParameter<Integer> DESTINATIONFLOORDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Float> DESTINATIONYDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Float> DESTINATIONXDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Float> DESTINATIONZDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187193_c);
    static final DataParameter<Integer> CURRENTFLOORDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Boolean> CALLEDDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187198_h);
    public static boolean ENERGYUSE = false;
    public static int ENERGYCOST = 100;
    public IEnergyStorage energy = null;
    public UUID owner;
    public double prevFloorY = 0.0;
    public double prevFloor = 0.0;
    TileEntityLiftAccess current;
    public int[] floors = new int[128];
    public boolean[] hasFloors = new boolean[128];
    private Vector3f velocity = new Vector3f();

    public EntityLift(World par1World) {
        super(par1World);
        this.field_70158_ak = true;
        this.field_70172_ad = 0;
        this.field_70178_ae = true;
        this.speedUp = ConfigHandler.LiftSpeedUp;
        this.speedDown = -ConfigHandler.LiftSpeedDown;
    }

    public EntityLift(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    protected boolean checkAccelerationConditions() {
        return this.consumePower();
    }

    protected BlockEntityInteractHandler createInteractHandler() {
        return new LiftInteractHandler(this);
    }

    public void accelerate() {
        this.field_70177_z = 0.0f;
        if (this.func_70613_aW() && !this.consumePower()) {
            this.toMoveZ = false;
            this.toMoveX = false;
            this.toMoveY = false;
        } else {
            this.toMoveX = (double)this.getDestX() != this.field_70165_t;
            this.toMoveY = (double)this.getDestY() != this.field_70163_u;
            boolean bl = this.toMoveZ = (double)this.getDestZ() != this.field_70161_v;
        }
        if (!this.toMoveX) {
            this.velocity.x = (float)((double)this.velocity.x * 0.5);
        }
        if (!this.toMoveZ) {
            this.velocity.z = (float)((double)this.velocity.z * 0.5);
        }
        if (!this.toMoveY) {
            this.velocity.y = (float)((double)this.velocity.y * 0.5);
        }
        if (this.getCalled()) {
            if (this.toMoveY) {
                float destY = this.getDestY();
                if (Math.abs((double)destY - this.field_70163_u) < 0.01) {
                    this.func_70107_b(this.field_70165_t, destY, this.field_70161_v);
                    this.toMoveY = false;
                    this.velocity.y = 0.0f;
                } else {
                    double dy = this.getSpeed(this.field_70163_u, destY, this.velocity.y, this.speedUp, this.speedDown);
                    this.velocity.y = (float)dy;
                }
            }
            if (this.toMoveX) {
                float destX = this.getDestX();
                if (Math.abs((double)destX - this.field_70165_t) < 0.01) {
                    this.func_70107_b(destX, this.field_70163_u, this.field_70161_v);
                    this.toMoveX = false;
                    this.velocity.x = 0.0f;
                } else {
                    double dx = this.getSpeed(this.field_70165_t, destX, this.velocity.x, this.speedHoriz, this.speedHoriz);
                    this.velocity.x = (float)dx;
                }
            }
            if (this.toMoveZ) {
                float destZ = this.getDestZ();
                if (Math.abs((double)destZ - this.field_70161_v) < 0.01) {
                    this.func_70107_b(this.field_70165_t, this.field_70163_u, destZ);
                    this.toMoveZ = false;
                    this.velocity.z = 0.0f;
                } else {
                    double dz = this.getSpeed(this.field_70161_v, destZ, this.velocity.z, this.speedHoriz, this.speedHoriz);
                    this.velocity.z = (float)dz;
                }
            }
        }
        this.field_70159_w = this.velocity.x;
        this.field_70181_x = this.velocity.y;
        this.field_70179_y = this.velocity.z;
    }

    public void call(int floor) {
        if (floor == 0 || floor > this.floors.length) {
            return;
        }
        if (this.hasFloors[floor - 1]) {
            this.callYValue(this.floors[floor - 1]);
            this.setDestinationFloor(floor);
        }
    }

    public void callYValue(int yValue) {
        this.setDestY(yValue);
    }

    private boolean consumePower() {
        if (!ENERGYUSE || !this.getCalled()) {
            return true;
        }
        if (this.energy == null) {
            this.energy = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null);
        }
        if (this.energy == null) {
            return true;
        }
        boolean power = false;
        Vector3 bounds = Vector3.getNewVector().set((Object)this.boundMax.func_177973_b((Vec3i)this.boundMin));
        double volume = bounds.x * bounds.y * bounds.z;
        int energyCost = (int)(Math.abs((double)this.getDestY() - this.field_70163_u) * (double)ENERGYCOST * volume * 0.01);
        int canExtract = this.energy.extractEnergy(energyCost = Math.max(energyCost, 1), true);
        if (canExtract == energyCost) {
            power = true;
            this.energy.extractEnergy(energyCost, false);
        }
        MinecraftForge.EVENT_BUS.post((Event)new EventLiftConsumePower(this, energyCost));
        if (!power) {
            this.setDestinationFloor(-1);
            this.setDestY((float)this.field_70163_u);
            this.setCalled(false);
            this.toMoveY = false;
        }
        return power;
    }

    public void doMotion() {
        if (!this.toMoveX) {
            this.velocity.x = 0.0f;
            this.field_70159_w = 0.0f;
        }
        if (!this.toMoveY) {
            this.velocity.y = 0.0f;
            this.field_70181_x = 0.0f;
        }
        if (!this.toMoveZ) {
            this.velocity.z = 0.0f;
            this.field_70179_y = 0.0f;
        }
        if (this.getCalled()) {
            this.func_70091_d(MoverType.SELF, this.velocity.x, this.velocity.y, this.velocity.z);
        } else {
            BlockPos pos = this.func_180425_c();
            this.func_70107_b((double)pos.func_177958_n() + 0.5, Math.round(this.field_70163_u), (double)pos.func_177952_p() + 0.5);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DESTINATIONFLOORDW, (Object)0);
        this.field_70180_af.func_187214_a(DESTINATIONYDW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DESTINATIONXDW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DESTINATIONZDW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CURRENTFLOORDW, (Object)-1);
        this.field_70180_af.func_187214_a(CALLEDDW, (Object)Boolean.FALSE);
    }

    public boolean getCalled() {
        return (Boolean)this.field_70180_af.func_187225_a(CALLEDDW);
    }

    private void setCalled(boolean called) {
        this.field_70180_af.func_187227_b(CALLEDDW, (Object)called);
    }

    public int getCurrentFloor() {
        return (Integer)this.field_70180_af.func_187225_a(CURRENTFLOORDW);
    }

    public int getDestinationFloor() {
        return (Integer)this.field_70180_af.func_187225_a(DESTINATIONFLOORDW);
    }

    public float getDestX() {
        return ((Float)this.field_70180_af.func_187225_a(DESTINATIONXDW)).floatValue();
    }

    public float getDestY() {
        return ((Float)this.field_70180_af.func_187225_a(DESTINATIONYDW)).floatValue();
    }

    public float getDestZ() {
        return ((Float)this.field_70180_af.func_187225_a(DESTINATIONZDW)).floatValue();
    }

    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        return false;
    }

    protected void onGridAlign() {
        BlockPos pos = this.func_180425_c();
        this.setCalled(false);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, Math.round(this.field_70163_u), (double)pos.func_177952_p() + 0.5);
        PacketHandler.sendEntityUpdate((Entity)this);
    }

    public void setCurrentFloor(int currentFloor) {
        this.field_70180_af.func_187227_b(CURRENTFLOORDW, (Object)currentFloor);
    }

    public void setDestinationFloor(int destinationFloor) {
        this.field_70180_af.func_187227_b(DESTINATIONFLOORDW, (Object)destinationFloor);
    }

    public void setDestX(float dest) {
        this.field_70180_af.func_187227_b(DESTINATIONXDW, (Object)Float.valueOf(dest));
        this.field_70180_af.func_187227_b(DESTINATIONYDW, (Object)Float.valueOf((float)this.field_70163_u));
        this.field_70180_af.func_187227_b(DESTINATIONZDW, (Object)Float.valueOf((float)this.field_70161_v));
        this.setCalled(true);
    }

    public void setDestY(float dest) {
        this.field_70180_af.func_187227_b(DESTINATIONYDW, (Object)Float.valueOf(dest));
        this.field_70180_af.func_187227_b(DESTINATIONXDW, (Object)Float.valueOf((float)this.field_70165_t));
        this.field_70180_af.func_187227_b(DESTINATIONZDW, (Object)Float.valueOf((float)this.field_70161_v));
        this.setCalled(true);
    }

    public void setDestZ(float dest) {
        this.field_70180_af.func_187227_b(DESTINATIONZDW, (Object)Float.valueOf(dest));
        this.field_70180_af.func_187227_b(DESTINATIONYDW, (Object)Float.valueOf((float)this.field_70163_u));
        this.field_70180_af.func_187227_b(DESTINATIONXDW, (Object)Float.valueOf((float)this.field_70165_t));
        this.setCalled(true);
    }

    public void setFoor(TileEntityLiftAccess te, int floor) {
        if (te.floor == 0) {
            this.floors[floor - 1] = te.func_174877_v().func_177956_o() - 2;
            this.hasFloors[floor - 1] = true;
        } else if (te.floor != 0) {
            this.hasFloors[te.floor - 1] = false;
            this.floors[floor - 1] = te.func_174877_v().func_177956_o() - 2;
            this.hasFloors[floor - 1] = true;
        }
    }

    public void func_70037_a(NBTTagCompound arg0) {
        super.func_70037_a(arg0);
        if (arg0.func_186855_b("owner")) {
            this.owner = arg0.func_186857_a("owner");
        }
    }

    public void func_70014_b(NBTTagCompound arg0) {
        super.func_70014_b(arg0);
        if (this.owner != null) {
            arg0.func_186854_a("owner", this.owner);
        }
    }

    public void setTiles(TileEntity[][][] tiles) {
        super.setTiles(tiles);
        TileEntity[][][] tileEntityArray = tiles;
        int n = tileEntityArray.length;
        for (int i = 0; i < n; ++i) {
            TileEntity[][] tileArrArr;
            TileEntity[][] tileEntityArray2 = tileArrArr = tileEntityArray[i];
            int n2 = tileEntityArray2.length;
            for (int j = 0; j < n2; ++j) {
                TileEntity[] tileArr;
                for (TileEntity tile : tileArr = tileEntityArray2[j]) {
                    if (!(tile instanceof TileEntityLiftAccess)) continue;
                    ((TileEntityLiftAccess)tile).setLift(this);
                }
            }
        }
    }

    public static EntityLift getLiftFromUUID(final UUID liftID, World world) {
        EntityLift ret = null;
        if (world instanceof BlockEntityWorld) {
            world = ((BlockEntityWorld)world).getWorld();
        }
        if (world instanceof WorldServer) {
            WorldServer worlds = (WorldServer)world;
            return (EntityLift)worlds.func_175733_a(liftID);
        }
        List entities = world.func_175644_a(EntityLift.class, (Predicate)new Predicate<EntityLift>(){

            public boolean apply(EntityLift input) {
                return input.func_110124_au().equals(liftID);
            }
        });
        if (!entities.isEmpty()) {
            return (EntityLift)((Object)entities.get(0));
        }
        return ret;
    }

    protected void preColliderTick() {
    }
}

