/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client;

import engineers.workshop.client.GuiBase;
import engineers.workshop.client.container.ContainerTable;
import engineers.workshop.client.container.slot.SlotBase;
import engineers.workshop.client.page.Page;
import engineers.workshop.common.network.PacketHandler;
import engineers.workshop.common.network.PacketId;
import engineers.workshop.common.network.data.DataType;
import engineers.workshop.common.table.TileTable;
import engineers.workshop.common.util.helpers.ColorHelper;
import engineers.workshop.common.util.helpers.FormattingHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;

public class GuiTable
extends GuiBase {
    private static final int HEADER_SRC_X = 0;
    private static final int HEADER_SRC_Y = 0;
    private static final int HEADER_FULL_WIDTH = 42;
    private static final int HEADER_WIDTH = 38;
    private static final int HEADER_HEIGHT = 17;
    private static final int HEADER_X = 3;
    private static final int HEADER_Y = 173;
    private static final int HEADER_TEXT_Y = 7;
    private static final int SLOT_SRC_X = 42;
    private static final int SLOT_SRC_Y = 0;
    private static final int SLOT_SIZE = 18;
    private static final int SLOT_OFFSET = -1;
    private static final int SLOT_BIG_SIZE = 26;
    private static final int SLOT_BIG_OFFSET = -5;
    private static final int POWER_X = 225;
    private static final int POWER_Y = 173;
    private static final int POWER_WIDTH = 18;
    private static final int POWER_HEIGHT = 50;
    private static final int POWER_INNER_WIDTH = 16;
    private static final int POWER_INNER_HEIGHT = 48;
    private static final int POWER_INNER_SRC_X = 0;
    private static final int POWER_INNER_SRC_Y = 64;
    private static final int POWER_SRC_X = 32;
    private static final int POWER_SRC_Y = 62;
    private static final int POWER_INNER_OFFSET_X = 1;
    private static final int POWER_INNER_OFFSET_Y = 1;
    private TileTable table;
    private List<SlotBase> slots;
    private ContainerTable containerTable;
    private boolean closed = true;

    public GuiTable(TileTable table, EntityPlayer player) {
        super((Container)new ContainerTable(table, player));
        this.field_146999_f = 256;
        this.field_147000_g = 256;
        this.slots = new ArrayList<SlotBase>();
        for (Object obj : this.field_147002_h.field_75151_b) {
            SlotBase slot = (SlotBase)((Object)obj);
            this.slots.add(slot);
            slot.updateClient(slot.isVisible());
        }
        this.table = table;
        this.containerTable = (ContainerTable)this.field_147002_h;
    }

    protected void func_146976_a(float f, int mX, int mY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        mX -= this.field_147003_i;
        mY -= this.field_147009_r;
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(0, 0, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawSlots();
        if (this.table.getMenu() == null) {
            this.drawPageHeaders(mX, mY);
            this.drawPower(mX, mY);
            this.table.getSelectedPage().draw(this, mX, mY);
        } else {
            this.table.getMenu().draw(this, mX, mY);
        }
        GlStateManager.func_179121_F();
    }

    protected void func_73864_a(int mX, int mY, int button) throws IOException {
        super.func_73864_a(mX, mY, button);
        mX -= this.field_147003_i;
        mY -= this.field_147009_r;
        if (this.table.getMenu() == null) {
            this.clickPageHeader(mX, mY);
            this.table.getSelectedPage().onClick(this, mX, mY, button);
        } else {
            this.table.getMenu().onClick(this, mX, mY);
        }
    }

    protected void func_73869_a(char c, int k) throws IOException {
        if (this.table.getMenu() == null) {
            super.func_73869_a(c, k);
        } else if (k == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            this.table.getMenu().onKeyStroke(this, c, k);
        }
    }

    private void drawPageHeaders(int mX, int mY) {
        for (int i = 0; i < this.table.getPages().size(); ++i) {
            Page page = this.table.getPages().get(i);
            boolean selected = page.equals(this.table.getSelectedPage());
            int srcY = selected ? 17 : 0;
            int y = 173 + 17 * i;
            boolean hover = this.inBounds(3, y, 42, 17, mX, mY);
            if (hover) {
                this.drawMouseOver(page.getDesc());
            }
            int width = hover ? 42 : 38;
            int offset = 42 - width;
            this.prepare();
            this.drawRect(3, y, 0 + offset, srcY, width, 17);
            int invertedOffset = 4 - offset;
            this.drawCenteredString(page.getName(), 3 + invertedOffset, y + 7, 38, 0.7f, 0x2E2E2E);
        }
    }

    private void clickPageHeader(int mX, int mY) {
        for (int i = 0; i < this.table.getPages().size(); ++i) {
            Page page = this.table.getPages().get(i);
            int y = 173 + 17 * i;
            if (!this.inBounds(3, y, 42, 17, mX, mY)) continue;
            this.table.setSelectedPage(page);
            this.table.updateServer(DataType.PAGE);
            break;
        }
    }

    private void drawSlots() {
        this.prepare();
        for (SlotBase slot : this.slots) {
            boolean visible = slot.isVisible();
            slot.updateClient(visible);
            if (!visible) continue;
            boolean isBig = slot.isBig();
            int srcY = isBig ? 18 : 0;
            int size = isBig ? 26 : 18;
            int offset = isBig ? -5 : -1;
            this.drawRect(slot.getX() + offset, slot.getY() + offset, 42 + slot.getTextureIndex(this) * size, srcY, size, size);
        }
    }

    private void drawPower(int mX, int mY) {
        this.prepare();
        this.drawRect(226, 174, 16, 64, 16, 48);
        int height = 48 * this.containerTable.power / this.table.maxFuel;
        int offset = 48 - height;
        GlStateManager.func_179124_c((float)ColorHelper.getRed(this.containerTable.power, this.getTable().maxFuel), (float)ColorHelper.getGreen(this.containerTable.power, this.getTable().maxFuel), (float)ColorHelper.getBlue(this.containerTable.power, this.getTable().maxFuel));
        this.drawRect(226, 174 + offset, 0, 64 + offset, 16, height);
        this.drawRect(225, 174 + offset - 1, 32, 61, 18, 1);
        int srcX = 32;
        boolean hover = this.inBounds(225, 173, 18, 50, mX, mY);
        if (hover) {
            srcX += 18;
        }
        this.drawRect(225, 173, srcX, 62, 18, 50);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (hover) {
            String str = ColorHelper.getPowerColor(this.containerTable.power, this.getTable().maxFuel) + "Fuel: " + FormattingHelper.formatNumber(this.containerTable.power) + " / " + FormattingHelper.formatNumber(this.table.maxFuel);
            this.drawMouseOver(str);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (!this.closed) {
            PacketHandler.sendToServer(PacketHandler.getPacket(this.table, PacketId.CLOSE));
            this.closed = true;
        }
    }

    public void func_146280_a(Minecraft minecraft, int width, int height) {
        super.func_146280_a(minecraft, width, height);
        if (this.closed) {
            this.closed = false;
            PacketHandler.sendToServer(PacketHandler.getPacket(this.table, PacketId.RE_OPEN));
        }
    }

    public TileTable getTable() {
        return this.table;
    }
}

