/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock;

import erogenousbeef.bigreactors.api.EnergyConversion;
import erogenousbeef.bigreactors.api.data.RadiationData;
import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.api.registry.ReactorInterior;
import erogenousbeef.bigreactors.client.ClientReactorFuelRodsLayout;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.interfaces.IReactorFuelInfo;
import erogenousbeef.bigreactors.common.multiblock.IInputOutputPort;
import erogenousbeef.bigreactors.common.multiblock.IPowerGenerator;
import erogenousbeef.bigreactors.common.multiblock.PartTier;
import erogenousbeef.bigreactors.common.multiblock.PowerSystem;
import erogenousbeef.bigreactors.common.multiblock.helpers.CoolantContainer;
import erogenousbeef.bigreactors.common.multiblock.helpers.FuelContainer;
import erogenousbeef.bigreactors.common.multiblock.helpers.RadiationHelper;
import erogenousbeef.bigreactors.common.multiblock.helpers.ReactorFuelRodsLayout;
import erogenousbeef.bigreactors.common.multiblock.interfaces.IActivateable;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorAccessPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorController;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorCoolantPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorGlass;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPowerTap;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPowerTapRedstoneFlux;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPowerTapTesla;
import erogenousbeef.bigreactors.init.BrBlocks;
import erogenousbeef.bigreactors.net.CommonPacketHandler;
import erogenousbeef.bigreactors.net.message.multiblock.ReactorUpdateMessage;
import erogenousbeef.bigreactors.net.message.multiblock.ReactorUpdateWasteEjectionMessage;
import erogenousbeef.bigreactors.utils.StaticUtils;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.api.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.api.multiblock.rectangular.RectangularMultiblockControllerBase;
import it.zerono.mods.zerocore.api.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.api.multiblock.validation.ValidationError;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import it.zerono.mods.zerocore.util.CodeHelper;
import it.zerono.mods.zerocore.util.ItemHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MultiblockReactor
extends RectangularMultiblockControllerBase
implements IPowerGenerator,
IReactorFuelInfo,
IActivateable,
IDebuggable {
    public static final int FuelCapacityPerFuelRod = 4000;
    private static final float passiveCoolingPowerEfficiency = 0.5f;
    private static final float passiveCoolingTransferEfficiency = 0.2f;
    private static final float reactorHeatLossConductivity = 0.001f;
    protected boolean active = false;
    private float reactorHeat = 0.0f;
    private float fuelHeat = 0.0f;
    private WasteEjectionSetting wasteEjection;
    private PowerSystem _powerSystem = PowerSystem.RedstoneFlux;
    private PartTier _partsTier;
    private float energyStored = 0.0f;
    protected FuelContainer fuelContainer;
    protected RadiationHelper radiationHelper;
    protected CoolantContainer coolantContainer;
    protected float fuelToReactorHeatTransferCoefficient = 0.0f;
    protected float reactorToCoolantSystemHeatTransferCoefficient = 0.0f;
    protected float reactorHeatLossCoefficient = 0.0f;
    protected Iterator<TileEntityReactorFuelRod> currentFuelRod = null;
    int reactorVolume = 0;
    private float energyGeneratedLastTick = 0.0f;
    private float fuelConsumedLastTick = 0.0f;
    public static final WasteEjectionSetting[] s_EjectionSettings = WasteEjectionSetting.values();
    private Set<TileEntityReactorPowerTap> attachedPowerTaps;
    private Set<ITickableMultiblockPart> attachedTickables;
    private Set<TileEntityReactorControlRod> attachedControlRods;
    private Set<TileEntityReactorAccessPort> attachedAccessPorts;
    private Set<TileEntityReactorController> attachedControllers;
    private Set<TileEntityReactorFuelRod> attachedFuelRods;
    private Set<TileEntityReactorCoolantPort> attachedCoolantPorts;
    private Set<TileEntityReactorGlass> attachedGlass;
    private boolean _interiorInvisible = true;
    private ReactorFuelRodsLayout _fuelRodsLayout;
    private boolean _legacyMode = false;
    private Set<EntityPlayer> updatePlayers;
    private int ticksSinceLastUpdate = 0;
    private static final int ticksBetweenUpdates = 3;
    private IFluidHandler[] _coolantHandlers;

    public MultiblockReactor(World world) {
        super(world);
        this.wasteEjection = WasteEjectionSetting.kAutomatic;
        this._partsTier = PartTier.Legacy;
        this.attachedPowerTaps = new HashSet<TileEntityReactorPowerTap>();
        this.attachedTickables = new HashSet<ITickableMultiblockPart>();
        this.attachedControlRods = new HashSet<TileEntityReactorControlRod>();
        this.attachedAccessPorts = new HashSet<TileEntityReactorAccessPort>();
        this.attachedControllers = new HashSet<TileEntityReactorController>();
        this.attachedFuelRods = new HashSet<TileEntityReactorFuelRod>();
        this.attachedCoolantPorts = new HashSet<TileEntityReactorCoolantPort>();
        this.attachedGlass = new HashSet<TileEntityReactorGlass>();
        this._fuelRodsLayout = ReactorFuelRodsLayout.DEFAULT;
        this.updatePlayers = new HashSet<EntityPlayer>();
        this.fuelContainer = new FuelContainer();
        this.radiationHelper = new RadiationHelper();
        this.coolantContainer = new CoolantContainer();
        this._coolantHandlers = new IFluidHandler[2];
    }

    public void beginUpdatingPlayer(EntityPlayer playerToUpdate) {
        this.updatePlayers.add(playerToUpdate);
        this.sendIndividualUpdate(playerToUpdate);
    }

    public void stopUpdatingPlayer(EntityPlayer playerToRemove) {
        this.updatePlayers.remove(playerToRemove);
    }

    protected void onBlockAdded(IMultiblockPart part) {
        if (part instanceof TileEntityReactorAccessPort) {
            this.attachedAccessPorts.add((TileEntityReactorAccessPort)part);
        }
        if (part instanceof TileEntityReactorControlRod) {
            TileEntityReactorControlRod controlRod = (TileEntityReactorControlRod)part;
            this.attachedControlRods.add(controlRod);
        }
        if (part instanceof TileEntityReactorPowerTap) {
            this.attachedPowerTaps.add((TileEntityReactorPowerTap)part);
        }
        if (part instanceof TileEntityReactorController) {
            this.attachedControllers.add((TileEntityReactorController)part);
        }
        if (part instanceof ITickableMultiblockPart) {
            this.attachedTickables.add((ITickableMultiblockPart)part);
        }
        if (part instanceof TileEntityReactorFuelRod) {
            TileEntityReactorFuelRod fuelRod = (TileEntityReactorFuelRod)part;
            this.attachedFuelRods.add(fuelRod);
            this.currentFuelRod = this.attachedFuelRods.iterator();
            if (this.WORLD.field_72995_K) {
                WorldHelper.notifyBlockUpdate((World)this.WORLD, (BlockPos)fuelRod.func_174877_v(), null, null);
            }
        }
        if (part instanceof TileEntityReactorCoolantPort) {
            this.attachedCoolantPorts.add((TileEntityReactorCoolantPort)part);
        }
        if (part instanceof TileEntityReactorGlass) {
            this.attachedGlass.add((TileEntityReactorGlass)part);
        }
    }

    protected void onBlockRemoved(IMultiblockPart part) {
        if (part instanceof TileEntityReactorAccessPort) {
            this.attachedAccessPorts.remove((TileEntityReactorAccessPort)part);
        }
        if (part instanceof TileEntityReactorControlRod) {
            this.attachedControlRods.remove((TileEntityReactorControlRod)part);
        }
        if (part instanceof TileEntityReactorPowerTap) {
            this.attachedPowerTaps.remove((TileEntityReactorPowerTap)part);
        }
        if (part instanceof TileEntityReactorController) {
            this.attachedControllers.remove(part);
        }
        if (part instanceof ITickableMultiblockPart) {
            this.attachedTickables.remove((ITickableMultiblockPart)part);
        }
        if (part instanceof TileEntityReactorFuelRod) {
            this.attachedFuelRods.remove(part);
            this.currentFuelRod = this.attachedFuelRods.iterator();
        }
        if (part instanceof TileEntityReactorCoolantPort) {
            this.attachedCoolantPorts.remove((TileEntityReactorCoolantPort)part);
        }
        if (part instanceof TileEntityReactorGlass) {
            this.attachedGlass.remove((TileEntityReactorGlass)part);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (this.attachedControlRods.size() < 1) {
            validatorCallback.setLastError("multiblock.validation.reactor.too_few_rods", new Object[0]);
            return false;
        }
        if (this.attachedControllers.size() < 1) {
            validatorCallback.setLastError("multiblock.validation.reactor.too_few_controllers", new Object[0]);
            return false;
        }
        HashSet<TileEntity> validFuelRods = new HashSet<TileEntity>();
        EnumFacing rodsFacing = null;
        for (TileEntityReactorControlRod tileEntityReactorControlRod : this.attachedControlRods) {
            TileEntity te;
            EnumFacing facing = tileEntityReactorControlRod.getOutwardFacingFromWorldPosition();
            if (null == rodsFacing) {
                rodsFacing = facing;
            }
            if (null == facing || facing != rodsFacing) {
                validatorCallback.setLastError("multiblock.validation.reactor.invalid_control_side", new Object[0]);
                return false;
            }
            BlockPos position = tileEntityReactorControlRod.getWorldPosition();
            facing = facing.func_176734_d();
            while ((te = this.WORLD.func_175625_s(position = position.func_177972_a(facing))) instanceof TileEntityReactorFuelRod) {
                validFuelRods.add(te);
            }
            if (te instanceof TileEntityReactorPartBase) {
                IBlockState state = this.WORLD.func_180495_p(position);
                if (BrBlocks.reactorCasing == state.func_177230_c()) continue;
                validatorCallback.setLastError("multiblock.validation.reactor.invalid_base_for_fuel_assembly", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
                return false;
            }
            validatorCallback.setLastError("multiblock.validation.reactor.invalid_block_in_fuel_assembly", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
            return false;
        }
        if (validFuelRods.size() != this.attachedFuelRods.size()) {
            validatorCallback.setLastError("multiblock.validation.reactor.invalid_fuel_rods", new Object[0]);
            return false;
        }
        PartTier candidateTier = null;
        for (IMultiblockPart part : this.connectedParts) {
            if (!(part instanceof TileEntityReactorPartBase)) continue;
            PartTier tier = ((TileEntityReactorPartBase)part).getPartTier();
            if (null == candidateTier) {
                candidateTier = tier;
                continue;
            }
            if (candidateTier == tier) continue;
            validatorCallback.setLastError("multiblock.validation.reactor.mixed_tiers", new Object[0]);
            return false;
        }
        if (this.attachedPowerTaps.size() > 0) {
            void var5_8;
            boolean bl = false;
            int tesla = 0;
            for (TileEntityReactorPowerTap tap : this.attachedPowerTaps) {
                if (tap instanceof TileEntityReactorPowerTapRedstoneFlux) {
                    ++var5_8;
                    continue;
                }
                if (!(tap instanceof TileEntityReactorPowerTapTesla)) continue;
                ++tesla;
            }
            if (var5_8 != false && tesla != 0) {
                validatorCallback.setLastError("multiblock.validation.reactor.mixed_power_systems", new Object[0]);
                return false;
            }
        }
        return super.isMachineWhole(validatorCallback);
    }

    public void updateClient() {
    }

    public boolean updateServer() {
        this.WORLD.field_72984_F.func_76320_a("Extreme Reactors|Reactor update");
        if (Float.isNaN(this.getReactorHeat())) {
            this.setReactorHeat(0.0f);
        }
        float oldHeat = this.getReactorHeat();
        float oldEnergy = this.getEnergyStored();
        this.energyGeneratedLastTick = 0.0f;
        this.fuelConsumedLastTick = 0.0f;
        float newHeat = 0.0f;
        this.WORLD.field_72984_F.func_76320_a("RadiateRod");
        if (this.getActive()) {
            RadiationData radData;
            TileEntityReactorFuelRod source;
            TileEntityReactorControlRod sourceControlRod;
            if (!this.currentFuelRod.hasNext()) {
                this.currentFuelRod = this.attachedFuelRods.iterator();
            }
            if ((sourceControlRod = (source = this.currentFuelRod.next()).getControlRod()) != null && (radData = this.radiationHelper.radiate(this.WORLD, this.fuelContainer, source, this.getFuelHeat(), this.getReactorHeat(), this.attachedControlRods.size())) != null) {
                this.addFuelHeat(radData.getFuelHeatChange(this.attachedFuelRods.size()));
                this.addReactorHeat(radData.getEnvironmentHeatChange(this.getReactorVolume()));
                this.fuelConsumedLastTick += radData.fuelUsage;
            }
        }
        this.radiationHelper.tick(this.getActive());
        this.WORLD.field_72984_F.func_76318_c("Waste&Fuel");
        if (this.wasteEjection == WasteEjectionSetting.kAutomatic) {
            this.ejectWaste(false, null);
        }
        this.refuel();
        this.WORLD.field_72984_F.func_76318_c("Heat");
        float tempDiff = this.fuelHeat - this.reactorHeat;
        if (tempDiff > 0.01f) {
            float rfTransferred = tempDiff * this.fuelToReactorHeatTransferCoefficient;
            float fuelRf = EnergyConversion.getRFFromVolumeAndTemp(this.attachedFuelRods.size(), this.fuelHeat);
            this.setFuelHeat(EnergyConversion.getTempFromVolumeAndRF(this.attachedFuelRods.size(), fuelRf -= rfTransferred));
            float reactorRf = EnergyConversion.getRFFromVolumeAndTemp(this.getReactorVolume(), this.getReactorHeat());
            this.setReactorHeat(EnergyConversion.getTempFromVolumeAndRF(this.getReactorVolume(), reactorRf += rfTransferred));
        }
        if ((tempDiff = this.getReactorHeat() - this.getCoolantTemperature()) > 0.01f) {
            float rfTransferred = tempDiff * this.reactorToCoolantSystemHeatTransferCoefficient;
            float reactorRf = EnergyConversion.getRFFromVolumeAndTemp(this.getReactorVolume(), this.getReactorHeat());
            if (this.isPassivelyCooled()) {
                this.generateEnergy((rfTransferred *= 0.2f) * 0.5f);
            } else {
                rfTransferred -= this.coolantContainer.onAbsorbHeat(rfTransferred);
                this.energyGeneratedLastTick = this.coolantContainer.getFluidVaporizedLastTick();
            }
            this.setReactorHeat(EnergyConversion.getTempFromVolumeAndRF(this.getReactorVolume(), reactorRf -= rfTransferred));
        }
        if ((tempDiff = this.getReactorHeat() - this.getPassiveCoolantTemperature()) > 1.0E-6f) {
            float rfLost = Math.max(1.0f, tempDiff * this.reactorHeatLossCoefficient);
            float reactorNewRf = Math.max(0.0f, EnergyConversion.getRFFromVolumeAndTemp(this.getReactorVolume(), this.getReactorHeat()) - rfLost);
            this.setReactorHeat(EnergyConversion.getTempFromVolumeAndRF(this.getReactorVolume(), reactorNewRf));
        }
        if (this.reactorHeat < 0.0f) {
            this.setReactorHeat(0.0f);
        }
        if (this.fuelHeat < 0.0f) {
            this.setFuelHeat(0.0f);
        }
        this.WORLD.field_72984_F.func_76318_c("SendPower");
        long energyAvailable = this.getEnergyStored();
        long energyRemaining = StaticUtils.PowerGenerators.distributePower(energyAvailable, this.attachedPowerTaps);
        if (energyAvailable != energyRemaining) {
            this.reduceStoredEnergy(energyAvailable - energyRemaining);
        }
        this.WORLD.field_72984_F.func_76318_c("Updates");
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate >= 3) {
            this.ticksSinceLastUpdate = 0;
            this.WORLD.field_72984_F.func_76318_c("updateFuelAssembliesQuota");
            this.updateFuelRodsLayout();
            this.WORLD.field_72984_F.func_76318_c("sendTickUpdate");
            this.sendTickUpdate();
        }
        this.WORLD.field_72984_F.func_76318_c("Tickables");
        for (ITickableMultiblockPart tickable : this.attachedTickables) {
            tickable.onMultiblockServerTick();
        }
        this.WORLD.field_72984_F.func_76318_c("RefCoords");
        if (this.attachedGlass.size() > 0 && this.fuelContainer.shouldUpdate()) {
            this.markReferenceCoordForUpdate();
        }
        this.WORLD.field_72984_F.func_76319_b();
        this.WORLD.field_72984_F.func_76319_b();
        return oldHeat != this.getReactorHeat() || oldEnergy != (float)this.getEnergyStored();
    }

    public void setEnergyStored(float oldEnergy) {
        this.energyStored = oldEnergy;
        if ((double)this.energyStored < 0.0 || Float.isNaN(this.energyStored)) {
            this.energyStored = 0.0f;
        } else if (this.energyStored > (float)this._powerSystem.maxCapacity) {
            this.energyStored = this._powerSystem.maxCapacity;
        }
    }

    protected void generateEnergy(float newEnergy) {
        newEnergy = newEnergy * BigReactors.CONFIG.powerProductionMultiplier * BigReactors.CONFIG.reactorPowerProductionMultiplier;
        this.energyGeneratedLastTick += newEnergy;
        this.addStoredEnergy(newEnergy);
    }

    protected void addStoredEnergy(float newEnergy) {
        if (Float.isNaN(newEnergy)) {
            return;
        }
        this.energyStored += newEnergy;
        if (this.energyStored > (float)this._powerSystem.maxCapacity) {
            this.energyStored = this._powerSystem.maxCapacity;
        }
        if (-1.0E-5f < this.energyStored && this.energyStored < 1.0E-5f) {
            this.energyStored = 0.0f;
        }
    }

    protected void reduceStoredEnergy(float energy) {
        this.addStoredEnergy(-energy);
    }

    @Override
    public void setActive(boolean act) {
        if (act == this.active) {
            return;
        }
        this.active = act;
        for (IMultiblockPart iMultiblockPart : this.connectedParts) {
            if (this.active) {
                iMultiblockPart.onMachineActivated();
                continue;
            }
            iMultiblockPart.onMachineDeactivated();
        }
        if (this.WORLD.field_72995_K) {
            for (IMultiblockPart iMultiblockPart : this.attachedControllers) {
                WorldHelper.notifyBlockUpdate((World)this.WORLD, (BlockPos)iMultiblockPart.getWorldPosition(), null, null);
            }
        } else {
            this.markReferenceCoordForUpdate();
        }
    }

    protected void addReactorHeat(float newCasingHeat) {
        if (Float.isNaN(newCasingHeat)) {
            return;
        }
        this.reactorHeat += newCasingHeat;
        if (-1.0E-5f < this.reactorHeat && this.reactorHeat < 1.0E-5f) {
            this.reactorHeat = 0.0f;
        }
    }

    public float getReactorHeat() {
        return this.reactorHeat;
    }

    public void setReactorHeat(float newHeat) {
        this.reactorHeat = Float.isNaN(newHeat) ? 0.0f : newHeat;
    }

    protected void addFuelHeat(float additionalHeat) {
        if (Float.isNaN(additionalHeat)) {
            return;
        }
        this.fuelHeat += additionalHeat;
        if (-1.0E-5f < this.fuelHeat & this.fuelHeat < 1.0E-5f) {
            this.fuelHeat = 0.0f;
        }
    }

    public float getFuelHeat() {
        return this.fuelHeat;
    }

    public void setFuelHeat(float newFuelHeat) {
        this.fuelHeat = Float.isNaN(newFuelHeat) ? 0.0f : newFuelHeat;
    }

    @Override
    public int getFuelRodCount() {
        return this.attachedControlRods.size();
    }

    protected boolean isBlockGoodForInterior(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        BlockPos position = new BlockPos(x, y, z);
        if (world.func_175623_d(position)) {
            return true;
        }
        IBlockState blockState = this.WORLD.func_180495_p(position);
        ItemStack stack = ItemHelper.stackFrom((IBlockState)blockState, (int)1);
        if (ItemHelper.stackIsValid((ItemStack)stack) && null != ReactorInterior.getBlockData(stack)) {
            return true;
        }
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            return true;
        }
        if (block instanceof IFluidBlock) {
            String fluidName = ((IFluidBlock)block).getFluid().getName();
            if (ReactorInterior.getFluidData(fluidName) != null) {
                return true;
            }
            validatorCallback.setLastError("multiblock.validation.reactor.invalid_fluid_for_interior", new Object[]{x, y, z, fluidName});
            return false;
        }
        validatorCallback.setLastError("multiblock.validation.reactor.invalid_block_for_interior", new Object[]{x, y, z, block.func_149732_F()});
        return false;
    }

    protected boolean isBlockGoodForFrame(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        IBlockState blockState = this.WORLD.func_180495_p(new BlockPos(x, y, z));
        Block block = blockState.func_177230_c();
        validatorCallback.setLastError("multiblock.validation.reactor.invalid_block_for_exterior", new Object[]{x, y, z, block.func_149732_F()});
        return false;
    }

    protected boolean isBlockGoodForTop(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        IBlockState blockState = this.WORLD.func_180495_p(new BlockPos(x, y, z));
        Block block = blockState.func_177230_c();
        validatorCallback.setLastError("multiblock.validation.reactor.invalid_block_for_exterior", new Object[]{x, y, z, block.func_149732_F()});
        return false;
    }

    protected boolean isBlockGoodForBottom(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        IBlockState blockState = this.WORLD.func_180495_p(new BlockPos(x, y, z));
        Block block = blockState.func_177230_c();
        validatorCallback.setLastError("multiblock.validation.reactor.invalid_block_for_exterior", new Object[]{x, y, z, block.func_149732_F()});
        return false;
    }

    protected boolean isBlockGoodForSides(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        IBlockState blockState = this.WORLD.func_180495_p(new BlockPos(x, y, z));
        Block block = blockState.func_177230_c();
        validatorCallback.setLastError("multiblock.validation.reactor.invalid_block_for_exterior", new Object[]{x, y, z, block.func_149732_F()});
        return false;
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        if (data.func_74764_b("reactorActive")) {
            this.setActive(data.func_74767_n("reactorActive"));
        }
        if (data.func_74764_b("heat")) {
            this.setReactorHeat(Math.max(this.getReactorHeat(), data.func_74760_g("heat")));
        }
        if (data.func_74764_b("storedEnergy")) {
            this.setEnergyStored(Math.max((float)this.getEnergyStored(), data.func_74760_g("storedEnergy")));
        }
        if (data.func_74764_b("wasteEjection2")) {
            this.wasteEjection = s_EjectionSettings[data.func_74762_e("wasteEjection2")];
        }
        if (data.func_74764_b("fuelHeat")) {
            this.setFuelHeat(data.func_74760_g("fuelHeat"));
        }
        if (data.func_74764_b("fuelContainer")) {
            this.fuelContainer.readFromNBT(data.func_74775_l("fuelContainer"));
        }
        if (data.func_74764_b("radiation")) {
            this.radiationHelper.readFromNBT(data.func_74775_l("radiation"));
        }
        if (data.func_74764_b("coolantContainer")) {
            this.coolantContainer.readFromNBT(data.func_74775_l("coolantContainer"));
        }
        if (ModTileEntity.SyncReason.NetworkUpdate == syncReason) {
            this.onFuelStatusChanged();
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        data.func_74757_a("reactorActive", this.active);
        data.func_74776_a("heat", this.reactorHeat);
        data.func_74776_a("fuelHeat", this.fuelHeat);
        data.func_74776_a("storedEnergy", this.energyStored);
        data.func_74768_a("wasteEjection2", this.wasteEjection.ordinal());
        data.func_74782_a("fuelContainer", (NBTBase)this.fuelContainer.writeToNBT(new NBTTagCompound()));
        data.func_74782_a("radiation", (NBTBase)this.radiationHelper.writeToNBT(new NBTTagCompound()));
        data.func_74782_a("coolantContainer", (NBTBase)this.coolantContainer.writeToNBT(new NBTTagCompound()));
    }

    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 26;
    }

    public void serialize(ByteBuf buf) {
        Fluid coolantType = this.coolantContainer.getCoolantType();
        Fluid vaporType = this.coolantContainer.getVaporType();
        String coolantName = null != coolantType ? coolantType.getName() : "";
        String vaporName = null != vaporType ? vaporType.getName() : "";
        buf.writeBoolean(this.active);
        buf.writeFloat(this.reactorHeat);
        buf.writeFloat(this.fuelHeat);
        buf.writeFloat(this.energyStored);
        buf.writeFloat(this.radiationHelper.getFertility());
        buf.writeFloat(this.energyGeneratedLastTick);
        buf.writeFloat(this.fuelConsumedLastTick);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)coolantName);
        buf.writeInt(this.coolantContainer.getCoolantAmount());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)vaporName);
        buf.writeInt(this.coolantContainer.getVaporAmount());
        this.fuelContainer.serialize(buf);
    }

    public void deserialize(ByteBuf buf) {
        this.setActive(buf.readBoolean());
        this.setReactorHeat(buf.readFloat());
        this.setFuelHeat(buf.readFloat());
        this.setEnergyStored(buf.readFloat());
        this.radiationHelper.setFertility(buf.readFloat());
        this.setEnergyGeneratedLastTick(buf.readFloat());
        this.setFuelConsumedLastTick(buf.readFloat());
        String coolantName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int coolantAmt = buf.readInt();
        String vaporName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int vaporAmt = buf.readInt();
        this.fuelContainer.deserialize(buf);
        this.updateFuelRodsLayout();
        if (coolantName.isEmpty()) {
            this.coolantContainer.emptyCoolant();
        } else {
            this.coolantContainer.setCoolant(new FluidStack(FluidRegistry.getFluid((String)coolantName), coolantAmt));
        }
        if (vaporName.isEmpty()) {
            this.coolantContainer.emptyVapor();
        } else {
            this.coolantContainer.setVapor(new FluidStack(FluidRegistry.getFluid((String)vaporName), vaporAmt));
        }
    }

    protected IMessage getUpdatePacket() {
        return new ReactorUpdateMessage(this);
    }

    protected void sendIndividualUpdate(EntityPlayer player) {
        if (this.WORLD.field_72995_K) {
            return;
        }
        CommonPacketHandler.INSTANCE.sendTo(this.getUpdatePacket(), (EntityPlayerMP)player);
    }

    protected void sendTickUpdate() {
        if (this.WORLD.field_72995_K || this.updatePlayers.size() <= 0) {
            return;
        }
        for (EntityPlayer player : this.updatePlayers) {
            CommonPacketHandler.INSTANCE.sendTo(this.getUpdatePacket(), (EntityPlayerMP)player);
        }
    }

    private int tryDistributeItems(TileEntityReactorAccessPort port, ItemStack itemsToDistribute, boolean distributeToInputs) {
        int initialWasteAmount = ItemHelper.stackGetSize((ItemStack)itemsToDistribute);
        if (!port.getDirection().isInput() || distributeToInputs || this.attachedAccessPorts.size() < 2) {
            itemsToDistribute = ItemHandlerHelper.insertItem((IItemHandler)port.getItemStackHandler(false), (ItemStack)itemsToDistribute, (boolean)false);
            port.onItemsReceived();
        }
        return ItemHelper.stackIsValid((ItemStack)itemsToDistribute) ? initialWasteAmount - ItemHelper.stackGetSize((ItemStack)itemsToDistribute) : initialWasteAmount;
    }

    protected void onAssimilated(MultiblockControllerBase otherMachine) {
        this.attachedPowerTaps.clear();
        this.attachedTickables.clear();
        this.attachedAccessPorts.clear();
        this.attachedControllers.clear();
        this.attachedControlRods.clear();
        this.currentFuelRod = null;
        this._fuelRodsLayout = null;
    }

    protected void onAssimilate(MultiblockControllerBase otherMachine) {
        if (!(otherMachine instanceof MultiblockReactor)) {
            BRLog.warning("[%s] Reactor @ %s is attempting to assimilate a non-Reactor machine! That machine's data will be lost!", this.WORLD.field_72995_K ? "CLIENT" : "SERVER", this.getReferenceCoord());
            return;
        }
        MultiblockReactor otherReactor = (MultiblockReactor)otherMachine;
        if (otherReactor.reactorHeat > this.reactorHeat) {
            this.setReactorHeat(otherReactor.reactorHeat);
        }
        if (otherReactor.fuelHeat > this.fuelHeat) {
            this.setFuelHeat(otherReactor.fuelHeat);
        }
        if (otherReactor.getEnergyStored() > this.getEnergyStored()) {
            this.setEnergyStored(otherReactor.getEnergyStored());
        }
        this.fuelContainer.merge(otherReactor.fuelContainer);
        this.radiationHelper.merge(otherReactor.radiationHelper);
        this.coolantContainer.merge(otherReactor.coolantContainer);
    }

    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.syncDataFrom(data, ModTileEntity.SyncReason.FullSync);
    }

    public void setWasteEjection(WasteEjectionSetting newSetting) {
        if (this.wasteEjection != newSetting) {
            this.wasteEjection = newSetting;
            if (!this.WORLD.field_72995_K) {
                this.markReferenceCoordDirty();
                if (this.updatePlayers.size() > 0) {
                    for (EntityPlayer player : this.updatePlayers) {
                        CommonPacketHandler.INSTANCE.sendTo((IMessage)new ReactorUpdateWasteEjectionMessage(this), (EntityPlayerMP)player);
                    }
                }
            }
        }
    }

    public WasteEjectionSetting getWasteEjection() {
        return this.wasteEjection;
    }

    protected void refuel() {
        if (this.fuelContainer.getRemainingSpace() < 1000) {
            return;
        }
        boolean wasEmpty = this.fuelContainer.getFuelAmount() <= 0;
        int amtAdded = 0;
        for (TileEntityReactorAccessPort port : this.attachedAccessPorts) {
            int portCanAdd;
            int amountToAdd;
            if (this.fuelContainer.getRemainingSpace() <= 0) break;
            if (!port.isConnected()) continue;
            String portReactantType = port.getInputReactantType();
            int portReactantAmount = port.getInputReactantAmount();
            if (portReactantType == null || portReactantAmount <= 0 || !Reactants.isFuel(portReactantType)) continue;
            if (portReactantType.equals("blutonium")) {
                portReactantType = "yellorium";
            }
            if ((amountToAdd = this.fuelContainer.addFuel(portReactantType, portReactantAmount, false)) <= 0 || (portCanAdd = port.consumeReactantItem(amountToAdd)) <= 0) continue;
            amtAdded = this.fuelContainer.addFuel(portReactantType, portCanAdd, true);
        }
        if (amtAdded > 0) {
            if (wasEmpty) {
                this.updateFuelRodsLayout();
            }
            this.markReferenceCoordForUpdate();
            this.markReferenceCoordDirty();
        }
    }

    public void ejectWaste(boolean dumpAll, BlockPos destination) {
        int amtEjected = 0;
        String wasteReactantType = this.fuelContainer.getWasteType();
        if (wasteReactantType == null) {
            return;
        }
        int minimumReactantAmount = Reactants.getMinimumReactantToProduceSolid(wasteReactantType);
        if (this.fuelContainer.getWasteAmount() >= minimumReactantAmount) {
            int reactantEjected;
            for (TileEntityReactorAccessPort port : this.attachedAccessPorts) {
                if (this.fuelContainer.getWasteAmount() < minimumReactantAmount || !port.isConnected() || destination != null && !destination.equals((Object)port.func_174877_v()) || destination != null || port.getDirection().isInput()) continue;
                reactantEjected = port.emitReactant(wasteReactantType, this.fuelContainer.getWasteAmount());
                this.fuelContainer.dumpWaste(reactantEjected);
                amtEjected += reactantEjected;
            }
            if (destination == null && this.fuelContainer.getWasteAmount() > minimumReactantAmount) {
                for (TileEntityReactorAccessPort port : this.attachedAccessPorts) {
                    if (this.fuelContainer.getWasteAmount() < minimumReactantAmount || !port.isConnected()) continue;
                    reactantEjected = port.emitReactant(wasteReactantType, this.fuelContainer.getWasteAmount());
                    this.fuelContainer.dumpWaste(reactantEjected);
                    amtEjected += reactantEjected;
                }
            }
        }
        if (dumpAll) {
            amtEjected += this.fuelContainer.getWasteAmount();
            this.fuelContainer.setWaste(null);
        }
        if (amtEjected > 0) {
            this.markReferenceCoordForUpdate();
            this.markReferenceCoordDirty();
        }
    }

    public void ejectFuel(boolean dumpAll, BlockPos destination) {
        int amtEjected = 0;
        String fuelReactantType = this.fuelContainer.getFuelType();
        if (fuelReactantType == null) {
            return;
        }
        int minimumReactantAmount = Reactants.getMinimumReactantToProduceSolid(fuelReactantType);
        if (this.fuelContainer.getFuelAmount() >= minimumReactantAmount) {
            for (TileEntityReactorAccessPort port : this.attachedAccessPorts) {
                if (this.fuelContainer.getFuelAmount() < minimumReactantAmount || !port.isConnected() || destination != null && !destination.equals((Object)port.func_174877_v())) continue;
                int reactantEjected = port.emitReactant(fuelReactantType, this.fuelContainer.getFuelAmount());
                this.fuelContainer.dumpFuel(reactantEjected);
                amtEjected += reactantEjected;
            }
        }
        if (dumpAll) {
            amtEjected += this.fuelContainer.getFuelAmount();
            this.fuelContainer.setFuel(null);
        }
        if (amtEjected > 0) {
            this.markReferenceCoordForUpdate();
            this.markReferenceCoordDirty();
        }
    }

    protected void onMachineAssembled() {
        this.recalculateDerivedValues();
        this._partsTier = PartTier.Legacy;
        this._legacyMode = true;
        PowerSystem candidatePowerSystem = PowerSystem.RedstoneFlux;
        if (this.attachedPowerTaps.size() > 0) {
            int rf = 0;
            int tesla = 0;
            for (TileEntityReactorPowerTap tap : this.attachedPowerTaps) {
                if (tap instanceof TileEntityReactorPowerTapRedstoneFlux) {
                    ++rf;
                    continue;
                }
                if (!(tap instanceof TileEntityReactorPowerTapTesla)) continue;
                ++tesla;
            }
            if (rf != 0 && tesla != 0) {
                throw new IllegalStateException("Found different power taps while assembling the machine!");
            }
            candidatePowerSystem = tesla > 0 ? PowerSystem.Tesla : PowerSystem.RedstoneFlux;
        }
        this.switchPowerSystem(candidatePowerSystem);
        this._interiorInvisible = this.attachedGlass.size() == 0;
        this._fuelRodsLayout = BigReactors.getProxy().createReactorFuelRodsLayout(this);
        for (TileEntityReactorControlRod controlRod : this.attachedControlRods) {
            controlRod.linkToFuelRods(this.getFuelRodsLayout().getRodLength());
        }
        this.getFuelRodsLayout().updateFuelRodsOcclusion(this.attachedFuelRods);
        if (this.WORLD.field_72995_K) {
            this.onFuelStatusChanged();
            this.markMultiblockForRenderUpdate();
        } else {
            this.markReferenceCoordForUpdate();
        }
    }

    protected void onMachineRestored() {
        this.onMachineAssembled();
    }

    protected void onMachinePaused() {
        this.markMultiblockForRenderUpdate();
    }

    protected void onMachineDisassembled() {
        this.active = false;
        this.markMultiblockForRenderUpdate();
    }

    private void recalculateDerivedValues() {
        BlockPos minCoord = this.getMinimumCoord();
        BlockPos maxCoord = this.getMaximumCoord();
        this.fuelContainer.setCapacity(this.attachedFuelRods.size() * 4000);
        this.fuelToReactorHeatTransferCoefficient = 0.0f;
        for (TileEntityReactorFuelRod fuelRod : this.attachedFuelRods) {
            this.fuelToReactorHeatTransferCoefficient += fuelRod.getHeatTransferRate();
        }
        int xSize = maxCoord.func_177958_n() - minCoord.func_177958_n() - 1;
        int ySize = maxCoord.func_177956_o() - minCoord.func_177956_o() - 1;
        int zSize = maxCoord.func_177952_p() - minCoord.func_177952_p() - 1;
        int surfaceArea = 2 * (xSize * ySize + xSize * zSize + ySize * zSize);
        this.reactorToCoolantSystemHeatTransferCoefficient = 0.6f * (float)surfaceArea;
        surfaceArea = 2 * ((xSize += 2) * (ySize += 2) + xSize * (zSize += 2) + ySize * zSize);
        this.reactorHeatLossCoefficient = 0.001f * (float)surfaceArea;
        this.calculateReactorVolume();
        if (this.attachedCoolantPorts.size() > 0) {
            int outerVolume = StaticUtils.ExtraMath.Volume(minCoord, maxCoord) - this.reactorVolume;
            this.coolantContainer.setCapacity(Math.max(0, Math.min(50000, outerVolume * 100)));
        } else {
            this.coolantContainer.setCapacity(0);
        }
    }

    protected int getMaximumXSize() {
        return BigReactors.CONFIG.maxReactorSize;
    }

    protected int getMaximumZSize() {
        return BigReactors.CONFIG.maxReactorSize;
    }

    protected int getMaximumYSize() {
        return BigReactors.CONFIG.maxReactorHeight;
    }

    public void setEnergyGeneratedLastTick(float energyGeneratedLastTick) {
        this.energyGeneratedLastTick = energyGeneratedLastTick;
    }

    public float getEnergyGeneratedLastTick() {
        return this.energyGeneratedLastTick;
    }

    public void setFuelConsumedLastTick(float fuelConsumed) {
        this.fuelConsumedLastTick = fuelConsumed;
    }

    public float getFuelConsumedLastTick() {
        return this.fuelConsumedLastTick;
    }

    public float getFuelRichness() {
        int amtWaste;
        int amtFuel = this.fuelContainer.getFuelAmount();
        if ((float)(amtFuel + (amtWaste = this.fuelContainer.getWasteAmount())) <= 0.0f) {
            return 0.0f;
        }
        return (float)amtFuel / (float)(amtFuel + amtWaste);
    }

    public void setAllControlRodInsertionValues(int newValue) {
        if (this.assemblyState != MultiblockControllerBase.AssemblyState.Assembled) {
            return;
        }
        for (TileEntityReactorControlRod cr : this.attachedControlRods) {
            if (!cr.isConnected()) continue;
            cr.setControlRodInsertion((short)newValue);
        }
    }

    public void changeAllControlRodInsertionValues(short delta) {
        if (this.assemblyState != MultiblockControllerBase.AssemblyState.Assembled) {
            return;
        }
        for (TileEntityReactorControlRod cr : this.attachedControlRods) {
            if (!cr.isConnected()) continue;
            cr.setControlRodInsertion((short)(cr.getControlRodInsertion() + delta));
        }
    }

    public BlockPos[] getControlRodLocations() {
        BlockPos[] coords = new BlockPos[this.attachedControlRods.size()];
        int i = 0;
        for (TileEntityReactorControlRod cr : this.attachedControlRods) {
            coords[i++] = cr.func_174877_v();
        }
        return coords;
    }

    @Nullable
    public TileEntityReactorControlRod getControlRodByIndex(int index) {
        if (index < 0 || index > this.attachedControlRods.size()) {
            return null;
        }
        int i = 0;
        for (TileEntityReactorControlRod cr : this.attachedControlRods) {
            if (i++ != index) continue;
            return cr;
        }
        return null;
    }

    @Override
    public int getFuelAmount() {
        return this.fuelContainer.getFuelAmount();
    }

    @Override
    public int getWasteAmount() {
        return this.fuelContainer.getWasteAmount();
    }

    public String getFuelType() {
        return this.fuelContainer.getFuelType();
    }

    public String getWasteType() {
        return this.fuelContainer.getWasteType();
    }

    public int getEnergyStoredPercentage() {
        return (int)(this.energyStored / (float)this._powerSystem.maxCapacity * 100.0f);
    }

    @Override
    public int getCapacity() {
        if (this.WORLD.field_72995_K && this.assemblyState != MultiblockControllerBase.AssemblyState.Assembled) {
            return this.attachedFuelRods.size() * 4000;
        }
        return this.fuelContainer.getCapacity();
    }

    public float getFuelFertility() {
        return this.radiationHelper.getFertilityModifier();
    }

    public CoolantContainer getCoolantContainer() {
        return this.coolantContainer;
    }

    protected float getPassiveCoolantTemperature() {
        return 20.0f;
    }

    protected float getCoolantTemperature() {
        if (this.isPassivelyCooled()) {
            return this.getPassiveCoolantTemperature();
        }
        return this.coolantContainer.getCoolantTemperature(this.getReactorHeat());
    }

    public boolean isPassivelyCooled() {
        return this.coolantContainer == null || this.coolantContainer.getCapacity() <= 0;
    }

    protected int getReactorVolume() {
        return this.reactorVolume;
    }

    protected void calculateReactorVolume() {
        BlockPos minInteriorCoord = this.getMinimumCoord().func_177982_a(1, 1, 1);
        BlockPos maxInteriorCoord = this.getMaximumCoord().func_177982_a(-1, -1, -1);
        this.reactorVolume = StaticUtils.ExtraMath.Volume(minInteriorCoord, maxInteriorCoord);
    }

    protected void onFuelStatusChanged() {
        if (WorldHelper.calledByLogicalClient((World)this.WORLD) && this.isAssembled()) {
            this.updateFuelRodsLayout();
            ReactorFuelRodsLayout layout = this.getFuelRodsLayout();
            if (layout instanceof ClientReactorFuelRodsLayout) {
                ClientReactorFuelRodsLayout clientLayout = (ClientReactorFuelRodsLayout)layout;
                for (TileEntityReactorFuelRod fuelRod : this.attachedFuelRods) {
                    if (!clientLayout.isFuelDataChanged(fuelRod.getFuelRodIndex())) continue;
                    WorldHelper.notifyBlockUpdate((World)this.WORLD, (BlockPos)fuelRod.getWorldPosition(), null, null);
                }
            }
        }
    }

    protected void markReferenceCoordForUpdate() {
        BlockPos rc = this.getReferenceCoord();
        if (this.WORLD != null && rc != null) {
            WorldHelper.notifyBlockUpdate((World)this.WORLD, (BlockPos)rc, null, null);
        }
    }

    protected void markReferenceCoordDirty() {
        if (this.WORLD == null || this.WORLD.field_72995_K) {
            return;
        }
        BlockPos referenceCoord = this.getReferenceCoord();
        if (referenceCoord == null) {
            return;
        }
        TileEntity saveTe = this.WORLD.func_175625_s(referenceCoord);
        this.WORLD.func_175646_b(referenceCoord, saveTe);
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    public PartTier getMachineTier() {
        return this._partsTier;
    }

    protected void switchPowerSystem(PowerSystem newPowerSystem) {
        this._powerSystem = newPowerSystem;
        if (this.energyStored > (float)this._powerSystem.maxCapacity) {
            this.energyStored = this._powerSystem.maxCapacity;
        }
    }

    @Nonnull
    public ReactorFuelRodsLayout getFuelRodsLayout() {
        return this._fuelRodsLayout;
    }

    private void updateFuelRodsLayout() {
        this.getFuelRodsLayout().updateFuelData(this.fuelContainer, this.attachedFuelRods.size());
    }

    public boolean isInteriorInvisible() {
        return this._interiorInvisible;
    }

    @Override
    public long getEnergyCapacity() {
        return this._powerSystem.maxCapacity;
    }

    @Override
    public long getEnergyStored() {
        return (long)this.energyStored;
    }

    @Override
    public long extractEnergy(long maxEnergy, boolean simulate) {
        long removed = (long)Math.min((float)maxEnergy, this.energyStored);
        if (!simulate) {
            this.reduceStoredEnergy(removed);
        }
        return removed;
    }

    @Override
    public PowerSystem getPowerSystem() {
        return this._powerSystem;
    }

    public IFluidHandler getFluidHandler(IInputOutputPort.Direction direction) {
        int idx = IInputOutputPort.Direction.Input == direction ? 1 : 0;
        IFluidHandler handler = this._coolantHandlers[idx];
        if (null == handler) {
            this._coolantHandlers[idx] = handler = new CoolantFluidHandlerWrapper(this, direction);
        }
        return handler;
    }

    public void getDebugMessages(IDebugMessages messages) {
        boolean assembled = this.isAssembled();
        messages.add("debug.bigreactors.assembled", new Object[]{CodeHelper.i18nValue((boolean)assembled)});
        messages.add("debug.bigreactors.attached", new Object[]{Integer.toString(this.connectedParts.size())});
        ValidationError lastError = this.getLastError();
        if (null != lastError) {
            messages.add("debug.bigreactors.lastvalidationerror", new Object[]{lastError.getChatMessage()});
        }
        if (assembled) {
            messages.add("debug.bigreactors.active", new Object[]{CodeHelper.i18nValue((boolean)this.getActive())});
            messages.add("debug.bigreactors.storedenergy", new Object[]{this.getEnergyStored(), this.getPowerSystem().unitOfMeasure});
            messages.add("debug.bigreactors.reactor.casingheat", new Object[]{Float.valueOf(this.getReactorHeat())});
            messages.add("debug.bigreactors.reactor.fuelheat", new Object[]{Float.valueOf(this.getFuelHeat())});
            messages.add("debug.bigreactors.reactor.reactanttanksIntro", new Object[0]);
            this.fuelContainer.getDebugMessages(messages);
            boolean passiveCooling = this.isPassivelyCooled();
            messages.add("debug.bigreactors.reactor.activelycooled", new Object[]{CodeHelper.i18nValue((!passiveCooling ? 1 : 0) != 0)});
            if (!passiveCooling) {
                messages.add("debug.bigreactors.reactor.coolanttanksIntro", new Object[0]);
                this.coolantContainer.getDebugMessages(messages);
            }
        }
    }

    private class CoolantFluidHandlerWrapper
    implements IFluidHandler {
        private final MultiblockReactor _reactor;
        private final int _tankId;

        public CoolantFluidHandlerWrapper(MultiblockReactor reactor, IInputOutputPort.Direction direction) {
            this._reactor = reactor;
            this._tankId = IInputOutputPort.Direction.Input == direction ? 1 : 0;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this._reactor.getCoolantContainer().getTankProperties(this._tankId);
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this._reactor.getCoolantContainer().fill(this._tankId, resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this._reactor.getCoolantContainer().drain(this._tankId, resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this._reactor.getCoolantContainer().drain(this._tankId, maxDrain, doDrain);
        }
    }

    public static enum WasteEjectionSetting {
        kAutomatic,
        kManual;

    }
}

