/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.builders;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.GuiMarkdownElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.IPartBuilder;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.MouseIntractable;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.Part;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.old.PartContainer;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class PartBuilderEntity
extends IPartBuilder {
    public static Map<String, Entity> renderEntityCache = new HashMap<String, Entity>();
    private static Pattern entityPat = Pattern.compile("(?<=[^\\\\]|^)(\u00a7entity\\[[^\u00a7]*]\\{[^\u00a7]*})|(?<=[^\\\\]|^)(\u00a7entity\\[[^\u00a7 ]*])");
    private static Pattern entityString = Pattern.compile("(?<=\u00a7entity\\[)(.*)(?=][{])|(?<=\u00a7entity\\[)(.*)(?=])");
    private static Pattern entityOPS = Pattern.compile("(?<=]\\{)(.*)(?=})");

    @Override
    public int matches(String test) {
        Matcher matcher = entityPat.matcher(test);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    @Override
    public String build(BCFontRenderer font, String markdown, int nextPart, BCFontRenderer fr, PartContainer container, LinkedList<Part> parts, int elementLeft, int elementRight, int xPos, int yPos, int nextYLevel) {
        Entity renderEntity;
        double eScale;
        double rotation;
        double rotationSpeed;
        int yOffset;
        int xOffset;
        int size;
        String entityString;
        GuiMarkdownElement.profiler.startSection("Build Entity");
        Matcher entityPatMatch = entityPat.matcher(markdown);
        if (!entityPatMatch.find(0)) {
            LogHelperBC.error("Failed to build " + this.getClass().getSimpleName() + " This suggests a false match occurred which should not be possible!");
            return "";
        }
        String match = entityPatMatch.group();
        Matcher entityStringMatch = PartBuilderEntity.entityString.matcher(match);
        if (!entityStringMatch.find() || (entityString = entityStringMatch.group()).isEmpty()) {
            return entityPatMatch.replaceFirst("[Broken Entity. No entity string Found]");
        }
        Matcher opsMatch = entityOPS.matcher(match);
        String ops = opsMatch.find() ? opsMatch.group() : "";
        try {
            size = Part.parseSize(elementRight - elementLeft, Part.readOption(ops, "size", "64"));
            xOffset = Integer.parseInt(Part.readOption(ops, "x_offset", "0"));
            yOffset = Integer.parseInt(Part.readOption(ops, "y_offset", "0"));
        }
        catch (NumberFormatException e) {
            return entityPatMatch.replaceFirst("[Broken Entity. Invalid size or offset value! Must be an integer number]");
        }
        try {
            rotationSpeed = Double.parseDouble(Part.readOption(ops, "rotate_speed", "1"));
            rotation = Double.parseDouble(Part.readOption(ops, "rotation", "0"));
            eScale = Double.parseDouble(Part.readOption(ops, "scale", "1"));
        }
        catch (NumberFormatException e) {
            return entityPatMatch.replaceFirst("[Broken Entity. Invalid rotation or scale value! Must be a number]");
        }
        String hover = Part.readOption(ops, "hover", "");
        final boolean trackMouse = Part.readOption(ops, "track_mouse", "false").equals("true");
        final boolean drawName = Part.readOption(ops, "draw_name", "false").equals("true");
        MouseIntractable mi = new MouseIntractable();
        if (!hover.isEmpty()) {
            if (hover.contains("\\n")) {
                mi.hoverText.addAll(Arrays.asList(hover.split("(\\\\n)")));
            } else {
                mi.hoverText.add(hover);
            }
        }
        container.mouseIntractables.add(mi);
        if (this.finalXPos + size > elementRight) {
            this.finalXPos = elementLeft;
            this.finalYPos = nextYLevel;
        }
        try {
            renderEntity = PartBuilderEntity.getRenderEntity((World)container.mc.field_71441_e, entityString, ops);
        }
        catch (IllegalArgumentException e) {
            return entityPatMatch.replaceFirst("[Broken Entity. " + e.getMessage() + "]");
        }
        if (trackMouse && !(renderEntity instanceof EntityLivingBase)) {
            return entityPatMatch.replaceFirst("[Broken Entity. track_mouse is only supported with living entities]");
        }
        if (drawName && !(renderEntity instanceof EntityPlayer)) {
            return entityPatMatch.replaceFirst("[Broken Entity. draw_name is only supported by player's]");
        }
        Part part = new Part(container){

            @Override
            public void render(BCFontRenderer font, int xPos, int yPos, int mouseX, int mouseY, int colour, boolean shadow, float partialTicks) {
                if (this.errored) {
                    return;
                }
                xPos += xOffset;
                yPos += yOffset;
                try {
                    int scale = (int)((double)((float)size / Math.max(renderEntity.field_70131_O, renderEntity.field_70130_N)) * eScale);
                    double posX = (double)xPos + (double)this.width / 2.0;
                    double entityRotation = rotation + (double)((float)BCClientEventHandler.elapsedTicks + partialTicks) * rotationSpeed;
                    renderEntity.field_70173_aa = BCClientEventHandler.elapsedTicks;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(25 + scale));
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    int eyeOffset = (int)((renderEntity.field_70131_O - renderEntity.func_70047_e()) * (float)scale);
                    if (renderEntity instanceof EntityLivingBase) {
                        PartBuilderEntity.drawEntityOnScreen((int)posX, yPos + this.height, scale, (int)posX - mouseX, yPos - mouseY + eyeOffset, (EntityLivingBase)renderEntity, trackMouse, entityRotation, drawName);
                    } else {
                        PartBuilderEntity.drawEntityOnScreen((int)posX, yPos + this.height, scale, renderEntity, entityRotation);
                    }
                    GlStateManager.func_179121_F();
                }
                catch (Throwable e) {
                    LogHelperBC.error("Something went wrong while attempting to render an entity on the screen!");
                    LogHelperBC.error("Entity: " + renderEntity);
                    e.printStackTrace();
                    this.errored = true;
                }
            }
        };
        part.width = size;
        part.height = size;
        this.finalXPos += part.width;
        parts.add(part);
        mi.parts.add(part);
        this.builtHeight = this.finalYPos - yPos + part.height;
        return entityPatMatch.replaceFirst("");
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, Entity ent, double rotation) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        GlStateManager.func_179114_b((float)(135.0f + (float)rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a(ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent, boolean trackMouse, double noTrackRotation, boolean drawName) {
        float rotation;
        float f = rotation = trackMouse ? 0.0f : (float)noTrackRotation;
        if (!trackMouse) {
            mouseX = 0.0f;
            mouseY = 0.0f;
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f22 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)(135.0f + rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f + rotation + (float)(drawName ? 0 : 180));
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f2;
        ent.field_70177_z = f1;
        ent.field_70125_A = f22;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static Entity getRenderEntity(World world, String entityString, String options) {
        if (renderEntityCache.containsKey(entityString + "|" + options)) {
            return renderEntityCache.get(entityString + "|" + options);
        }
        if (!entityString.contains(":")) {
            throw new IllegalArgumentException("Invalid entity string! Must be ether modid:entityName or player:username");
        }
        Object entity = entityString.startsWith("player:") ? PartBuilderEntity.createRenderPlayer(world, entityString.replaceFirst("player:", "")) : EntityList.func_188429_b((ResourceLocation)new ResourceLocation(entityString), (World)world);
        if (entity == null) {
            throw new IllegalArgumentException("No matching entity found for string: " + entityString);
        }
        EquipmentHelper helper = EquipmentHelper.create(options);
        if (entity instanceof EntityLivingBase && helper.hasEquipment) {
            helper.apply((EntityLivingBase)entity);
        } else if (helper.hasEquipment) {
            throw new IllegalArgumentException("The specified entity does not allow equipment!");
        }
        return entity;
    }

    public static EntityPlayer createRenderPlayer(World world, String username) {
        EntityOtherPlayerMP player = new EntityOtherPlayerMP(world, TileEntitySkull.func_174884_b((GameProfile)new GameProfile(null, username))){

            public String func_175154_l() {
                return super.func_175154_l();
            }

            public ResourceLocation func_110306_p() {
                ResourceLocation resourcelocation;
                Minecraft minecraft = Minecraft.func_71410_x();
                Map map = minecraft.func_152342_ad().func_152788_a(this.func_146103_bH());
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                } else {
                    UUID uuid = EntityPlayer.func_146094_a((GameProfile)this.func_146103_bH());
                    resourcelocation = DefaultPlayerSkin.func_177334_a((UUID)uuid);
                }
                return resourcelocation;
            }

            public boolean func_175148_a(EnumPlayerModelParts part) {
                return true;
            }
        };
        return player;
    }

    static class EquipmentHelper {
        private ItemStack mainHand = ItemStack.field_190927_a;
        private ItemStack offHand = ItemStack.field_190927_a;
        private ItemStack head = ItemStack.field_190927_a;
        private ItemStack chest = ItemStack.field_190927_a;
        private ItemStack legs = ItemStack.field_190927_a;
        private ItemStack boots = ItemStack.field_190927_a;
        public boolean hasEquipment = false;

        EquipmentHelper() {
        }

        public void apply(EntityLivingBase entity) {
            if (!this.mainHand.func_190926_b()) {
                entity.func_184611_a(EnumHand.MAIN_HAND, this.mainHand);
            }
            if (!this.offHand.func_190926_b()) {
                entity.func_184611_a(EnumHand.OFF_HAND, this.offHand);
            }
            if (!this.head.func_190926_b()) {
                entity.func_184201_a(EntityEquipmentSlot.HEAD, this.head);
            }
            if (!this.chest.func_190926_b()) {
                entity.func_184201_a(EntityEquipmentSlot.CHEST, this.chest);
            }
            if (!this.legs.func_190926_b()) {
                entity.func_184201_a(EntityEquipmentSlot.LEGS, this.legs);
            }
            if (!this.boots.func_190926_b()) {
                entity.func_184201_a(EntityEquipmentSlot.FEET, this.boots);
            }
        }

        public static EquipmentHelper create(String options) {
            StackReference stackRef;
            EquipmentHelper helper = new EquipmentHelper();
            String mainHand = Part.readOption(options, "main_hand", "");
            String offHand = Part.readOption(options, "off_hand", "");
            String head = Part.readOption(options, "head", "");
            String chest = Part.readOption(options, "chest", "");
            String legs = Part.readOption(options, "legs", "");
            String boots = Part.readOption(options, "boots", "");
            if (!mainHand.isEmpty()) {
                stackRef = StackReference.fromString(mainHand);
                if (stackRef == null || (helper.mainHand = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + mainHand);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!offHand.isEmpty()) {
                stackRef = StackReference.fromString(offHand);
                if (stackRef == null || (helper.offHand = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + offHand);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!head.isEmpty()) {
                stackRef = StackReference.fromString(head);
                if (stackRef == null || (helper.head = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + head);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!chest.isEmpty()) {
                stackRef = StackReference.fromString(chest);
                if (stackRef == null || (helper.chest = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + chest);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!legs.isEmpty()) {
                stackRef = StackReference.fromString(legs);
                if (stackRef == null || (helper.legs = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + legs);
                } else {
                    helper.hasEquipment = true;
                }
            }
            if (!boots.isEmpty()) {
                stackRef = StackReference.fromString(boots);
                if (stackRef == null || (helper.boots = stackRef.createStack()) == null) {
                    LogHelperBC.warn("[MarkdownParser]: No matching item found for stack string: " + boots);
                } else {
                    helper.hasEquipment = true;
                }
            }
            return helper;
        }
    }
}

