/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.util.I18N;
import binnie.genetics.Genetics;
import binnie.genetics.gui.analyst.ControlMutation;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlFurtherMutation
extends ControlMutation {
    private final IAlleleSpecies resolute;

    public ControlFurtherMutation(IWidget parent, int x, int y, IMutation mutation, float specificChance, IBreedingSystem system, IAlleleSpecies firstSpecies, IAlleleSpecies secondSpecies, IAlleleSpecies resolute) {
        super(parent, x, y, mutation, specificChance, system, firstSpecies, secondSpecies);
        this.resolute = resolute;
        this.addTooltip(resolute.getAlleleName());
        String comb = firstSpecies.getAlleleName() + " + " + secondSpecies.getAlleleName();
        this.addTooltip(comb);
        String chance = this.getMutationColour(mutation.getBaseChance()).getCode() + (int)mutation.getBaseChance() + "% " + I18N.localise("genetics.gui.analyst.mutations.chance");
        if (specificChance != mutation.getBaseChance()) {
            chance = chance + this.getMutationColour(specificChance).getCode() + " (" + (int)specificChance + "% " + I18N.localise("genetics.gui.analyst.mutations.currently") + ')';
        }
        this.addTooltip(chance);
        for (String condition : mutation.getSpecialConditions()) {
            this.addTooltip(condition);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        GlStateManager.func_179147_l();
        RenderUtil.drawItem(Point.ZERO, this.system.getDefaultMember(this.secondSpecies.getUID()));
        RenderUtil.drawItem(new Point(28, 0), this.system.getDefaultMember(this.resolute.getUID()));
        GlStateManager.func_179084_k();
        RenderUtil.setColour(this.getMutationColour(this.mutation.getBaseChance()).getColor());
        if (this.specificChance != this.mutation.getBaseChance()) {
            RenderUtil.setColour(this.getMutationColour(this.mutation.getBaseChance()).getColor());
            this.drawSprite(Genetics.getIcons().getIconArrow0());
            RenderUtil.setColour(this.getMutationColour(this.specificChance).getColor());
            this.drawSprite(Genetics.getIcons().getIconArrow1());
        } else {
            RenderUtil.setColour(this.getMutationColour(this.mutation.getBaseChance()).getColor());
            this.drawSprite(Genetics.getIcons().getIconArrow());
        }
    }
}

