/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.ArrayList;
import java.util.List;
import jeresources.profiling.DummyWorld;
import jeresources.profiling.ProfilingExecutor;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;

public class ChunkGetter
implements Runnable {
    public static final int CHUNKS_PER_RUN = 25;
    private final int maxRunCount;
    private final DummyWorld world;
    private final Runnable runnable;
    private IChunkGetterStrategy strategy;
    private int runCount;

    public ChunkGetter(final int chunkCount, DummyWorld world, final ProfilingExecutor executor) {
        this.maxRunCount = (int)Math.ceil((float)chunkCount / 25.0f);
        this.world = world;
        this.strategy = new ChunkGetterRandom(world);
        this.runnable = new Runnable(){

            @Override
            public void run() {
                if (ChunkGetter.this.getRunCount() < ChunkGetter.this.getMaxRunCount()) {
                    DummyWorld dummyWorld = ChunkGetter.this.getWorld();
                    List<Chunk> chunks = ChunkGetter.this.strategy.generateChunks(dummyWorld);
                    if (ChunkGetter.this.strategy instanceof ChunkGetterRandom && ChunkGetter.this.areAllChunksEmpty(chunks)) {
                        ChunkGetter.this.strategy = new ChunkGetterOrigin(dummyWorld, chunkCount);
                        chunks = ChunkGetter.this.strategy.generateChunks(dummyWorld);
                    }
                    ChunkGetter.this.runCount++;
                    executor.addChunkProfiler(dummyWorld, chunks);
                    executor.execute(() -> dummyWorld.func_152344_a(ChunkGetter.this.runnable));
                } else {
                    executor.shutdown();
                }
            }
        };
    }

    @Override
    public void run() {
        this.runnable.run();
    }

    private DummyWorld getWorld() {
        return this.world;
    }

    private int getMaxRunCount() {
        return this.maxRunCount;
    }

    private int getRunCount() {
        return this.runCount;
    }

    private boolean areAllChunksEmpty(List<Chunk> chunks) {
        for (Chunk chunk : chunks) {
            if (chunk.func_76625_h() == 0) continue;
            return false;
        }
        return true;
    }

    private static List<Chunk> centerChunks(DummyWorld dummyWorld, int chunkX, int chunkZ, int generate_size) {
        ArrayList<Chunk> centerChunks = new ArrayList<Chunk>();
        for (int i = 0; i < generate_size; ++i) {
            for (int j = 0; j < generate_size; ++j) {
                Chunk chunk = dummyWorld.func_72964_e(chunkX + i, chunkZ + j);
                if (i <= 0 || i >= generate_size - 1 || j <= 0 || j >= generate_size - 1) continue;
                centerChunks.add(chunk);
            }
        }
        return centerChunks;
    }

    private static class ChunkGetterOrigin
    implements IChunkGetterStrategy {
        private static final int GENERATE_SIZE = (int)Math.ceil(Math.sqrt(25.0)) + 2;
        private final int sideLength;
        private final int minX;
        private final int maxX;
        private int posX;
        private int posZ;

        public ChunkGetterOrigin(WorldServer worldServer, int chunkCount) {
            this.sideLength = (int)Math.ceil(Math.sqrt(chunkCount));
            WorldBorder worldBorder = worldServer.func_175723_af();
            this.minX = (int)worldBorder.func_177731_f() - this.sideLength / 2;
            this.maxX = (int)worldBorder.func_177731_f() + this.sideLength / 2;
            this.posX = this.minX;
            this.posZ = (int)worldBorder.func_177721_g() - this.sideLength / 2;
        }

        @Override
        public List<Chunk> generateChunks(DummyWorld dummyWorld) {
            int chunkX = this.posX;
            int chunkZ = this.posZ;
            this.posX += GENERATE_SIZE - 1;
            if (this.posX > this.maxX) {
                this.posX = this.minX;
                this.posZ += GENERATE_SIZE - 1;
            }
            return ChunkGetter.centerChunks(dummyWorld, chunkX, chunkZ, ChunkGetterOrigin.GENERATE_SIZE);
        }
    }

    private static class ChunkGetterRandom
    implements IChunkGetterStrategy {
        private static final int GENERATE_SIZE = (int)Math.ceil(Math.sqrt(25.0)) + 2;
        private final WorldBorder worldBorder;

        public ChunkGetterRandom(WorldServer world) {
            this.worldBorder = world.func_175723_af();
        }

        @Override
        public List<Chunk> generateChunks(DummyWorld dummyWorld) {
            int maxChunkPos = this.worldBorder.func_177722_l() / 16 - GENERATE_SIZE;
            int chunkX = dummyWorld.field_73012_v.nextInt(2 * maxChunkPos) - maxChunkPos + (int)this.worldBorder.func_177731_f();
            int chunkZ = dummyWorld.field_73012_v.nextInt(2 * maxChunkPos) - maxChunkPos + (int)this.worldBorder.func_177721_g();
            return ChunkGetter.centerChunks(dummyWorld, chunkX, chunkZ, ChunkGetterRandom.GENERATE_SIZE);
        }
    }

    private static interface IChunkGetterStrategy {
        public List<Chunk> generateChunks(DummyWorld var1);
    }
}

