/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.IRegistryDelegate;
import p455w0rdslib.util.EasyMappings;
import p455w0rdslib.util.MCPrivateUtils;

public class ItemUtils {
    public static ItemStack getHelmet(EntityPlayer player) {
        return player.field_71071_by.func_70301_a(39);
    }

    public static ItemStack getChestplate(EntityPlayer player) {
        return player.field_71071_by.func_70301_a(38);
    }

    public static ItemStack getLeggings(EntityPlayer player) {
        return player.field_71071_by.func_70301_a(37);
    }

    public static ItemStack getBoots(EntityPlayer player) {
        return player.field_71071_by.func_70301_a(36);
    }

    public static boolean areItemTagsEqual(ItemStack is1, ItemStack itemStackIn) {
        ItemStack newStack = is1.func_77946_l();
        if (newStack.func_77942_o()) {
            if (newStack.func_77978_p().func_74764_b("p455w0rd.StackSize")) {
                newStack.func_77978_p().func_82580_o("p455w0rd.StackSize");
            }
            if (newStack.func_77978_p().func_82582_d()) {
                newStack.func_77982_d(null);
            }
        }
        return ItemStack.func_77970_a((ItemStack)newStack, (ItemStack)itemStackIn);
    }

    public static boolean areItemsEqual(ItemStack is1, ItemStack itemStackIn) {
        return is1.func_77973_b() == itemStackIn.func_77973_b() && is1.func_77952_i() == itemStackIn.func_77952_i() && ItemUtils.areItemTagsEqual(is1, itemStackIn);
    }

    public static void dropItemStackInWorld(World worldObj, double x, double y, double z, ItemStack stack) {
        float f = 0.7f;
        float d0 = worldObj.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
        float d1 = worldObj.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
        float d2 = worldObj.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
        EntityItem entityitem = new EntityItem(worldObj, x + (double)d0, y + (double)d1, z + (double)d2, stack);
        entityitem.func_174867_a(10);
        if (stack.func_77942_o()) {
            entityitem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
        }
        EasyMappings.spawn(worldObj, (Entity)entityitem);
    }

    public static boolean readBoolean(ItemStack is, String key) {
        if (is == null) {
            return false;
        }
        NBTTagCompound tag = ItemUtils.getTag(is);
        return tag.func_74764_b(key) ? tag.func_74767_n(key) : false;
    }

    public static int readInt(ItemStack is, String key) {
        if (is == null) {
            return 0;
        }
        NBTTagCompound tag = ItemUtils.getTag(is);
        return tag.func_74764_b(key) ? tag.func_74762_e(key) : -1;
    }

    public static void writeInt(ItemStack is, String key, int value) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = ItemUtils.getTag(is);
        tag.func_74768_a(key, value);
    }

    public static void writeBoolean(ItemStack is, String key, boolean value) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = ItemUtils.getTag(is);
        tag.func_74757_a(key, value);
    }

    public static void delKey(ItemStack is, String key) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = ItemUtils.getTag(is);
        tag.func_82580_o(key);
    }

    public static NBTTagCompound getTag(ItemStack is) {
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        return is.func_77978_p();
    }

    public static ItemStack readStack(NBTTagCompound nbtTC, String key) {
        return nbtTC.func_74764_b(key) ? new ItemStack(nbtTC) : null;
    }

    public static CapabilityDispatcher getCaps(ItemStack stack) {
        return MCPrivateUtils.getItemStackCapabilities(stack);
    }

    public static void setItem(ItemStack stack, Item newItem) {
        Item item = stack.func_77973_b();
        NBTTagCompound capNBT = MCPrivateUtils.getItemStackCapNBT(stack);
        if (newItem == item && stack != null && ItemUtils.getCaps(stack) != null) {
            ICapabilityProvider parent = item.initCapabilities(stack, ItemUtils.getCaps(stack).serializeNBT());
            MCPrivateUtils.setItemStackCapabilities(stack, ForgeEventFactory.gatherCapabilities((ItemStack)stack, (ICapabilityProvider)parent));
        } else if (newItem != item && newItem != null) {
            ICapabilityProvider parent = newItem.initCapabilities(stack, capNBT);
            MCPrivateUtils.setItemStackCapabilities(stack, ForgeEventFactory.gatherCapabilities((ItemStack)stack, (ICapabilityProvider)parent));
        }
        if (capNBT != null && ItemUtils.getCaps(stack) != null) {
            ItemUtils.getCaps(stack).deserializeNBT(capNBT);
        }
        MCPrivateUtils.setItemStackDelegate(stack, (IRegistryDelegate<Item>)(newItem != null ? newItem.delegate : null));
        MCPrivateUtils.setItemStackItem(stack, newItem);
    }

    public static boolean areStacksSameSize(ItemStack stackA, ItemStack stackB) {
        return stackA == null && stackB == null || stackA != null && stackB != null && stackA.func_190916_E() == stackB.func_190916_E();
    }
}

