/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world.posmap;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import elec332.core.api.util.IClearable;
import elec332.core.world.WorldHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class PositionedObjectHolder<T>
implements IClearable {
    private final Map<Long, PositionChunk> positionedMap;
    private final Set<ChangeCallback<T>> callbacks;
    private boolean hasCallbacks;

    public PositionedObjectHolder() {
        this(256);
    }

    private PositionedObjectHolder(int height) {
        this((Map<Long, PositionChunk>)new Long2ObjectLinkedOpenHashMap());
    }

    private PositionedObjectHolder(Map<Long, PositionChunk> positionedMap) {
        this.positionedMap = positionedMap;
        this.callbacks = Sets.newHashSet();
        this.hasCallbacks = false;
    }

    @Override
    public void clear() {
        this.positionedMap.values().forEach(rec$ -> ((PositionChunk)rec$).clear());
        this.positionedMap.clear();
        this.callbacks.clear();
    }

    public void registerCallback(ChangeCallback<T> callback) {
        if (callback == null) {
            return;
        }
        this.callbacks.add(callback);
        if (!this.hasCallbacks) {
            this.hasCallbacks = true;
        }
    }

    @Nullable
    public T get(BlockPos pos) {
        return (T)this.getChunkForPos(pos).get(pos);
    }

    @Nonnull
    private PositionChunk getChunkForPos(BlockPos pos) {
        return this.getChunkForPos(new ChunkPos(pos));
    }

    @Nonnull
    private PositionChunk getChunkForPos(ChunkPos chunkPos) {
        long l = WorldHelper.longFromChunkPos(chunkPos);
        PositionChunk positionChunk = this.positionedMap.get(l);
        if (positionChunk == null) {
            positionChunk = new PositionChunk(chunkPos);
            this.positionedMap.put(l, positionChunk);
        }
        return positionChunk;
    }

    public void put(T t, BlockPos pos) {
        this.getChunkForPos(pos).put(t, pos);
    }

    public void remove(BlockPos pos) {
        PositionChunk chunk = this.getChunkForPos(pos);
        chunk.remove(pos);
        if (chunk.posMap.isEmpty()) {
            this.positionedMap.remove(WorldHelper.longFromChunkPos(chunk.pos));
        }
    }

    public Set<ChunkPos> getChunks() {
        HashSet ret = Sets.newHashSet();
        for (PositionChunk chunk : this.positionedMap.values()) {
            ret.add(chunk.pos);
        }
        return ret;
    }

    @Nonnull
    public Map<BlockPos, T> getObjectsInChunk(ChunkPos chunk) {
        return this.getChunkForPos(chunk).publicVisibleMap;
    }

    public boolean chunkExists(ChunkPos chunkPos) {
        return this.positionedMap.containsKey(WorldHelper.longFromChunkPos(chunkPos));
    }

    public boolean hasObject(BlockPos pos) {
        long l = WorldHelper.chunkLongFromBlockPos(pos);
        return this.positionedMap.containsKey(l) && this.getChunkForPos(new ChunkPos(pos)).get(pos) != null;
    }

    public static <T> PositionedObjectHolder<T> immutableCopy(PositionedObjectHolder<T> original) {
        return new PositionedObjectHolder<T>((Map)original.positionedMap){

            @Override
            public void put(T t, BlockPos pos) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove(BlockPos pos) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static interface ChangeCallback<T> {
        public void onChange(T var1, BlockPos var2, boolean var3);
    }

    private class PositionChunk {
        private final ChunkPos pos;
        private final Map<BlockPos, T> posMap;
        private final Map<BlockPos, T> publicVisibleMap;

        private PositionChunk(ChunkPos pos) {
            this.pos = pos;
            this.posMap = Maps.newHashMap();
            this.publicVisibleMap = Collections.unmodifiableMap(this.posMap);
        }

        private T get(BlockPos pos) {
            return this.posMap.get(pos);
        }

        private void put(T t, BlockPos pos) {
            this.posMap.put(pos, t);
            if (PositionedObjectHolder.this.hasCallbacks) {
                for (ChangeCallback callback : PositionedObjectHolder.this.callbacks) {
                    callback.onChange(t, pos, true);
                }
            }
        }

        private void remove(BlockPos pos) {
            Object t = this.posMap.remove(pos);
            if (PositionedObjectHolder.this.hasCallbacks) {
                for (ChangeCallback callback : PositionedObjectHolder.this.callbacks) {
                    callback.onChange(t, pos, false);
                }
            }
        }

        private void clear() {
            this.posMap.clear();
        }
    }
}

