/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.loader;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.ElecCore;
import elec332.core.api.APIHandlerInject;
import elec332.core.api.IAPIHandler;
import elec332.core.api.annotations.StaticLoad;
import elec332.core.api.discovery.ASMDataProcessor;
import elec332.core.api.discovery.IASMDataHelper;
import elec332.core.api.discovery.IASMDataProcessor;
import elec332.core.api.discovery.IAdvancedASMData;
import elec332.core.util.FMLUtil;
import elec332.core.util.ReflectionHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.ObjectUtils;

@ASMDataProcessor(value={LoaderState.CONSTRUCTING}, importance=0x7FFFFFF7)
enum APIHandler implements IASMDataProcessor,
IAPIHandler
{
    INSTANCE;

    private final Map<Class<?>, List<Consumer<?>>> callBacks = Maps.newHashMap();
    private final Map<Class<?>, Object> injectedHandlers = Maps.newHashMap();

    @Override
    public void processASMData(IASMDataHelper asmData, LoaderState state) {
        this.getWeightedAdvancedAnnotationList(asmData, StaticLoad.class, "weight").forEach(slD -> {
            try {
                slD.loadClass();
            }
            catch (Exception e) {
                if (slD.hasSideOnlyAnnotation()) {
                    return;
                }
                throw e;
            }
        });
        this.collect(asmData, APIHandlerInject.class, "weight");
        this.inject(INSTANCE, IAPIHandler.class);
    }

    private void collect(IASMDataHelper asmData, Class<? extends Annotation> annotationClass, String weightField) {
        for (IAdvancedASMData data : this.getWeightedAdvancedAnnotationList(asmData, annotationClass, weightField)) {
            try {
                Consumer<Object> ret;
                Class<?> type;
                if (data.isMethod()) {
                    Class<?>[] params = data.getMethodParameters();
                    if (params.length > 1 || params.length < 0) {
                        ElecCore.logger.error("Skipping invalid API method: " + data.getClassName() + " " + data.getMethodName());
                    }
                    type = params[0];
                    Method m = data.getMethod();
                    ret = o -> {
                        List<Object> clsz = this.tryGetFieldOwner(m);
                        if (clsz == null) {
                            ElecCore.logger.error("Method " + data.getClassName() + " " + data.getMethodName() + " is not accessible! it will be skipped...");
                            return;
                        }
                        m.setAccessible(true);
                        clsz.forEach(obj -> {
                            try {
                                m.invoke(obj, o);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        });
                    };
                } else {
                    type = data.getFieldType();
                    Field field = data.getField();
                    ret = o -> {
                        List<Object> clsz = this.tryGetFieldOwner(field);
                        if (clsz == null) {
                            ElecCore.logger.error("Field " + data.getClassName() + "." + data.getFieldName() + " is not accessible! it will be skipped...");
                            return;
                        }
                        clsz.forEach(obj -> {
                            try {
                                EnumHelper.setFailsafeFieldValue((Field)field, (Object)obj, (Object)o);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        });
                    };
                }
                List l = this.callBacks.computeIfAbsent((Class<?>)Preconditions.checkNotNull(type), (Function<Class<?>, List<Consumer<?>>>)((Function<Class, List>)t -> Lists.newArrayList()));
                l.add(Preconditions.checkNotNull(ret));
            }
            catch (Exception e) {
                if (data.hasSideOnlyAnnotation()) continue;
                throw e;
            }
        }
    }

    @Override
    public void inject(Object o, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.isAssignableFrom(o.getClass())) {
                throw new IllegalArgumentException();
            }
            for (Consumer consumer : (List)Optional.ofNullable(this.callBacks.remove(clazz)).orElse((List<Consumer<?>>)ImmutableList.of())) {
                consumer.accept(o);
            }
            this.injectedHandlers.put(clazz, o);
        }
    }

    @Override
    @Nullable
    public <T> T get(Class<T> type) {
        return (T)this.injectedHandlers.get(type);
    }

    private Collection<IAdvancedASMData> getWeightedAdvancedAnnotationList(IASMDataHelper asmData, Class<? extends Annotation> annotationClass, String weightField) {
        return asmData.getAdvancedAnnotationList(annotationClass).stream().sorted((o1, o2) -> {
            int ic;
            int n = ic = Strings.isNullOrEmpty((String)weightField) ? 0 : Comparator.comparingInt(value -> Math.abs((Integer)ObjectUtils.firstNonNull((Object[])new Object[]{value.getAnnotationInfo().get(weightField), 127}))).compare((IAdvancedASMData)o1, (IAdvancedASMData)o2);
            if (ic == 0) {
                return Integer.compare(o1.hashCode(), o2.hashCode());
            }
            return ic;
        }).collect(Collectors.toList());
    }

    private List<Object> tryGetFieldOwner(Member field) {
        if (ReflectionHelper.isStatic(field)) {
            return Lists.newArrayList((Object[])new Object[]{null});
        }
        Class<?> owner = field.getDeclaringClass();
        if (owner.isEnum()) {
            return Arrays.asList(owner.getEnumConstants());
        }
        ModContainer mc = FMLUtil.getOwner(owner);
        if (mc != null && mc.getMod().getClass() == owner) {
            return Lists.newArrayList((Object[])new Object[]{mc.getMod()});
        }
        Field inst = null;
        try {
            inst = owner.getDeclaredField("instance");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inst == null) {
            try {
                inst = owner.getDeclaredField("INSTANCE");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inst != null && ReflectionHelper.isStatic(inst)) {
            inst.setAccessible(true);
            try {
                return Lists.newArrayList((Object[])new Object[]{inst.get(null)});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

