/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.solar;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.render.ICustomSubItems;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.property.EnumMergingBlockRenderMode;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.machines.machine.solar.BlockItemSolarPanel;
import crazypants.enderio.machines.machine.solar.SolarBlockRenderMapper;
import crazypants.enderio.machines.machine.solar.SolarItemRenderMapper;
import crazypants.enderio.machines.machine.solar.SolarType;
import crazypants.enderio.machines.machine.solar.TileSolarPanel;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSolarPanel
extends BlockEio<TileSolarPanel>
implements IResourceTooltipProvider,
ISmartRenderAwareBlock,
ICustomSubItems {
    private static final float BLOCK_HEIGHT = 0.15625f;

    public static BlockSolarPanel create(@Nonnull IModObject modObject) {
        BlockSolarPanel result = new BlockSolarPanel(modObject);
        result.init();
        return result;
    }

    private BlockSolarPanel(@Nonnull IModObject modObject) {
        super(modObject);
        this.func_149713_g(255);
        this.field_149783_u = true;
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO)).func_177226_a(SolarType.KIND, (Comparable)((Object)SolarType.SIMPLE)));
        this.setShape(this.mkShape(BlockFaceShape.SOLID, BlockFaceShape.UNDEFINED, BlockFaceShape.UNDEFINED));
    }

    @Override
    public BlockItemSolarPanel createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemSolarPanel(this));
    }

    @Override
    protected void init() {
        super.init();
        SmartModelAttacher.register((Block)this, EnumMergingBlockRenderMode.RENDER, EnumMergingBlockRenderMode.DEFAULTS, EnumMergingBlockRenderMode.AUTO);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumMergingBlockRenderMode.RENDER, SolarType.KIND});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SolarType.KIND, (Comparable)((Object)SolarType.getTypeFromMeta(meta)));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return SolarType.getMetaFromType((SolarType)((Object)state.func_177229_b(SolarType.KIND)));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return state.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO));
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        SolarBlockRenderMapper renderMapper = new SolarBlockRenderMapper(state, world, pos);
        BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, renderMapper);
        blockStateWrapper.addCacheKey(state.func_177229_b(SolarType.KIND));
        blockStateWrapper.addCacheKey(renderMapper);
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return SolarItemRenderMapper.instance;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public int func_180651_a(@Nonnull IBlockState bs) {
        return this.func_176201_c(bs);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.15625, 1.0);
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return this.func_149739_a();
    }

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState bs) {
        return false;
    }

    public boolean doesSideBlockRendering(@Nonnull IBlockState bs, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return face == EnumFacing.DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull CreativeTabs tab, final @Nonnull NonNullList<ItemStack> list) {
        NNList.of(SolarType.class).apply((NNList.Callback)new NNList.Callback<SolarType>(){

            public void apply(@Nonnull SolarType solarType) {
                list.add((Object)new ItemStack((Block)BlockSolarPanel.this, 1, SolarType.getMetaFromType(solarType)));
            }
        });
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getSubItems() {
        return this.getSubItems((Block)this, SolarType.values().length - 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (state.func_177229_b(SolarType.KIND) == SolarType.VIBRANT && TileSolarPanel.canSeeSun(world, pos) && TileSolarPanel.calculateLightRatio(world) / 3.0f > rand.nextFloat()) {
            double d0 = (double)pos.func_177958_n() + 0.5 + (Math.random() - 0.5) * 0.5;
            double d1 = (float)pos.func_177956_o() + 0.15625f;
            double d2 = (double)pos.func_177952_p() + 0.5 + (Math.random() - 0.5) * 0.5;
            world.func_175688_a(EnumParticleTypes.REDSTONE, d0, d1, d2, 0.2784313725490196, 0.6235294117647059, 0.6392156862745098, new int[0]);
        }
    }
}

