/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.teleport;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.util.stackable.Things;
import com.enderio.core.common.vecmath.Camera;
import com.enderio.core.common.vecmath.Matrix4d;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector2d;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.base.config.config.TeleportConfig;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.teleport.packet.PacketOpenAuthGui;
import crazypants.enderio.base.teleport.packet.PacketTravelEvent;
import crazypants.enderio.util.Prep;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TravelController {
    public static final TravelController instance = new TravelController();
    @Nonnull
    private final Random rand = new Random();
    private boolean wasJumping = false;
    private boolean wasSneaking = false;
    private boolean tempJump;
    private boolean tempSneak;
    private boolean showTargets = false;
    private BlockPos onBlockCoord;
    private BlockPos selectedCoord;
    @Nonnull
    private final Camera currentView = new Camera();
    @Nonnull
    private final HashMap<BlockPos, Float> candidates = new HashMap();
    private boolean selectionEnabled = true;
    private double fovRad;
    private double tanFovRad;

    private TravelController() {
    }

    private boolean doesHandAllowTravel(@Nonnull EnumHand hand) {
        return (Boolean)TeleportConfig.enableOffHandTravel.get() != false || hand == EnumHand.MAIN_HAND;
    }

    private boolean doesHandAllowBlink(@Nonnull EnumHand hand) {
        return (Boolean)TeleportConfig.enableOffHandBlink.get() != false || hand == EnumHand.MAIN_HAND;
    }

    public boolean activateTravelAccessable(@Nonnull ItemStack equipped, @Nonnull EnumHand hand, @Nonnull World world, @Nonnull EntityPlayer player, @Nonnull TravelSource source) {
        ITravelAccessable ta;
        BlockPos target = this.selectedCoord;
        if (target == null) {
            return false;
        }
        TileEntity te = world.func_175625_s(target);
        if (te instanceof ITravelAccessable && (ta = (ITravelAccessable)te).getRequiresPassword(player)) {
            PacketOpenAuthGui p = new PacketOpenAuthGui(target);
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
            return true;
        }
        if (this.doesHandAllowTravel(hand)) {
            this.travelToSelectedTarget(player, equipped, hand, source, false);
            return true;
        }
        return true;
    }

    public boolean doBlink(@Nonnull ItemStack equipped, @Nonnull EnumHand hand, @Nonnull EntityPlayer player) {
        BlockPos bp;
        if (!this.doesHandAllowBlink(hand)) {
            return false;
        }
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)player);
        Vector3d look = Util.getLookVecEio((EntityPlayer)player);
        Vector3d sample = new Vector3d(look);
        sample.scale((double)TravelSource.STAFF_BLINK.getMaxDistanceTravelled());
        sample.add(eye);
        Vec3d eye3 = new Vec3d(eye.x, eye.y, eye.z);
        Vec3d end = new Vec3d(sample.x, sample.y, sample.z);
        double playerHeight = player.func_70033_W();
        double lookComp = -look.y * playerHeight;
        double maxDistance = (double)TravelSource.STAFF_BLINK.getMaxDistanceTravelled() + lookComp;
        RayTraceResult p = player.field_70170_p.func_72901_a(eye3, end, (Boolean)TeleportConfig.enableBlinkNonSolidBlocks.get() == false);
        if (p == null) {
            for (double i = maxDistance; i > 1.0; i -= 1.0) {
                sample.set(look);
                sample.scale(i);
                sample.add(eye);
                sample.y -= playerHeight;
                if (!this.doBlinkAround(player, equipped, hand, sample, true)) continue;
                return true;
            }
            return false;
        }
        List res = Util.raytraceAll((World)player.field_70170_p, (Vec3d)eye3, (Vec3d)end, ((Boolean)TeleportConfig.enableBlinkNonSolidBlocks.get() == false ? 1 : 0) != 0);
        for (RayTraceResult pos : res) {
            IBlockState hitBlock;
            if (pos == null || !this.isBlackListedBlock(player, pos, hitBlock = player.field_70170_p.func_180495_p(pos.func_178782_a()))) continue;
            bp = pos.func_178782_a();
            maxDistance = Math.min(maxDistance, VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)bp.func_177958_n() + 0.5, (double)bp.func_177956_o() + 0.5, (double)bp.func_177952_p() + 0.5)) - 1.5 - lookComp);
        }
        eye3 = new Vec3d(eye.x, eye.y, eye.z);
        Vector3d targetBc = new Vector3d(p.func_178782_a());
        double sampleDistance = 1.5;
        bp = p.func_178782_a();
        double teleDistance = VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)bp.func_177958_n() + 0.5, (double)bp.func_177956_o() + 0.5, (double)bp.func_177952_p() + 0.5)) + sampleDistance;
        while (teleDistance < maxDistance) {
            sample.set(look);
            sample.scale(sampleDistance);
            sample.add(targetBc);
            sample.y -= playerHeight;
            if (this.doBlinkAround(player, equipped, hand, sample, false)) {
                return true;
            }
            teleDistance += 1.0;
            sampleDistance += 1.0;
        }
        sampleDistance = -0.5;
        for (teleDistance = VecmathUtil.distance((Vector3d)eye, (Vector3d)new Vector3d((double)bp.func_177958_n() + 0.5, (double)bp.func_177956_o() + 0.5, (double)bp.func_177952_p() + 0.5)) + sampleDistance; teleDistance > 1.0; teleDistance -= 1.0) {
            sample.set(look);
            sample.scale(sampleDistance);
            sample.add(targetBc);
            sample.y -= playerHeight;
            if (this.doBlinkAround(player, equipped, hand, sample, false)) {
                return true;
            }
            sampleDistance -= 1.0;
        }
        return false;
    }

    private boolean isBlackListedBlock(@Nonnull EntityPlayer player, @Nonnull RayTraceResult pos, @Nonnull IBlockState hitBlock) {
        return ((Things)TeleportConfig.blockBlacklist.get()).contains(hitBlock.func_177230_c()) || hitBlock.func_185887_b(player.field_70170_p, pos.func_178782_a()) < 0.0f && (Boolean)TeleportConfig.enableBlinkUnbreakableBlocks.get() == false;
    }

    private boolean doBlinkAround(@Nonnull EntityPlayer player, @Nonnull ItemStack equipped, @Nonnull EnumHand hand, @Nonnull Vector3d sample, boolean conserveMomentum) {
        if (this.doBlink(player, equipped, hand, new BlockPos((int)Math.floor(sample.x), (int)Math.floor(sample.y) - 1, (int)Math.floor(sample.z)), conserveMomentum)) {
            return true;
        }
        if (this.doBlink(player, equipped, hand, new BlockPos((int)Math.floor(sample.x), (int)Math.floor(sample.y), (int)Math.floor(sample.z)), conserveMomentum)) {
            return true;
        }
        return this.doBlink(player, equipped, hand, new BlockPos((int)Math.floor(sample.x), (int)Math.floor(sample.y) + 1, (int)Math.floor(sample.z)), conserveMomentum);
    }

    private boolean doBlink(@Nonnull EntityPlayer player, @Nonnull ItemStack equipped, @Nonnull EnumHand hand, @Nonnull BlockPos coord, boolean conserveMomentum) {
        return this.travelToLocation(player, equipped, hand, TravelSource.STAFF_BLINK, coord, conserveMomentum);
    }

    public boolean showTargets() {
        return this.showTargets && this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean b) {
        this.selectionEnabled = b;
        if (!this.selectionEnabled) {
            this.candidates.clear();
        }
    }

    public boolean isBlockSelected(@Nonnull BlockPos coord) {
        return coord.equals((Object)this.selectedCoord);
    }

    public void addCandidate(@Nonnull BlockPos coord) {
        if (!this.candidates.containsKey(coord)) {
            this.candidates.put(coord, Float.valueOf(-1.0f));
        }
    }

    @SubscribeEvent
    public void onRender(@Nonnull RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)mc.field_71439_g);
        Vector3d lookAt = Util.getLookVecEio((EntityPlayer)mc.field_71439_g);
        lookAt.add(eye);
        Matrix4d mv = VecmathUtil.createMatrixAsLookAt((Vector3d)eye, (Vector3d)lookAt, (Vector3d)new Vector3d(0.0, 1.0, 0.0));
        float fov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
        Matrix4d pr = VecmathUtil.createProjectionMatrixAsPerspective((double)fov, (double)0.05f, (double)(mc.field_71474_y.field_151451_c * 16), (int)mc.field_71443_c, (int)mc.field_71440_d);
        this.currentView.setProjectionMatrix(pr);
        this.currentView.setViewMatrix(mv);
        this.currentView.setViewport(0, 0, mc.field_71443_c, mc.field_71440_d);
        this.fovRad = Math.toRadians(fov);
        this.tanFovRad = Math.tanh(this.fovRad);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (NullHelper.untrust((Object)player) == null) {
                return;
            }
            if (player.func_175149_v()) {
                this.showTargets = false;
                this.candidates.clear();
                return;
            }
            Pair<BlockPos, ITravelAccessable> pair = this.getActiveTravelBlock(player);
            this.onBlockCoord = pair != null ? (BlockPos)pair.getLeft() : null;
            boolean onBlock = this.onBlockCoord != null;
            boolean bl = this.showTargets = onBlock || this.isTravelItemActiveForSelecting((EntityPlayer)player);
            if (this.showTargets) {
                this.updateSelectedTarget(player);
            } else {
                this.selectedCoord = null;
            }
            MovementInput input = player.field_71158_b;
            if (input == null) {
                return;
            }
            this.tempJump = input.field_78901_c;
            this.tempSneak = input.field_78899_d;
            if (input.field_78901_c && !this.wasJumping && onBlock && this.selectedCoord != null && ((Boolean)TeleportConfig.activateJump.get()).booleanValue() || input.field_78899_d && !this.wasSneaking && onBlock && this.selectedCoord != null && ((Boolean)TeleportConfig.activateSneak.get()).booleanValue()) {
                this.onInput(player);
            }
            if (input.field_78901_c && !this.wasJumping && onBlock && this.selectedCoord == null) {
                this.updateVerticalTarget(player, 1);
                this.onInput(player);
            }
            if (input.field_78899_d && !this.wasSneaking && onBlock && this.selectedCoord == null) {
                this.updateVerticalTarget(player, -1);
                this.onInput(player);
            }
            this.wasJumping = this.tempJump;
            this.wasSneaking = this.tempSneak;
            this.candidates.clear();
        }
    }

    private int getEnergyInTravelItem(@Nonnull ItemStack equipped) {
        if (!(equipped.func_77973_b() instanceof IItemOfTravel)) {
            return 0;
        }
        return ((IItemOfTravel)equipped.func_77973_b()).getEnergyStored(equipped);
    }

    public boolean isTravelItemActiveForRendering(@Nonnull EntityPlayer ep) {
        return this.isTravelItemActive(ep, ep.func_184614_ca()) || (Boolean)TeleportConfig.enableOffHandTravel.get() != false && this.isTravelItemActive(ep, ep.func_184592_cb());
    }

    private boolean isTravelItemActiveForSelecting(@Nonnull EntityPlayer ep) {
        return this.isTravelItemActive(ep, ep.func_184614_ca()) || this.isTravelItemActive(ep, ep.func_184592_cb());
    }

    private boolean isTravelItemActive(@Nonnull EntityPlayer ep, @Nonnull ItemStack equipped) {
        return equipped.func_77973_b() instanceof IItemOfTravel && ((IItemOfTravel)equipped.func_77973_b()).isActive(ep, equipped);
    }

    private boolean travelToSelectedTarget(@Nonnull EntityPlayer player, @Nonnull ItemStack equipped, @Nonnull EnumHand hand, @Nonnull TravelSource source, boolean conserveMomentum) {
        BlockPos selectedCoord_nullchecked = this.selectedCoord;
        if (selectedCoord_nullchecked == null) {
            return false;
        }
        return this.travelToLocation(player, equipped, hand, source, selectedCoord_nullchecked, conserveMomentum);
    }

    private boolean travelToLocation(@Nonnull EntityPlayer player, @Nonnull ItemStack equipped, @Nonnull EnumHand hand, @Nonnull TravelSource source, @Nonnull BlockPos coord, boolean conserveMomentum) {
        ITravelAccessable ta;
        TileEntity te;
        if (source != TravelSource.STAFF_BLINK && (te = player.field_70170_p.func_175625_s(coord)) instanceof ITravelAccessable && !(ta = (ITravelAccessable)te).canBlockBeAccessed(player)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.gui.travelAccessable.unauthorised", new Object[0]));
            return false;
        }
        int requiredPower = 0;
        requiredPower = this.getRequiredPower(player, equipped, source, coord);
        if (requiredPower < 0) {
            return false;
        }
        if (!this.isInRangeTarget(player, coord, source.getMaxDistanceTravelledSq())) {
            if (source != TravelSource.STAFF_BLINK) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("enderio.blockTravelPlatform.outOfRange", new Object[0]), true);
            }
            return false;
        }
        if (!this.isValidTarget(player, coord, source)) {
            if (source != TravelSource.STAFF_BLINK) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("enderio.blockTravelPlatform.invalidTarget", new Object[0]), true);
            }
            return false;
        }
        if (this.doClientTeleport((Entity)player, hand, coord, source, requiredPower, conserveMomentum)) {
            for (int i = 0; i < 6; ++i) {
                player.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, player.field_70165_t + (this.rand.nextDouble() - 0.5), player.field_70163_u + this.rand.nextDouble() * (double)player.field_70131_O - 0.25, player.field_70161_v + (this.rand.nextDouble() - 0.5), (this.rand.nextDouble() - 0.5) * 2.0, -this.rand.nextDouble(), (this.rand.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        return true;
    }

    private int getRequiredPower(@Nonnull EntityPlayer player, @Nonnull ItemStack equipped, @Nonnull TravelSource source, @Nonnull BlockPos coord) {
        int canUsePower;
        if (!this.isTravelItemActive(player, equipped)) {
            return 0;
        }
        int requiredPower = (int)(this.getDistance(player, coord) * (double)source.getPowerCostPerBlockTraveledRF());
        if (requiredPower > (canUsePower = this.getEnergyInTravelItem(equipped))) {
            player.func_146105_b((ITextComponent)Lang.STAFF_NO_POWER.toChat(), true);
            return -1;
        }
        return requiredPower;
    }

    private boolean isInRangeTarget(@Nonnull EntityPlayer player, @Nonnull BlockPos bc, float maxSq) {
        return this.getDistanceSquared(player, bc) <= (double)maxSq;
    }

    private double getDistanceSquared(@Nonnull EntityPlayer player, @Nonnull BlockPos bc) {
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)player);
        Vector3d target = new Vector3d((double)bc.func_177958_n() + 0.5, (double)bc.func_177956_o() + 0.5, (double)bc.func_177952_p() + 0.5);
        return eye.distanceSquared(target);
    }

    private double getDistance(@Nonnull EntityPlayer player, @Nonnull BlockPos coord) {
        return Math.sqrt(this.getDistanceSquared(player, coord));
    }

    private boolean isValidTarget(@Nonnull EntityPlayer player, @Nonnull BlockPos bc, @Nonnull TravelSource source) {
        World w = player.field_70170_p;
        BlockPos baseLoc = bc;
        if (source != TravelSource.STAFF_BLINK) {
            baseLoc = bc.func_177972_a(EnumFacing.UP);
        }
        return this.canTeleportTo(player, source, baseLoc, w) && this.canTeleportTo(player, source, baseLoc.func_177972_a(EnumFacing.UP), w);
    }

    private boolean canTeleportTo(@Nonnull EntityPlayer player, @Nonnull TravelSource source, @Nonnull BlockPos bc, @Nonnull World w) {
        Vec3d target;
        Vec3d start;
        if (bc.func_177956_o() < 1) {
            return false;
        }
        if (source == TravelSource.STAFF_BLINK && !((Boolean)TeleportConfig.enableBlinkSolidBlocks.get()).booleanValue() && !this.canBlinkTo(bc, w, start = Util.getEyePosition((EntityPlayer)player), target = new Vec3d((double)((float)bc.func_177958_n() + 0.5f), (double)((float)bc.func_177956_o() + 0.5f), (double)((float)bc.func_177952_p() + 0.5f)))) {
            return false;
        }
        IBlockState bs = w.func_180495_p(bc);
        Block block = bs.func_177230_c();
        if (block.isAir(bs, (IBlockAccess)w, bc)) {
            return true;
        }
        AxisAlignedBB aabb = bs.func_185900_c((IBlockAccess)w, bc);
        return aabb.func_72320_b() < 0.7;
    }

    private boolean canBlinkTo(@Nonnull BlockPos bc, @Nonnull World w, @Nonnull Vec3d start, @Nonnull Vec3d target) {
        RayTraceResult p = w.func_72901_a(start, target, (Boolean)TeleportConfig.enableBlinkNonSolidBlocks.get() == false);
        if (p != null) {
            Block block;
            if (!((Boolean)TeleportConfig.enableBlinkNonSolidBlocks.get()).booleanValue()) {
                return false;
            }
            IBlockState bs = w.func_180495_p(p.func_178782_a());
            if (this.isClear(w, bs, block = bs.func_177230_c(), p.func_178782_a())) {
                if (BlockCoord.get((RayTraceResult)p).equals((Object)bc)) {
                    return true;
                }
                Vector3d sv = new Vector3d(start.field_72450_a, start.field_72448_b, start.field_72449_c);
                Vector3d rayDir = new Vector3d(target.field_72450_a, target.field_72448_b, target.field_72449_c);
                rayDir.sub(sv);
                rayDir.normalize();
                rayDir.add(sv);
                return this.canBlinkTo(bc, w, new Vec3d(rayDir.x, rayDir.y, rayDir.z), target);
            }
            return false;
        }
        return true;
    }

    private boolean isClear(@Nonnull World w, @Nonnull IBlockState bs, @Nonnull Block block, @Nonnull BlockPos bp) {
        if (block.isAir(bs, (IBlockAccess)w, bp)) {
            return true;
        }
        AxisAlignedBB aabb = bs.func_185900_c((IBlockAccess)w, bp);
        if (aabb.func_72320_b() < 0.7) {
            return true;
        }
        return block.getLightOpacity(bs, (IBlockAccess)w, bp) < 2;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateVerticalTarget(@Nonnull EntityPlayerSP player, int direction) {
        Pair<BlockPos, ITravelAccessable> pair = this.getActiveTravelBlock(player);
        BlockPos currentBlock = (BlockPos)pair.getKey();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int i = 0;
        for (int y = currentBlock.func_177956_o() + direction; i < ((ITravelAccessable)pair.getValue()).getTravelRangeDeparting() && y >= 0 && y <= 255; ++i, y += direction) {
            TileEntity selectedBlock = world.func_175625_s(new BlockPos(currentBlock.func_177958_n(), y, currentBlock.func_177952_p()));
            if (!(selectedBlock instanceof ITravelAccessable)) continue;
            ITravelAccessable travelBlock = (ITravelAccessable)selectedBlock;
            BlockPos targetBlock = new BlockPos(currentBlock.func_177958_n(), y, currentBlock.func_177952_p());
            if (travelBlock.canBlockBeAccessed((EntityPlayer)player) && this.isValidTarget((EntityPlayer)player, targetBlock, TravelSource.BLOCK)) {
                this.selectedCoord = targetBlock;
                return;
            }
            if (travelBlock.getRequiresPassword((EntityPlayer)player)) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("enderio.gui.travelAccessable.skipLocked", new Object[0]), true);
                continue;
            }
            if (travelBlock.getAccessMode() == ITravelAccessable.AccessMode.PRIVATE && !travelBlock.canUiBeAccessed((EntityPlayer)player)) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("enderio.gui.travelAccessable.skipPrivate", new Object[0]), true);
                continue;
            }
            if (this.isValidTarget((EntityPlayer)player, targetBlock, TravelSource.BLOCK)) continue;
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderio.gui.travelAccessable.skipObstructed", new Object[0]), true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSelectedTarget(@Nonnull EntityPlayerSP player) {
        this.selectedCoord = null;
        if (this.candidates.isEmpty()) {
            return;
        }
        double closestDistance = Double.MAX_VALUE;
        for (BlockPos bc : this.candidates.keySet()) {
            double d;
            if (bc.equals((Object)this.onBlockCoord) || !((d = this.addRatio(bc)) < closestDistance)) continue;
            this.selectedCoord = bc;
            closestDistance = d;
        }
        if (this.selectedCoord != null) {
            Vector3d blockCenter = new Vector3d((double)this.selectedCoord.func_177958_n() + 0.5, (double)this.selectedCoord.func_177956_o() + 0.5, (double)this.selectedCoord.func_177952_p() + 0.5);
            Vector2d blockCenterPixel = this.currentView.getScreenPoint(blockCenter);
            Vector2d screenMidPixel = new Vector2d((double)Minecraft.func_71410_x().field_71443_c, (double)Minecraft.func_71410_x().field_71440_d);
            screenMidPixel.scale(0.5);
            double pixDist = blockCenterPixel.distance(screenMidPixel);
            double rat = pixDist / (double)Minecraft.func_71410_x().field_71440_d;
            if (rat != rat) {
                rat = 0.0;
            }
            if (rat > 0.07) {
                this.selectedCoord = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onInput(@Nonnull EntityPlayerSP player) {
        ITravelAccessable ta;
        MovementInput input = player.field_71158_b;
        BlockPos target = TravelController.instance.selectedCoord;
        if (target == null) {
            return;
        }
        TileEntity te = player.field_70170_p.func_175625_s(target);
        if (te instanceof ITravelAccessable && (ta = (ITravelAccessable)te).getRequiresPassword((EntityPlayer)player)) {
            PacketOpenAuthGui p = new PacketOpenAuthGui(target);
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
            return;
        }
        if (this.travelToSelectedTarget((EntityPlayer)player, Prep.getEmpty(), EnumHand.MAIN_HAND, TravelSource.BLOCK, false)) {
            input.field_78901_c = false;
            try {
                ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)0, (String[])new String[]{"flyToggleTimer", "field_71101_bC"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public double getScaleForCandidate(@Nonnull Vector3d loc, int maxDistanceSq) {
        if (!this.currentView.isValid()) {
            return 1.0;
        }
        BlockPos bc = new BlockPos(loc.x, loc.y, loc.z);
        float ratio = -1.0f;
        Float r = this.candidates.get(bc);
        if (r != null) {
            ratio = r.floatValue();
        }
        if (ratio < 0.0f) {
            this.addRatio(bc);
            ratio = this.candidates.get(bc).floatValue();
        }
        float start = 0.2f;
        float end = 0.01f;
        double mix = MathHelper.func_76131_a((float)((start - ratio) / (start - end)), (float)0.0f, (float)1.0f);
        double scale = 1.0;
        if (mix > 0.0) {
            Vector3d eyePoint = Util.getEyePositionEio((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            scale = this.tanFovRad * eyePoint.distance(loc);
            scale *= (double)((Float)TeleportConfig.visualScale.get()).floatValue();
            float nf = 1.0f - MathHelper.func_76131_a((float)((float)eyePoint.distanceSquared(loc) / (float)maxDistanceSq), (float)0.0f, (float)1.0f);
            scale *= 0.3 + 0.7 * (double)nf;
            scale = scale * mix + (1.0 - mix);
            scale = Math.max(1.01, scale);
        }
        return scale;
    }

    private double addRatio(@Nonnull BlockPos bc) {
        Vector2d sp = this.currentView.getScreenPoint(new Vector3d((double)bc.func_177958_n() + 0.5, (double)bc.func_177956_o() + 0.5, (double)bc.func_177952_p() + 0.5));
        Vector2d mid = new Vector2d((double)Minecraft.func_71410_x().field_71443_c, (double)Minecraft.func_71410_x().field_71440_d);
        mid.scale(0.5);
        double d = sp.distance(mid);
        if (d != d) {
            d = 0.0;
        }
        float ratio = (float)d / (float)Minecraft.func_71410_x().field_71443_c;
        this.candidates.put(bc, Float.valueOf(ratio));
        return d;
    }

    public boolean doClientTeleport(@Nonnull Entity entity, @Nonnull EnumHand hand, @Nonnull BlockPos bc, @Nonnull TravelSource source, int powerUse, boolean conserveMomentum) {
        TeleportEntityEvent evt = new TeleportEntityEvent(entity, source, bc, entity.field_71093_bK);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        PacketTravelEvent p = new PacketTravelEvent(evt.getTarget(), powerUse, conserveMomentum, source, hand);
        PacketHandler.INSTANCE.sendToServer((IMessage)p);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private Pair<BlockPos, ITravelAccessable> getActiveTravelBlock(@Nonnull EntityPlayerSP player) {
        int z;
        int y;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (NullHelper.untrust((Object)world) == null) {
            return null;
        }
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)player.func_174813_aQ().field_72338_b) - 1, z = MathHelper.func_76128_c((double)player.field_70161_v));
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ITravelAccessable && ((ITravelAccessable)tileEntity).isTravelSource()) {
            return Pair.of((Object)new BlockPos(x, y, z), (Object)((ITravelAccessable)tileEntity));
        }
        return null;
    }

    public BlockPos getPosPlayerOn() {
        return this.onBlockCoord;
    }
}

