/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.fluid;

import com.enderio.core.common.fluid.BlockFluidEnder;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.config.config.FluidConfig;
import crazypants.enderio.base.config.config.InfinityConfig;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.material.material.MaterialCraftingHandler;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class BlockFluidEio {

    static class VaporOfLevity
    extends BlockFluidEnder {
        private static final int[] COLORS = new int[]{819920, 9488620, 5338349, 864101, 4902126};

        protected VaporOfLevity(@Nonnull Fluid fluid, @Nonnull Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity) {
            if (entity instanceof EntityPlayer || !world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).field_70181_x += 0.1;
            }
            super.func_180634_a(world, pos, state, entity);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_180655_c(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
            EnumFacing face;
            BlockPos neighborPos;
            IBlockState neighborState;
            if (rand.nextFloat() < 0.5f && !(neighborState = worldIn.func_180495_p(neighborPos = pos.func_177972_a(face = (EnumFacing)NNList.FACING.get(rand.nextInt(NNList.FACING.size()))))).func_185917_h()) {
                double yd;
                double xd;
                double d = face.func_82601_c() == 0 ? rand.nextDouble() : (xd = face.func_82601_c() < 0 ? -0.05 : 1.05);
                double d2 = face.func_96559_d() == 0 ? rand.nextDouble() : (yd = face.func_96559_d() < 0 ? -0.05 : 1.05);
                double zd = face.func_82599_e() == 0 ? rand.nextDouble() : (face.func_82599_e() < 0 ? -0.05 : 1.05);
                double x = (double)pos.func_177958_n() + xd;
                double y = (double)pos.func_177956_o() + yd;
                double z = (double)pos.func_177952_p() + zd;
                int col = COLORS[rand.nextInt(COLORS.length)];
                worldIn.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, (double)(col >> 16 & 0xFF) / 255.0, (double)(col >> 8 & 0xFF) / 255.0, (double)(col & 0xFF) / 255.0, new int[0]);
            }
        }

        public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
            if (!world.field_72995_K && rand.nextFloat() < 0.05f) {
                IBlockState neighborState;
                BlockPos neighborPos = this.getNeighbor(pos, rand);
                if (this.canMakeSnow(world, neighborPos, neighborState = world.func_180495_p(neighborPos))) {
                    world.func_175656_a(neighborPos, Blocks.field_150431_aC.func_176223_P());
                } else if (this.canMakeIce(world, neighborPos, neighborState)) {
                    world.func_175656_a(neighborPos, Blocks.field_150432_aD.func_176223_P());
                }
            }
            super.func_180650_b(world, pos, state, rand);
            if (this.canMakeMoreSnowOrIceAround(world, pos) && !world.func_184145_b(pos, (Block)this)) {
                world.func_175684_a(pos, (Block)this, this.tickRate * 10);
            }
        }

        public void func_180645_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random random) {
            super.func_180650_b(worldIn, pos, state, random);
        }

        protected boolean canMakeIce(@Nonnull World world, @Nonnull BlockPos neighborPos, @Nonnull IBlockState neighborState) {
            return neighborState.func_177230_c() == Blocks.field_150355_j && (Integer)neighborState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && world.func_190527_a(Blocks.field_150432_aD, neighborPos, false, EnumFacing.DOWN, null);
        }

        protected boolean canMakeSnow(@Nonnull World world, @Nonnull BlockPos neighborPos, @Nonnull IBlockState neighborState) {
            BlockPos belowNeighborPos = neighborPos.func_177977_b();
            Block neighborBlock = neighborState.func_177230_c();
            return neighborBlock != Blocks.field_150431_aC && !(neighborBlock instanceof IFluidBlock) && !(neighborBlock instanceof BlockLiquid) && neighborBlock.func_176200_f((IBlockAccess)world, neighborPos) && world.func_180495_p(belowNeighborPos).isSideSolid((IBlockAccess)world, belowNeighborPos, EnumFacing.UP);
        }

        protected boolean canMakeMoreSnowOrIceAround(@Nonnull World world, @Nonnull BlockPos pos) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    IBlockState neighborState;
                    BlockPos neighborPos;
                    if (x == 0 && z == 0 || !this.canMakeSnow(world, neighborPos = pos.func_177965_g(x).func_177970_e(z), neighborState = world.func_180495_p(neighborPos)) && !this.canMakeIce(world, neighborPos, neighborState)) continue;
                    return true;
                }
            }
            return false;
        }

        @Nonnull
        protected BlockPos getNeighbor(@Nonnull BlockPos pos, @Nonnull Random rand) {
            EnumFacing face = (EnumFacing)NNList.FACING.get(rand.nextInt(NNList.FACING.size()));
            if (face.func_176740_k() != EnumFacing.Axis.Y && rand.nextBoolean()) {
                return pos.func_177972_a(face).func_177972_a(face.func_176746_e());
            }
            return pos.func_177972_a(face);
        }

        public float getFluidHeightForRender(IBlockAccess world, BlockPos pos, @Nonnull IBlockState up) {
            IBlockState down = world.func_180495_p(pos.func_177977_b());
            if (down.func_185904_a().func_76224_d() || down.func_177230_c() instanceof IFluidBlock) {
                return 1.0f;
            }
            return 0.995f;
        }
    }

    static class CloudSeedConcentrated
    extends BlockFluidEnder {
        protected CloudSeedConcentrated(@Nonnull Fluid fluid, @Nonnull Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 40, 0, true, true));
            }
            super.func_180634_a(world, pos, state, entity);
        }
    }

    static class LiquidSunshine
    extends BlockFluidEnder {
        protected LiquidSunshine(@Nonnull Fluid fluid, @Nonnull Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_188424_y, 50, 0, true, true));
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_188423_x, 1200, 0, true, true));
            }
            super.func_180634_a(world, pos, state, entity);
        }
    }

    static class NutrientDistillation
    extends BlockFluidEnder {
        protected NutrientDistillation(@Nonnull Fluid fluid, @Nonnull Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityPlayerMP) {
                long time = entity.field_70170_p.func_82737_E();
                EntityPlayerMP player = (EntityPlayerMP)entity;
                if (time % (long)((Integer)FluidConfig.nutrientFoodBoostDelay.get()).intValue() == 0L && player.getEntityData().func_74763_f("eioLastFoodBoost") != time) {
                    player.func_71024_bL().func_75122_a(1, 0.1f);
                    player.getEntityData().func_74772_a("eioLastFoodBoost", time);
                }
            }
            super.func_180634_a(world, pos, state, entity);
        }
    }

    static class RocketFuel
    extends BlockFluidEnder {
        protected RocketFuel(@Nonnull Fluid fluid, @Nonnull Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76430_j, 150, 3, true, true));
            }
            super.func_180634_a(world, pos, state, entity);
        }

        public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
            return true;
        }

        public boolean isFireSource(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            return true;
        }

        public int getFireSpreadSpeed(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
            return 60;
        }

        public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
            this.checkForFire(worldIn, pos);
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        }

        protected void checkForFire(final World worldIn, final BlockPos pos) {
            if (((Boolean)FluidConfig.rocketFuelIsExplosive.get()).booleanValue()) {
                NNList.FACING.apply((NNList.Callback)new NNList.Callback<EnumFacing>(){

                    public void apply(@Nonnull EnumFacing side) {
                        IBlockState neighbor = worldIn.func_180495_p(pos.func_177972_a(side));
                        if (neighbor.func_177230_c() instanceof BlockFire && neighbor.func_177230_c() != ModObject.blockColdFire.getBlock() && worldIn.field_73012_v.nextFloat() < 0.5f) {
                            ArrayList<BlockPos> explosions = new ArrayList<BlockPos>();
                            explosions.add(pos);
                            BlockPos up = pos.func_177984_a();
                            while (worldIn.func_180495_p(up).func_177230_c() instanceof RocketFuel) {
                                explosions.add(up);
                                up = up.func_177984_a();
                            }
                            if (this.isSourceBlock((IBlockAccess)worldIn, pos)) {
                                worldIn.func_72885_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 2.0f, true, true);
                            }
                            float strength = 0.5f;
                            for (BlockPos explosion : explosions) {
                                worldIn.func_72885_a(null, (double)((float)explosion.func_177958_n() + 0.5f), (double)((float)explosion.func_177956_o() + 0.5f), (double)((float)explosion.func_177952_p() + 0.5f), strength, true, true);
                                strength = Math.min(strength * 1.05f, 7.0f);
                            }
                            return;
                        }
                    }
                });
            }
        }

        public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
            this.checkForFire(world, pos);
            super.func_180650_b(world, pos, state, rand);
        }
    }

    static class Hootch
    extends BlockFluidEnder {
        protected Hootch(@Nonnull Fluid fluid, @Nonnull Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 150, 0, true, true));
            }
            super.func_180634_a(world, pos, state, entity);
        }

        public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
            return true;
        }

        public boolean isFireSource(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            return true;
        }

        public int getFlammability(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
            return 1;
        }

        public int getFireSpreadSpeed(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
            return 60;
        }
    }

    static class FireWater
    extends BlockFluidEnder {
        protected FireWater(@Nonnull Fluid fluid, @Nonnull Material material, int fogColor) {
            super(fluid, material, fogColor);
        }

        public void func_180634_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity) {
            super.func_180634_a(world, pos, state, entity);
        }

        public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
            return true;
        }

        public boolean isFireSource(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
            return true;
        }

        public int getFireSpreadSpeed(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
            return 60;
        }

        public Boolean isEntityInsideMaterial(@Nonnull IBlockAccess world, @Nonnull BlockPos blockpos, @Nonnull IBlockState iblockstate, @Nonnull Entity entity, double yToTest, @Nonnull Material materialIn, boolean testingHead) {
            return materialIn == Material.field_151587_i || materialIn == this.field_149764_J;
        }

        public void func_180645_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random random) {
            this.func_180650_b(world, pos, state, random);
            if (((Boolean)InfinityConfig.inWorldCraftingFireWaterEnabled.get()).booleanValue() && InfinityConfig.isEnabledInDimension(world.field_73011_w.getDimension()) && ((Things)InfinityConfig.bedrock.get()).contains(world.func_180495_p(pos.func_177977_b()).func_177230_c()) && RANDOM.nextFloat() <= ((Float)InfinityConfig.dropChanceFirewater.get()).floatValue()) {
                MaterialCraftingHandler.spawnInfinityPowder(world, pos);
            }
        }
    }
}

