/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Item;
import crazypants.enderio.base.config.recipes.xml.Potion;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;

public class Brewing
extends AbstractConditional {
    private Item input;
    private Potion in;
    private Potion out;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.input == null) {
                throw new InvalidRecipeConfigException("Missing <reagent>");
            }
            if (this.in == null) {
                throw new InvalidRecipeConfigException("Missing <input>");
            }
            if (this.out == null) {
                throw new InvalidRecipeConfigException("Missing <output>");
            }
            this.valid = this.input.isValid() && this.in.isValid() && this.out.isValid();
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <brewing>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        this.input.enforceValidity();
        this.in.enforceValidity();
        this.out.enforceValidity();
        if (this.input.getThing().isEmpty()) {
            throw new InvalidRecipeConfigException("Valid child elements are invalid in <brewing>");
        }
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (this.isValid() && this.isActive()) {
            Things thing = this.input.getThing();
            PotionType inPotion = this.in.getPotion();
            PotionType outPotion = this.out.getPotion();
            if (!thing.isEmpty() && inPotion != null && outPotion != null) {
                PotionHelper.func_193356_a((PotionType)inPotion, (Ingredient)thing.asIngredient(), (PotionType)outPotion);
            }
        }
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("reagent".equals(name) && this.input == null) {
            this.input = (Item)factory.read(new Item().setAllowDelaying(false), startElement);
            return true;
        }
        if ("input".equals(name) && this.in == null) {
            this.in = factory.read(new Potion(), startElement);
            return true;
        }
        if ("output".equals(name) && this.out == null) {
            this.out = factory.read(new Potion(), startElement);
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

