/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.update;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.update.UpdateChecker;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;

public class ThreadUpdateChecker
extends Thread {
    public ThreadUpdateChecker() {
        this.setName("Actually Additions Update Checker");
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        ActuallyAdditions.LOGGER.info("Starting Update Check...");
        try {
            URL newestURL = new URL("https://raw.githubusercontent.com/Ellpeck/ActuallyAdditions/master/update/updateVersions.properties");
            Properties updateProperties = new Properties();
            updateProperties.load(new InputStreamReader(newestURL.openStream()));
            String currentMcVersion = Util.getMcVersion();
            if (ConfigBoolValues.UPDATE_CHECK_VERSION_SPECIFIC.isEnabled()) {
                String newestVersionProp = updateProperties.getProperty(currentMcVersion);
                UpdateChecker.updateVersionInt = Integer.parseInt(newestVersionProp);
                UpdateChecker.updateVersionString = currentMcVersion + "-r" + newestVersionProp;
            } else {
                int highest = 0;
                String highestString = "";
                for (String updateMC : updateProperties.stringPropertyNames()) {
                    String updateVersion = updateProperties.getProperty(updateMC);
                    int update = Integer.parseInt(updateVersion);
                    if (highest >= update) continue;
                    highest = update;
                    highestString = updateMC + "-r" + updateVersion;
                }
                UpdateChecker.updateVersionInt = highest;
                UpdateChecker.updateVersionString = highestString;
            }
            String clientVersionString = Util.getMajorModVersion();
            int clientVersion = Integer.parseInt(clientVersionString.contains("_") ? clientVersionString.substring(0, clientVersionString.indexOf("_")) : clientVersionString);
            if (UpdateChecker.updateVersionInt > clientVersion) {
                UpdateChecker.needsUpdateNotify = true;
            }
            ActuallyAdditions.LOGGER.info("Update Check done!");
        }
        catch (Exception e) {
            ActuallyAdditions.LOGGER.error("Update Check failed!", (Throwable)e);
            UpdateChecker.checkFailed = true;
        }
        if (!UpdateChecker.checkFailed) {
            if (UpdateChecker.needsUpdateNotify) {
                ActuallyAdditions.LOGGER.info("There is an Update for Actually Additions available!");
                ActuallyAdditions.LOGGER.info("Current Version: 1.12.2-r147, newest Version: " + UpdateChecker.updateVersionString + "!");
                ActuallyAdditions.LOGGER.info("View the Changelog at http://ellpeck.de/actaddchangelog");
                ActuallyAdditions.LOGGER.info("Download at http://ellpeck.de/actadddownload");
            } else {
                ActuallyAdditions.LOGGER.info("Actually Additions is up to date!");
            }
        }
        UpdateChecker.threadFinished = true;
    }
}

